/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class AppClientArtifactEditFVTest
extends TestCase {
    private IProject appClientProject;
    private String appClientModuleName;

    public AppClientArtifactEditFVTest() {
        if (TestWorkspace.init()) {
            this.appClientProject = TestWorkspace.getTargetProject("ApplicationClientArtifactEditTest");
            this.appClientModuleName = "ApplicationClientModule";
        } else {
            AppClientArtifactEditFVTest.fail();
        }
    }

    public void testCreationDisposeFunction() {
        AppClientArtifactEdit edit = null;
        try {
            edit = AppClientArtifactEdit.getAppClientArtifactEditForWrite((IProject)this.appClientProject);
            edit.addListener(new EditModelListener(){

                public void editModelChanged(EditModelEvent anEvent) {
                    AppClientArtifactEditFVTest.this.pass();
                }
            });
            ApplicationClient client = edit.getApplicationClient();
            this.updateClient(client);
            edit.save((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private void updateClient(ApplicationClient client) {
        client.setDescription("FVT Description Test");
        client.setDisplayName("FVT DisplayName Test");
        client.setLargeIcon("fvtLargeIcon.gif");
    }

    private void pass() {
        AppClientArtifactEditFVTest.assertTrue((boolean)true);
    }

    public void testPersistenceFunction() {
        AppClientArtifactEdit edit = null;
        try {
            edit = AppClientArtifactEdit.getAppClientArtifactEditForWrite((IProject)this.appClientProject);
            ApplicationClient appClient = edit.getApplicationClient();
            AppClientArtifactEditFVTest.pass(appClient);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private static void pass(ApplicationClient appClient) {
        boolean pass = appClient.getDescription().equals("FVT Description Test") && appClient.getDisplayName().equals("FVT DisplayName Test") && appClient.getLargeIcon().equals("fvtLargeIcon.gif");
        AppClientArtifactEditFVTest.assertTrue((boolean)pass);
    }

    private void validateResource() {
        AppClientArtifactEdit edit = null;
        try {
            edit = AppClientArtifactEdit.getAppClientArtifactEditForWrite((IProject)this.appClientProject);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentResource createResourceComponent() {
        ComponentResource resourceComponent = ComponentcoreFactory.eINSTANCE.createComponentResource();
        File testFile = TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH.toFile();
        if (testFile.exists()) {
            resourceComponent.setRuntimePath(TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH);
            resourceComponent.setSourcePath(TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH);
        } else {
            AppClientArtifactEditFVTest.fail((String)"Missing: TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH");
        }
        return resourceComponent;
    }
}

