/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.Test0_7Workspace;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.internal.ModuleMigratorManager;

public class Migrate07EJBTest
extends TestCase {
    private IProject ejbProject;
    private IProject webProject;

    public Migrate07EJBTest() {
        if (Test0_7Workspace.init()) {
            this.ejbProject = Test0_7Workspace.getTargetProject("MyEarEJB");
            this.webProject = Test0_7Workspace.getTargetProject("TestWeb");
        } else {
            Migrate07EJBTest.fail();
        }
    }

    private void pass() {
        Migrate07EJBTest.assertTrue((boolean)true);
    }

    public String getFacetFromProject(IProject aProject) {
        return J2EEProjectUtilities.getJ2EEProjectType((IProject)aProject);
    }

    public void testMigrate() {
        EJBArtifactEdit ejbedit = null;
        WebArtifactEdit webEdit = null;
        try {
            ResourcesPlugin.getWorkspace().build(6, null);
        }
        catch (CoreException coreException) {}
        this.migrateProjects();
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        IJobManager manager = Platform.getJobManager();
        try {
            manager.beginRule(rule, null);
            try {
                ejbedit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
                if (ejbedit != null) {
                    EJBJar ejb = ejbedit.getEJBJar();
                    Migrate07EJBTest.assertTrue((ejb != null ? 1 : 0) != 0);
                }
                if ((webEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject)) != null) {
                    WebApp web = webEdit.getWebApp();
                    Migrate07EJBTest.assertTrue((web != null ? 1 : 0) != 0);
                }
            }
            finally {
                if (ejbedit != null) {
                    ejbedit.dispose();
                }
                if (webEdit != null) {
                    webEdit.dispose();
                }
            }
        }
        finally {
            manager.endRule(rule);
        }
    }

    private void migrateProjects() {
        ModuleMigratorManager manager = ModuleMigratorManager.getManager((IProject)this.ejbProject);
        if (!manager.isMigrating() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
            try {
                manager.migrateOldMetaData(this.ejbProject, true);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (!(manager = ModuleMigratorManager.getManager((IProject)this.webProject)).isMigrating() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
            try {
                manager.migrateOldMetaData(this.webProject, true);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

