/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.jee.model.internal.Ejb3MergedModelProviderFactory;

public class EJB3MergedModelProviderFactoryTest
extends TestCase {
    private Ejb3MergedModelProviderFactory fixture;

    public static Test suite() {
        TestSuite suite = new TestSuite(EJB3MergedModelProviderFactoryTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture = new Ejb3MergedModelProviderFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateForProject() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + this.getName());
        IModelProvider provider = this.fixture.create(project);
        EJB3MergedModelProviderFactoryTest.assertNotNull((Object)provider);
    }

    public void testSameProjectDisposedProvider() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + this.getName());
        IModelProvider provider = this.fixture.create(project);
        EJB3MergedModelProviderFactoryTest.assertFalse((boolean)provider.equals(this.fixture.create(project)));
        EJB3MergedModelProviderFactoryTest.assertNotSame((Object)provider, (Object)this.fixture.create(project));
    }

    public void testSameProject() throws Exception {
        IProject project = ProjectUtil.createEJBProject(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + this.getName(), null, 30, true);
        IModelProvider provider = this.fixture.create(project);
        provider.getModelObject();
        IModelProvider secondProvider = this.fixture.create(project);
        EJB3MergedModelProviderFactoryTest.assertEquals((Object)provider.getModelObject(), (Object)secondProvider.getModelObject());
        EJB3MergedModelProviderFactoryTest.assertEquals((Object)provider, (Object)secondProvider);
    }
}

