/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.mergers.tests;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.ejb.AssemblyDescriptor;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.jee.model.internal.mergers.AssemblyDescriptorMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class AssemblyDescriptorMergerTest
extends TestCase {
    public void testEmptySecurityRoleCase() throws ModelException {
        AssemblyDescriptor descriptorBase = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        AssemblyDescriptor descriptorToMerge = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        AssemblyDescriptorMerger result = new AssemblyDescriptorMerger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 0 ? 1 : 0) != 0);
    }

    public void testSingleSecurityRoleCaseBase() throws ModelException {
        AssemblyDescriptor descriptorBase = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        SecurityRole role = JavaeeFactory.eINSTANCE.createSecurityRole();
        role.setRoleName("test1");
        descriptorBase.getSecurityRoles().add(role);
        AssemblyDescriptor descriptorToMerge = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        AssemblyDescriptorMerger result = new AssemblyDescriptorMerger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((SecurityRole)descriptorBase.getSecurityRoles().get(0)).getRoleName().equals("test1"));
    }

    public void testSingleSecurityRoleCaseToMerge() throws ModelException {
        AssemblyDescriptor descriptorBase = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        AssemblyDescriptor descriptorToMerge = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        SecurityRole role = JavaeeFactory.eINSTANCE.createSecurityRole();
        role.setRoleName("test1");
        descriptorToMerge.getSecurityRoles().add(role);
        AssemblyDescriptorMerger result = new AssemblyDescriptorMerger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((SecurityRole)descriptorBase.getSecurityRoles().get(0)).getRoleName().equals("test1"));
    }

    public void testSingleSecurityRoleCaseSameRole() throws ModelException {
        AssemblyDescriptor descriptorBase = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        AssemblyDescriptor descriptorToMerge = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        SecurityRole role = JavaeeFactory.eINSTANCE.createSecurityRole();
        role.setRoleName("test1");
        descriptorBase.getSecurityRoles().add(role);
        descriptorToMerge.getSecurityRoles().add(role);
        AssemblyDescriptorMerger result = new AssemblyDescriptorMerger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((SecurityRole)descriptorBase.getSecurityRoles().get(0)).getRoleName().equals("test1"));
    }

    public void testSingleSecurityRoleCaseComplex() throws ModelException {
        AssemblyDescriptor descriptorBase = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        AssemblyDescriptor descriptorToMerge = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        SecurityRole role0 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role1 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role2 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role3 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role4 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role5 = JavaeeFactory.eINSTANCE.createSecurityRole();
        role0.setRoleName("test1");
        role1.setRoleName("test2");
        role2.setRoleName("test3");
        role3.setRoleName("test4");
        role4.setRoleName("test5");
        role5.setRoleName("test6");
        descriptorBase.getSecurityRoles().add(role1);
        descriptorBase.getSecurityRoles().add(role3);
        descriptorBase.getSecurityRoles().add(role4);
        descriptorBase.getSecurityRoles().add(role5);
        descriptorToMerge.getSecurityRoles().add(role0);
        descriptorToMerge.getSecurityRoles().add(role1);
        descriptorToMerge.getSecurityRoles().add(role2);
        AssemblyDescriptorMerger result = new AssemblyDescriptorMerger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role0.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role1.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role2.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role3.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role4.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role5.getRoleName()));
    }

    private boolean containsSecRole(List list, String roleName) {
        for (Object object : list) {
            SecurityRole role = (SecurityRole)object;
            if (!(roleName == null ? roleName == role.getRoleName() : roleName.equals(role.getRoleName()))) continue;
            return true;
        }
        return false;
    }

    public void testSingleSecurityRoleCaseComplexWithoutName() throws ModelException {
        AssemblyDescriptor descriptorBase = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        AssemblyDescriptor descriptorToMerge = EjbFactory.eINSTANCE.createAssemblyDescriptor();
        SecurityRole role0 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role1 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role2 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role3 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role4 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role5 = JavaeeFactory.eINSTANCE.createSecurityRole();
        role0.setRoleName("test1");
        role2.setRoleName("test3");
        role3.setRoleName("test4");
        role4.setRoleName("test5");
        role5.setRoleName("test6");
        descriptorBase.getSecurityRoles().add(role1);
        descriptorBase.getSecurityRoles().add(role3);
        descriptorBase.getSecurityRoles().add(role4);
        descriptorBase.getSecurityRoles().add(role5);
        descriptorToMerge.getSecurityRoles().add(role0);
        descriptorToMerge.getSecurityRoles().add(role1);
        descriptorToMerge.getSecurityRoles().add(role2);
        AssemblyDescriptorMerger result = new AssemblyDescriptorMerger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role0.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), null));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role2.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role3.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role4.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role5.getRoleName()));
    }
}

