/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.mergers.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.EjbRef;
import org.eclipse.jst.javaee.core.EjbRefType;
import org.eclipse.jst.javaee.core.EnvEntry;
import org.eclipse.jst.javaee.core.EnvEntryType;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.MessageDestinationRef;
import org.eclipse.jst.javaee.core.MessageDestinationUsageType;
import org.eclipse.jst.javaee.core.PersistenceContextRef;
import org.eclipse.jst.javaee.core.PersistenceContextType;
import org.eclipse.jst.javaee.core.PersistenceUnitRef;
import org.eclipse.jst.javaee.core.ResAuthType;
import org.eclipse.jst.javaee.core.ResSharingScopeType;
import org.eclipse.jst.javaee.core.ResourceEnvRef;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.ServiceRef;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.mergers.JNDIRefsMerger;

public class JndiRefsTest
extends TestCase {
    public void testResourceEnvRefsBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceEnvRef envRefBase = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefBase.setMappedName("mapped1");
        envRefBase.setResourceEnvRefName("refName1");
        envRefBase.setResourceEnvRefType("type1");
        ResourceEnvRef envRefToMerge = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefToMerge.setMappedName("mapped2");
        envRefToMerge.setResourceEnvRefName("refName2");
        envRefToMerge.setResourceEnvRefType("type2");
        beanBase.getResourceEnvRefs().add(envRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getResourceEnvRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getResourceEnvRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getResourceEnvRefType());
    }

    public void testResourceEnvRefsMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceEnvRef envRefBase = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefBase.setMappedName("mapped1");
        envRefBase.setResourceEnvRefName("refName1");
        envRefBase.setResourceEnvRefType("type1");
        ResourceEnvRef envRefToMerge = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefToMerge.setMappedName("mapped2");
        envRefToMerge.setResourceEnvRefName("refName2");
        envRefToMerge.setResourceEnvRefType("type2");
        beanToMerge.getResourceEnvRefs().add(envRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getResourceEnvRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getResourceEnvRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getResourceEnvRefType());
    }

    public void testResourceEnvRefsSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceEnvRef envRefBase = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefBase.setMappedName("mapped1");
        envRefBase.setResourceEnvRefName("refName1");
        envRefBase.setResourceEnvRefType("type1");
        ResourceEnvRef envRefToMerge = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefToMerge.setMappedName("mapped2");
        envRefToMerge.setResourceEnvRefName("refName2");
        envRefToMerge.setResourceEnvRefType("type2");
        beanBase.getResourceEnvRefs().add(envRefBase);
        beanToMerge.getResourceEnvRefs().add(envRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getResourceEnvRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getResourceEnvRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((ResourceEnvRef)beanBase.getResourceEnvRefs().get(0)).getResourceEnvRefType());
    }

    public void testResourceEnvRefsComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceEnvRef envRefBase = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefBase.setMappedName("mapped1");
        envRefBase.setResourceEnvRefName("refName1");
        envRefBase.setResourceEnvRefType("type1");
        ResourceEnvRef envRefToMerge = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefToMerge.setMappedName("mapped2");
        envRefToMerge.setResourceEnvRefName("refName2");
        envRefToMerge.setResourceEnvRefType("type2");
        beanBase.getResourceEnvRefs().add(envRefBase);
        beanToMerge.getResourceEnvRefs().add(envRefBase);
        beanToMerge.getResourceEnvRefs().add(envRefToMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getResourceEnvRefs().size());
        ResourceEnvRef test = this.getResEnvRef(beanBase.getResourceEnvRefs(), "refName1");
        ResourceEnvRef test2 = this.getResEnvRef(beanBase.getResourceEnvRefs(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"type1", (String)test.getResourceEnvRefType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((String)"type2", (String)test2.getResourceEnvRefType());
    }

    public void testResourceEnvRefsComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceEnvRef envRefBase = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefBase.setResourceEnvRefName("refName1");
        ResourceEnvRef envRefToMerge = JavaeeFactory.eINSTANCE.createResourceEnvRef();
        envRefToMerge.setMappedName("mapped2");
        envRefToMerge.setResourceEnvRefName("refName1");
        envRefToMerge.setResourceEnvRefType("type2");
        beanBase.getResourceEnvRefs().add(envRefBase);
        beanToMerge.getResourceEnvRefs().add(envRefBase);
        beanToMerge.getResourceEnvRefs().add(envRefToMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getResourceEnvRefs().size());
        ResourceEnvRef test = this.getResEnvRef(beanBase.getResourceEnvRefs(), "refName1");
        JndiRefsTest.assertEquals((String)"type2", (String)test.getResourceEnvRefType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
    }

    private ResourceEnvRef getResEnvRef(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            ResourceEnvRef ref = (ResourceEnvRef)object;
            if (!name.equals(ref.getResourceEnvRefName())) continue;
            return ref;
        }
        return null;
    }

    public void testResourceRefsBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceRef resRefBase = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefBase.setMappedName("mapped1");
        resRefBase.setResRefName("refName1");
        resRefBase.setResType("type1");
        resRefBase.setResAuth(ResAuthType.APPLICATION_LITERAL);
        resRefBase.setResSharingScope(ResSharingScopeType.SHAREABLE_LITERAL);
        ResourceRef resRefToMerge = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefToMerge.setMappedName("mapped2");
        resRefToMerge.setResRefName("refName2");
        resRefToMerge.setResType("type2");
        resRefToMerge.setResAuth(ResAuthType.CONTAINER_LITERAL);
        resRefToMerge.setResSharingScope(ResSharingScopeType.UNSHAREABLE_LITERAL);
        beanBase.getResourceRefs().add(resRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getResourceRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getResRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getResType());
        JndiRefsTest.assertEquals((Object)ResAuthType.APPLICATION_LITERAL, (Object)((ResourceRef)beanBase.getResourceRefs().get(0)).getResAuth());
        JndiRefsTest.assertEquals((Object)ResSharingScopeType.SHAREABLE_LITERAL, (Object)((ResourceRef)beanBase.getResourceRefs().get(0)).getResSharingScope());
    }

    public void testResourceRefsMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceRef resRefBase = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefBase.setMappedName("mapped1");
        resRefBase.setResRefName("refName1");
        resRefBase.setResType("type1");
        resRefBase.setResAuth(ResAuthType.APPLICATION_LITERAL);
        resRefBase.setResSharingScope(ResSharingScopeType.SHAREABLE_LITERAL);
        ResourceRef resRefToMerge = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefToMerge.setMappedName("mapped2");
        resRefToMerge.setResRefName("refName2");
        resRefToMerge.setResType("type2");
        resRefToMerge.setResAuth(ResAuthType.CONTAINER_LITERAL);
        resRefToMerge.setResSharingScope(ResSharingScopeType.UNSHAREABLE_LITERAL);
        beanToMerge.getResourceRefs().add(resRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getResourceRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getResRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getResType());
        JndiRefsTest.assertEquals((Object)ResAuthType.APPLICATION_LITERAL, (Object)((ResourceRef)beanBase.getResourceRefs().get(0)).getResAuth());
        JndiRefsTest.assertEquals((Object)ResSharingScopeType.SHAREABLE_LITERAL, (Object)((ResourceRef)beanBase.getResourceRefs().get(0)).getResSharingScope());
    }

    public void testResourceRefsSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceRef resRefBase = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefBase.setMappedName("mapped1");
        resRefBase.setResRefName("refName1");
        resRefBase.setResType("type1");
        resRefBase.setResAuth(ResAuthType.APPLICATION_LITERAL);
        resRefBase.setResSharingScope(ResSharingScopeType.SHAREABLE_LITERAL);
        ResourceRef resRefToMerge = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefToMerge.setMappedName("mapped2");
        resRefToMerge.setResRefName("refName2");
        resRefToMerge.setResType("type2");
        resRefToMerge.setResAuth(ResAuthType.CONTAINER_LITERAL);
        resRefToMerge.setResSharingScope(ResSharingScopeType.UNSHAREABLE_LITERAL);
        beanBase.getResourceRefs().add(resRefBase);
        beanToMerge.getResourceRefs().add(resRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getResourceRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getResRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((ResourceRef)beanBase.getResourceRefs().get(0)).getResType());
        JndiRefsTest.assertEquals((Object)ResAuthType.APPLICATION_LITERAL, (Object)((ResourceRef)beanBase.getResourceRefs().get(0)).getResAuth());
        JndiRefsTest.assertEquals((Object)ResSharingScopeType.SHAREABLE_LITERAL, (Object)((ResourceRef)beanBase.getResourceRefs().get(0)).getResSharingScope());
    }

    public void testResourceRefsComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceRef resRefBase = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefBase.setMappedName("mapped1");
        resRefBase.setResRefName("refName1");
        resRefBase.setResType("type1");
        resRefBase.setResAuth(ResAuthType.APPLICATION_LITERAL);
        resRefBase.setResSharingScope(ResSharingScopeType.SHAREABLE_LITERAL);
        ResourceRef resRefToMerge = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefToMerge.setMappedName("mapped2");
        resRefToMerge.setResRefName("refName2");
        resRefToMerge.setResType("type2");
        resRefToMerge.setResAuth(ResAuthType.CONTAINER_LITERAL);
        resRefToMerge.setResSharingScope(ResSharingScopeType.UNSHAREABLE_LITERAL);
        beanBase.getResourceRefs().add(resRefBase);
        beanToMerge.getResourceRefs().add(resRefBase);
        beanToMerge.getResourceRefs().add(resRefToMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getResourceRefs().size());
        ResourceRef test = this.getResRef(beanBase.getResourceRefs(), "refName1");
        ResourceRef test2 = this.getResRef(beanBase.getResourceRefs(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"type1", (String)test.getResType());
        JndiRefsTest.assertEquals((Object)ResAuthType.APPLICATION_LITERAL, (Object)test.getResAuth());
        JndiRefsTest.assertEquals((Object)ResSharingScopeType.SHAREABLE_LITERAL, (Object)test.getResSharingScope());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((String)"type2", (String)test2.getResType());
        JndiRefsTest.assertEquals((Object)ResAuthType.CONTAINER_LITERAL, (Object)test2.getResAuth());
        JndiRefsTest.assertEquals((Object)ResSharingScopeType.UNSHAREABLE_LITERAL, (Object)test2.getResSharingScope());
    }

    public void testResourceRefsComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ResourceRef envRefBase = JavaeeFactory.eINSTANCE.createResourceRef();
        envRefBase.setResRefName("refName1");
        ResourceRef resRefToMerge = JavaeeFactory.eINSTANCE.createResourceRef();
        resRefToMerge.setMappedName("mapped2");
        resRefToMerge.setResRefName("refName1");
        resRefToMerge.setResType("type2");
        resRefToMerge.setResAuth(ResAuthType.CONTAINER_LITERAL);
        resRefToMerge.setResSharingScope(ResSharingScopeType.UNSHAREABLE_LITERAL);
        beanBase.getResourceRefs().add(envRefBase);
        beanToMerge.getResourceRefs().add(envRefBase);
        beanToMerge.getResourceRefs().add(resRefToMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getResourceRefs().size());
        ResourceRef test = this.getResRef(beanBase.getResourceRefs(), "refName1");
        JndiRefsTest.assertEquals((String)"type2", (String)test.getResType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
        JndiRefsTest.assertEquals((Object)ResAuthType.CONTAINER_LITERAL, (Object)test.getResAuth());
        JndiRefsTest.assertEquals((Object)ResSharingScopeType.UNSHAREABLE_LITERAL, (Object)test.getResSharingScope());
    }

    private ResourceRef getResRef(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            ResourceRef ref = (ResourceRef)object;
            if (!name.equals(ref.getResRefName())) continue;
            return ref;
        }
        return null;
    }

    public void testServiceRefBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ServiceRef serviceRefBase = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefBase.setMappedName("mapped1");
        serviceRefBase.setServiceRefName("refName1");
        serviceRefBase.setServiceInterface("interface1");
        serviceRefBase.setWsdlFile("file1");
        ServiceRef serviceRefMerge = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefMerge.setMappedName("mapped2");
        serviceRefMerge.setServiceRefName("refName2");
        serviceRefMerge.setServiceInterface("interface2");
        serviceRefMerge.setWsdlFile("file2");
        beanBase.getServiceRefs().add(serviceRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getServiceRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getServiceRefName());
        JndiRefsTest.assertEquals((String)"interface1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getServiceInterface());
        JndiRefsTest.assertEquals((String)"file1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getWsdlFile());
    }

    public void testServiceRefsMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ServiceRef serviceRefBase = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefBase.setMappedName("mapped1");
        serviceRefBase.setServiceRefName("refName1");
        serviceRefBase.setServiceInterface("interface1");
        serviceRefBase.setWsdlFile("file1");
        ServiceRef serviceRefMerge = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefMerge.setMappedName("mapped2");
        serviceRefMerge.setServiceRefName("refName2");
        serviceRefMerge.setServiceInterface("interface2");
        serviceRefMerge.setWsdlFile("file2");
        beanToMerge.getServiceRefs().add(serviceRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getServiceRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getServiceRefName());
        JndiRefsTest.assertEquals((String)"interface1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getServiceInterface());
        JndiRefsTest.assertEquals((String)"file1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getWsdlFile());
    }

    public void testServiceRefsSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ServiceRef serviceRefBase = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefBase.setMappedName("mapped1");
        serviceRefBase.setServiceRefName("refName1");
        serviceRefBase.setServiceInterface("interface1");
        serviceRefBase.setWsdlFile("file1");
        ServiceRef resRefToMerge = JavaeeFactory.eINSTANCE.createServiceRef();
        resRefToMerge.setMappedName("mapped2");
        resRefToMerge.setServiceRefName("refName2");
        resRefToMerge.setServiceInterface("interface2");
        resRefToMerge.setWsdlFile("file2");
        beanBase.getServiceRefs().add(serviceRefBase);
        beanToMerge.getServiceRefs().add(serviceRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getServiceRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getServiceRefName());
        JndiRefsTest.assertEquals((String)"interface1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getServiceInterface());
        JndiRefsTest.assertEquals((String)"file1", (String)((ServiceRef)beanBase.getServiceRefs().get(0)).getWsdlFile());
    }

    public void testServiceRefsComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ServiceRef serviceRefBase = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefBase.setMappedName("mapped1");
        serviceRefBase.setServiceRefName("refName1");
        serviceRefBase.setServiceInterface("interface1");
        serviceRefBase.setWsdlFile("file1");
        ServiceRef serviceRefMerge = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefMerge.setMappedName("mapped2");
        serviceRefMerge.setServiceRefName("refName2");
        serviceRefMerge.setServiceInterface("interface2");
        serviceRefMerge.setWsdlFile("file2");
        beanBase.getServiceRefs().add(serviceRefBase);
        beanToMerge.getServiceRefs().add(serviceRefBase);
        beanToMerge.getServiceRefs().add(serviceRefMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getServiceRefs().size());
        ServiceRef test = this.getServiceRef(beanBase.getServiceRefs(), "refName1");
        ServiceRef test2 = this.getServiceRef(beanBase.getServiceRefs(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"interface1", (String)test.getServiceInterface());
        JndiRefsTest.assertEquals((String)"file1", (String)test.getWsdlFile());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((String)"interface2", (String)test2.getServiceInterface());
        JndiRefsTest.assertEquals((String)"file2", (String)test2.getWsdlFile());
    }

    public void testServiceRefsComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        ServiceRef serviceRefBase = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefBase.setServiceRefName("refName1");
        ServiceRef serviceRefMerge = JavaeeFactory.eINSTANCE.createServiceRef();
        serviceRefMerge.setMappedName("mapped2");
        serviceRefMerge.setServiceRefName("refName1");
        serviceRefMerge.setServiceInterface("interface2");
        serviceRefMerge.setWsdlFile("file2");
        beanBase.getServiceRefs().add(serviceRefBase);
        beanToMerge.getServiceRefs().add(serviceRefBase);
        beanToMerge.getServiceRefs().add(serviceRefMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getServiceRefs().size());
        ServiceRef test = this.getServiceRef(beanBase.getServiceRefs(), "refName1");
        JndiRefsTest.assertEquals((String)"interface2", (String)test.getServiceInterface());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"file2", (String)test.getWsdlFile());
    }

    private ServiceRef getServiceRef(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            ServiceRef ref = (ServiceRef)object;
            if (!name.equals(ref.getServiceRefName())) continue;
            return ref;
        }
        return null;
    }

    public void testPersistenceUnitRefsBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceUnitRef persistenceUnitRefBase = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefBase.setMappedName("mapped1");
        persistenceUnitRefBase.setPersistenceUnitRefName("refName1");
        persistenceUnitRefBase.setPersistenceUnitName("type1");
        PersistenceUnitRef persistenceUnitRefMerge = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefMerge.setMappedName("mapped2");
        persistenceUnitRefMerge.setPersistenceUnitRefName("refName2");
        persistenceUnitRefMerge.setPersistenceUnitName("type2");
        beanBase.getPersistenceUnitRefs().add(persistenceUnitRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getPersistenceUnitRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getPersistenceUnitRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getPersistenceUnitName());
    }

    public void testPersistenceUnitRefsMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceUnitRef persistenceUnitRefBase = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefBase.setMappedName("mapped1");
        persistenceUnitRefBase.setPersistenceUnitRefName("refName1");
        persistenceUnitRefBase.setPersistenceUnitName("type1");
        PersistenceUnitRef persistenceUnitRefMerge = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefMerge.setMappedName("mapped2");
        persistenceUnitRefMerge.setPersistenceUnitRefName("refName2");
        persistenceUnitRefMerge.setPersistenceUnitName("type2");
        beanToMerge.getPersistenceUnitRefs().add(persistenceUnitRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getPersistenceUnitRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getPersistenceUnitRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getPersistenceUnitName());
    }

    public void testPersistenceUnitRefsSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceUnitRef persistenceUnitRefBase = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefBase.setMappedName("mapped1");
        persistenceUnitRefBase.setPersistenceUnitRefName("refName1");
        persistenceUnitRefBase.setPersistenceUnitName("type1");
        PersistenceUnitRef persistenceUnitRefMerge = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefMerge.setMappedName("mapped2");
        persistenceUnitRefMerge.setPersistenceUnitRefName("refName2");
        persistenceUnitRefMerge.setPersistenceUnitName("type2");
        beanBase.getPersistenceUnitRefs().add(persistenceUnitRefBase);
        beanToMerge.getPersistenceUnitRefs().add(persistenceUnitRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getPersistenceUnitRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getPersistenceUnitRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((PersistenceUnitRef)beanBase.getPersistenceUnitRefs().get(0)).getPersistenceUnitName());
    }

    public void testPersistenceUnitRefsComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceUnitRef persistenceUnitRefBase = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefBase.setMappedName("mapped1");
        persistenceUnitRefBase.setPersistenceUnitRefName("refName1");
        persistenceUnitRefBase.setPersistenceUnitName("type1");
        PersistenceUnitRef persistenceUnitRefMerge = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefMerge.setMappedName("mapped2");
        persistenceUnitRefMerge.setPersistenceUnitRefName("refName2");
        persistenceUnitRefMerge.setPersistenceUnitName("type2");
        beanBase.getPersistenceUnitRefs().add(persistenceUnitRefBase);
        beanToMerge.getPersistenceUnitRefs().add(persistenceUnitRefBase);
        beanToMerge.getPersistenceUnitRefs().add(persistenceUnitRefMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getPersistenceUnitRefs().size());
        PersistenceUnitRef test = this.getPersistUnitRef(beanBase.getPersistenceUnitRefs(), "refName1");
        PersistenceUnitRef test2 = this.getPersistUnitRef(beanBase.getPersistenceUnitRefs(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"type1", (String)test.getPersistenceUnitName());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((String)"type2", (String)test2.getPersistenceUnitName());
    }

    public void testPersistenceUnitRefsComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceUnitRef persistenceUnitRefBase = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefBase.setPersistenceUnitRefName("refName1");
        PersistenceUnitRef persistenceUnitRefMerge = JavaeeFactory.eINSTANCE.createPersistenceUnitRef();
        persistenceUnitRefMerge.setMappedName("mapped2");
        persistenceUnitRefMerge.setPersistenceUnitRefName("refName1");
        persistenceUnitRefMerge.setPersistenceUnitName("type2");
        beanBase.getPersistenceUnitRefs().add(persistenceUnitRefBase);
        beanToMerge.getPersistenceUnitRefs().add(persistenceUnitRefBase);
        beanToMerge.getPersistenceUnitRefs().add(persistenceUnitRefMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getPersistenceUnitRefs().size());
        PersistenceUnitRef test = this.getPersistUnitRef(beanBase.getPersistenceUnitRefs(), "refName1");
        JndiRefsTest.assertEquals((String)"type2", (String)test.getPersistenceUnitName());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
    }

    private PersistenceUnitRef getPersistUnitRef(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            PersistenceUnitRef ref = (PersistenceUnitRef)object;
            if (!name.equals(ref.getPersistenceUnitRefName())) continue;
            return ref;
        }
        return null;
    }

    public void testPersistenceContextRefsBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceContextRef persistenceContextRefBase = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefBase.setMappedName("mapped1");
        persistenceContextRefBase.setPersistenceContextRefName("refName1");
        persistenceContextRefBase.setPersistenceContextType(PersistenceContextType.EXTENDED_LITERAL);
        PersistenceContextRef persistenceContextRefMerge = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefMerge.setMappedName("mapped2");
        persistenceContextRefMerge.setPersistenceContextRefName("refName2");
        persistenceContextRefMerge.setPersistenceContextType(PersistenceContextType.TRANSACTION_LITERAL);
        beanBase.getPersistenceContextRefs().add(persistenceContextRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getPersistenceContextRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getPersistenceContextRefName());
        JndiRefsTest.assertEquals((Object)PersistenceContextType.EXTENDED_LITERAL, (Object)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getPersistenceContextType());
    }

    public void testPersistenceContextRefsMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceContextRef persistenceContextRefBase = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefBase.setMappedName("mapped1");
        persistenceContextRefBase.setPersistenceContextRefName("refName1");
        persistenceContextRefBase.setPersistenceContextType(PersistenceContextType.EXTENDED_LITERAL);
        PersistenceContextRef persistenceContextRefMerge = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefMerge.setMappedName("mapped2");
        persistenceContextRefMerge.setPersistenceContextRefName("refName2");
        persistenceContextRefMerge.setPersistenceContextType(PersistenceContextType.TRANSACTION_LITERAL);
        beanToMerge.getPersistenceContextRefs().add(persistenceContextRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getPersistenceContextRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getPersistenceContextRefName());
        JndiRefsTest.assertEquals((Object)PersistenceContextType.EXTENDED_LITERAL, (Object)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getPersistenceContextType());
    }

    public void testPersistenceContextRefsSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceContextRef persistenceContextRefBase = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefBase.setMappedName("mapped1");
        persistenceContextRefBase.setPersistenceContextRefName("refName1");
        persistenceContextRefBase.setPersistenceContextType(PersistenceContextType.EXTENDED_LITERAL);
        PersistenceContextRef persistenceContextRefMerge = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefMerge.setMappedName("mapped2");
        persistenceContextRefMerge.setPersistenceContextRefName("refName2");
        persistenceContextRefMerge.setPersistenceContextType(PersistenceContextType.TRANSACTION_LITERAL);
        beanBase.getPersistenceContextRefs().add(persistenceContextRefBase);
        beanToMerge.getPersistenceContextRefs().add(persistenceContextRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getPersistenceContextRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getPersistenceContextRefName());
        JndiRefsTest.assertEquals((Object)PersistenceContextType.EXTENDED_LITERAL, (Object)((PersistenceContextRef)beanBase.getPersistenceContextRefs().get(0)).getPersistenceContextType());
    }

    public void testPersistenceContextRefsComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceContextRef persistenceContextRefBase = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefBase.setMappedName("mapped1");
        persistenceContextRefBase.setPersistenceContextRefName("refName1");
        persistenceContextRefBase.setPersistenceContextType(PersistenceContextType.EXTENDED_LITERAL);
        PersistenceContextRef persistenceContextRefMerge = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefMerge.setMappedName("mapped2");
        persistenceContextRefMerge.setPersistenceContextRefName("refName2");
        persistenceContextRefMerge.setPersistenceContextType(PersistenceContextType.TRANSACTION_LITERAL);
        beanBase.getPersistenceContextRefs().add(persistenceContextRefBase);
        beanToMerge.getPersistenceContextRefs().add(persistenceContextRefBase);
        beanToMerge.getPersistenceContextRefs().add(persistenceContextRefMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getPersistenceContextRefs().size());
        PersistenceContextRef test = this.getPersistenceCintextRef(beanBase.getPersistenceContextRefs(), "refName1");
        PersistenceContextRef test2 = this.getPersistenceCintextRef(beanBase.getPersistenceContextRefs(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((Object)PersistenceContextType.EXTENDED_LITERAL, (Object)test.getPersistenceContextType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((Object)PersistenceContextType.TRANSACTION_LITERAL, (Object)test2.getPersistenceContextType());
    }

    public void testPersistenceContextRefsComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        PersistenceContextRef persistenceContextRefBase = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefBase.setPersistenceContextRefName("refName1");
        PersistenceContextRef persistenceContextRefMerge = JavaeeFactory.eINSTANCE.createPersistenceContextRef();
        persistenceContextRefMerge.setMappedName("mapped2");
        persistenceContextRefMerge.setPersistenceContextRefName("refName1");
        persistenceContextRefMerge.setPersistenceContextType(PersistenceContextType.TRANSACTION_LITERAL);
        beanBase.getPersistenceContextRefs().add(persistenceContextRefBase);
        beanToMerge.getPersistenceContextRefs().add(persistenceContextRefBase);
        beanToMerge.getPersistenceContextRefs().add(persistenceContextRefMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getPersistenceContextRefs().size());
        PersistenceContextRef test = this.getPersistenceCintextRef(beanBase.getPersistenceContextRefs(), "refName1");
        JndiRefsTest.assertEquals((Object)PersistenceContextType.TRANSACTION_LITERAL, (Object)test.getPersistenceContextType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
    }

    private PersistenceContextRef getPersistenceCintextRef(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            PersistenceContextRef ref = (PersistenceContextRef)object;
            if (!name.equals(ref.getPersistenceContextRefName())) continue;
            return ref;
        }
        return null;
    }

    public void testMessageDestinationRefsBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        MessageDestinationRef messageDestRefBase = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefBase.setMappedName("mapped1");
        messageDestRefBase.setMessageDestinationRefName("refName1");
        messageDestRefBase.setMessageDestinationType("type1");
        messageDestRefBase.setMessageDestinationLink("link1");
        messageDestRefBase.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_LITERAL);
        MessageDestinationRef messageDestRefMerge = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefMerge.setMappedName("mapped2");
        messageDestRefMerge.setMessageDestinationRefName("refName2");
        messageDestRefMerge.setMessageDestinationType("type2");
        messageDestRefMerge.setMessageDestinationLink("link2");
        messageDestRefMerge.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_PRODUCES_LITERAL);
        beanBase.getMessageDestinationRefs().add(messageDestRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getMessageDestinationRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationType());
        JndiRefsTest.assertEquals((String)"link1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationLink());
        JndiRefsTest.assertEquals((Object)MessageDestinationUsageType.CONSUMES_LITERAL, (Object)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationUsage());
    }

    public void testMessageDestinationRefsMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        MessageDestinationRef messageDestRefBase = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefBase.setMappedName("mapped1");
        messageDestRefBase.setMessageDestinationRefName("refName1");
        messageDestRefBase.setMessageDestinationType("type1");
        messageDestRefBase.setMessageDestinationLink("link1");
        messageDestRefBase.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_LITERAL);
        MessageDestinationRef messageDestRefMerge = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefMerge.setMappedName("mapped2");
        messageDestRefMerge.setMessageDestinationRefName("refName2");
        messageDestRefMerge.setMessageDestinationType("type2");
        messageDestRefMerge.setMessageDestinationLink("link2");
        messageDestRefMerge.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_PRODUCES_LITERAL);
        beanToMerge.getMessageDestinationRefs().add(messageDestRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getMessageDestinationRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationType());
        JndiRefsTest.assertEquals((String)"link1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationLink());
        JndiRefsTest.assertEquals((Object)MessageDestinationUsageType.CONSUMES_LITERAL, (Object)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationUsage());
    }

    public void testMessageDestinationRefsSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        MessageDestinationRef messageDestRefBase = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefBase.setMappedName("mapped1");
        messageDestRefBase.setMessageDestinationRefName("refName1");
        messageDestRefBase.setMessageDestinationType("type1");
        messageDestRefBase.setMessageDestinationLink("link1");
        messageDestRefBase.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_LITERAL);
        MessageDestinationRef messageDestRefMerge = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefMerge.setMappedName("mapped2");
        messageDestRefMerge.setMessageDestinationRefName("refName2");
        messageDestRefMerge.setMessageDestinationType("type2");
        messageDestRefMerge.setMessageDestinationLink("link2");
        messageDestRefMerge.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_PRODUCES_LITERAL);
        beanBase.getMessageDestinationRefs().add(messageDestRefBase);
        beanToMerge.getMessageDestinationRefs().add(messageDestRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getMessageDestinationRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationRefName());
        JndiRefsTest.assertEquals((String)"type1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationType());
        JndiRefsTest.assertEquals((String)"link1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationLink());
        JndiRefsTest.assertEquals((Object)MessageDestinationUsageType.CONSUMES_LITERAL, (Object)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationUsage());
    }

    public void testMessageDestinationRefsComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        MessageDestinationRef messageDestRefBase = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefBase.setMappedName("mapped1");
        messageDestRefBase.setMessageDestinationRefName("refName1");
        messageDestRefBase.setMessageDestinationType("type1");
        messageDestRefBase.setMessageDestinationLink("link1");
        messageDestRefBase.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_LITERAL);
        MessageDestinationRef messageDestRefMerge = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefMerge.setMappedName("mapped2");
        messageDestRefMerge.setMessageDestinationRefName("refName2");
        messageDestRefMerge.setMessageDestinationType("type2");
        messageDestRefMerge.setMessageDestinationLink("link2");
        messageDestRefMerge.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_PRODUCES_LITERAL);
        beanBase.getMessageDestinationRefs().add(messageDestRefBase);
        beanToMerge.getMessageDestinationRefs().add(messageDestRefBase);
        beanToMerge.getMessageDestinationRefs().add(messageDestRefMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getMessageDestinationRefs().size());
        MessageDestinationRef test = this.getMessageRef(beanBase.getMessageDestinationRefs(), "refName1");
        MessageDestinationRef test2 = this.getMessageRef(beanBase.getMessageDestinationRefs(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"type1", (String)test.getMessageDestinationType());
        JndiRefsTest.assertEquals((String)"link1", (String)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationLink());
        JndiRefsTest.assertEquals((Object)MessageDestinationUsageType.CONSUMES_LITERAL, (Object)((MessageDestinationRef)beanBase.getMessageDestinationRefs().get(0)).getMessageDestinationUsage());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((String)"type2", (String)test2.getMessageDestinationType());
        JndiRefsTest.assertEquals((String)"link2", (String)test2.getMessageDestinationLink());
        JndiRefsTest.assertEquals((Object)MessageDestinationUsageType.CONSUMES_PRODUCES_LITERAL, (Object)test2.getMessageDestinationUsage());
    }

    public void testMessageDestinationRefsComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        MessageDestinationRef messageDestRefBase = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefBase.setMessageDestinationRefName("refName1");
        MessageDestinationRef messageDestRefMerge = JavaeeFactory.eINSTANCE.createMessageDestinationRef();
        messageDestRefMerge.setMappedName("mapped2");
        messageDestRefMerge.setMessageDestinationRefName("refName1");
        messageDestRefMerge.setMessageDestinationType("type2");
        messageDestRefMerge.setMessageDestinationLink("link2");
        messageDestRefMerge.setMessageDestinationUsage(MessageDestinationUsageType.CONSUMES_PRODUCES_LITERAL);
        beanBase.getMessageDestinationRefs().add(messageDestRefBase);
        beanToMerge.getMessageDestinationRefs().add(messageDestRefBase);
        beanToMerge.getMessageDestinationRefs().add(messageDestRefMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getMessageDestinationRefs().size());
        MessageDestinationRef test = this.getMessageRef(beanBase.getMessageDestinationRefs(), "refName1");
        JndiRefsTest.assertEquals((String)"type2", (String)test.getMessageDestinationType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"link2", (String)test.getMessageDestinationLink());
        JndiRefsTest.assertEquals((Object)MessageDestinationUsageType.CONSUMES_PRODUCES_LITERAL, (Object)test.getMessageDestinationUsage());
    }

    private MessageDestinationRef getMessageRef(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            MessageDestinationRef ref = (MessageDestinationRef)object;
            if (!name.equals(ref.getMessageDestinationRefName())) continue;
            return ref;
        }
        return null;
    }

    public void testEjbRefsBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EjbRef ejbRefBase = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefBase.setMappedName("mapped1");
        ejbRefBase.setEjbRefName("refName1");
        ejbRefBase.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbRefBase.setEjbLink("link1");
        ejbRefBase.setHome("home1");
        ejbRefBase.setRemote("remote1");
        EjbRef ejbRefToMerge = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefToMerge.setMappedName("mapped2");
        ejbRefToMerge.setEjbRefName("refName2");
        ejbRefToMerge.setEjbRefType(EjbRefType.ENTITY_LITERAL);
        ejbRefToMerge.setEjbLink("link2");
        ejbRefToMerge.setHome("home2");
        ejbRefToMerge.setRemote("remote2");
        beanBase.getEjbRefs().add(ejbRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEjbRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbRefName());
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbRefType());
        JndiRefsTest.assertEquals((String)"link1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbLink());
        JndiRefsTest.assertEquals((String)"home1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getHome());
        JndiRefsTest.assertEquals((String)"remote1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getRemote());
    }

    public void testEjbRefsMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EjbRef ejbRefBase = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefBase.setMappedName("mapped1");
        ejbRefBase.setEjbRefName("refName1");
        ejbRefBase.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbRefBase.setEjbLink("link1");
        ejbRefBase.setHome("home1");
        ejbRefBase.setRemote("remote1");
        EjbRef ejbRefToMerge = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefToMerge.setMappedName("mapped2");
        ejbRefToMerge.setEjbRefName("refName2");
        ejbRefToMerge.setEjbRefType(EjbRefType.ENTITY_LITERAL);
        ejbRefToMerge.setEjbLink("link2");
        ejbRefToMerge.setHome("home2");
        ejbRefToMerge.setRemote("remote2");
        beanToMerge.getEjbRefs().add(ejbRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEjbRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbRefName());
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbRefType());
        JndiRefsTest.assertEquals((String)"link1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbLink());
        JndiRefsTest.assertEquals((String)"home1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getHome());
        JndiRefsTest.assertEquals((String)"remote1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getRemote());
    }

    public void testEjbRefsSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EjbRef ejbRefBase = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefBase.setMappedName("mapped1");
        ejbRefBase.setEjbRefName("refName1");
        ejbRefBase.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbRefBase.setEjbLink("link1");
        ejbRefBase.setHome("home1");
        ejbRefBase.setRemote("remote1");
        EjbRef ejbRefToMerge = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefToMerge.setMappedName("mapped2");
        ejbRefToMerge.setEjbRefName("refName2");
        ejbRefToMerge.setEjbRefType(EjbRefType.ENTITY_LITERAL);
        ejbRefToMerge.setEjbLink("link2");
        ejbRefToMerge.setHome("home2");
        ejbRefToMerge.setRemote("remote2");
        beanBase.getEjbRefs().add(ejbRefBase);
        beanToMerge.getEjbRefs().add(ejbRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEjbRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbRefName());
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbRefType());
        JndiRefsTest.assertEquals((String)"link1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbLink());
        JndiRefsTest.assertEquals((String)"home1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getHome());
        JndiRefsTest.assertEquals((String)"remote1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getRemote());
    }

    public void testEjbRefsComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EjbRef ejbRefBase = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefBase.setMappedName("mapped1");
        ejbRefBase.setEjbRefName("refName1");
        ejbRefBase.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbRefBase.setEjbLink("link1");
        ejbRefBase.setHome("home1");
        ejbRefBase.setRemote("remote1");
        EjbRef ejbRefToMerge = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefToMerge.setMappedName("mapped2");
        ejbRefToMerge.setEjbRefName("refName2");
        ejbRefToMerge.setEjbRefType(EjbRefType.ENTITY_LITERAL);
        ejbRefToMerge.setEjbLink("link2");
        ejbRefToMerge.setHome("home2");
        ejbRefToMerge.setRemote("remote2");
        beanBase.getEjbRefs().add(ejbRefBase);
        beanToMerge.getEjbRefs().add(ejbRefBase);
        beanToMerge.getEjbRefs().add(ejbRefToMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getEjbRefs().size());
        EjbRef test = this.getEjbRef(beanBase.getEjbRefs(), "refName1");
        EjbRef test2 = this.getEjbRef(beanBase.getEjbRefs(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)test.getEjbRefType());
        JndiRefsTest.assertEquals((String)"link1", (String)((EjbRef)beanBase.getEjbRefs().get(0)).getEjbLink());
        JndiRefsTest.assertEquals((String)"home1", (String)test.getHome());
        JndiRefsTest.assertEquals((String)"remote1", (String)test.getRemote());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((Object)EjbRefType.ENTITY_LITERAL, (Object)test2.getEjbRefType());
        JndiRefsTest.assertEquals((String)"link2", (String)test2.getEjbLink());
        JndiRefsTest.assertEquals((String)"home2", (String)test2.getHome());
        JndiRefsTest.assertEquals((String)"remote2", (String)test2.getRemote());
    }

    public void testEjbRefsComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToLink = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        beanToLink.setEjbName("name");
        EjbRef ejbRefBase = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefBase.setEjbRefName("refName1");
        EjbRef ejbRefToMerge = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefToMerge.setMappedName("mapped2");
        ejbRefToMerge.setEjbRefName("refName1");
        ejbRefToMerge.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbRefToMerge.setEjbLink("link2");
        ejbRefToMerge.setHome("home2");
        ejbRefToMerge.setRemote("remote2");
        EjbRef ejbRefToLink = JavaeeFactory.eINSTANCE.createEjbRef();
        ejbRefToLink.setEjbRefName("refName199");
        ejbRefToLink.setEjbLink("link2");
        beanBase.getEjbRefs().add(ejbRefBase);
        beanToMerge.getEjbRefs().add(ejbRefBase);
        beanToMerge.getEjbRefs().add(ejbRefToMerge);
        beanToLink.getEjbRefs().add(ejbRefToLink);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEjbRefs().size());
        EjbRef test = this.getEjbRef(beanBase.getEjbRefs(), "refName1");
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)test.getEjbRefType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"link2", (String)test.getEjbLink());
        JndiRefsTest.assertEquals((String)"home2", (String)test.getHome());
        JndiRefsTest.assertEquals((String)"remote2", (String)test.getRemote());
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
    }

    private EjbRef getEjbRef(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            EjbRef ref = (EjbRef)object;
            if (!name.equals(ref.getEjbRefName())) continue;
            return ref;
        }
        return null;
    }

    public void testEjbLocalRefsBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EjbLocalRef ejbLocalRefBase = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefBase.setMappedName("mapped1");
        ejbLocalRefBase.setEjbRefName("refName1");
        ejbLocalRefBase.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbLocalRefBase.setEjbLink("link1");
        ejbLocalRefBase.setLocalHome("home1");
        ejbLocalRefBase.setLocal("remote1");
        EjbLocalRef ejbLocalRefToMerge = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefToMerge.setMappedName("mapped2");
        ejbLocalRefToMerge.setEjbRefName("refName2");
        ejbLocalRefToMerge.setEjbRefType(EjbRefType.ENTITY_LITERAL);
        ejbLocalRefToMerge.setEjbLink("link2");
        ejbLocalRefToMerge.setLocalHome("home2");
        ejbLocalRefToMerge.setLocal("remote2");
        beanBase.getEjbLocalRefs().add(ejbLocalRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEjbLocalRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbRefName());
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbRefType());
        JndiRefsTest.assertEquals((String)"link1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbLink());
        JndiRefsTest.assertEquals((String)"home1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getLocalHome());
        JndiRefsTest.assertEquals((String)"remote1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getLocal());
    }

    public void testEjbLocalRefsMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EjbLocalRef envRefBase = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        envRefBase.setMappedName("mapped1");
        envRefBase.setEjbRefName("refName1");
        envRefBase.setEjbRefType(EjbRefType.SESSION_LITERAL);
        envRefBase.setEjbLink("link1");
        envRefBase.setLocalHome("home1");
        envRefBase.setLocal("remote1");
        EjbLocalRef ejbLocalRefToMerge = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefToMerge.setMappedName("mapped2");
        ejbLocalRefToMerge.setEjbRefName("refName2");
        ejbLocalRefToMerge.setEjbRefType(EjbRefType.ENTITY_LITERAL);
        ejbLocalRefToMerge.setEjbLink("link2");
        ejbLocalRefToMerge.setLocalHome("home2");
        ejbLocalRefToMerge.setLocal("remote2");
        beanToMerge.getEjbLocalRefs().add(envRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEjbLocalRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbRefName());
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbRefType());
        JndiRefsTest.assertEquals((String)"link1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbLink());
        JndiRefsTest.assertEquals((String)"home1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getLocalHome());
        JndiRefsTest.assertEquals((String)"remote1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getLocal());
    }

    public void testEjbLocalRefsSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EjbLocalRef ejbLocalRefBase = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefBase.setMappedName("mapped1");
        ejbLocalRefBase.setEjbRefName("refName1");
        ejbLocalRefBase.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbLocalRefBase.setEjbLink("link1");
        ejbLocalRefBase.setLocalHome("home1");
        ejbLocalRefBase.setLocal("remote1");
        EjbLocalRef ejbLocalRefToMerge = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefToMerge.setMappedName("mapped2");
        ejbLocalRefToMerge.setEjbRefName("refName2");
        ejbLocalRefToMerge.setEjbRefType(EjbRefType.ENTITY_LITERAL);
        ejbLocalRefToMerge.setEjbLink("link2");
        ejbLocalRefToMerge.setLocalHome("home2");
        ejbLocalRefToMerge.setLocal("remote2");
        beanBase.getEjbLocalRefs().add(ejbLocalRefBase);
        beanToMerge.getEjbLocalRefs().add(ejbLocalRefBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEjbLocalRefs().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbRefName());
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbRefType());
        JndiRefsTest.assertEquals((String)"link1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbLink());
        JndiRefsTest.assertEquals((String)"home1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getLocalHome());
        JndiRefsTest.assertEquals((String)"remote1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getLocal());
    }

    public void testEjbLocalRefsComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EjbLocalRef ejbLocalRefBase = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefBase.setMappedName("mapped1");
        ejbLocalRefBase.setEjbRefName("refName1");
        ejbLocalRefBase.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbLocalRefBase.setEjbLink("link1");
        ejbLocalRefBase.setLocalHome("home1");
        ejbLocalRefBase.setLocal("remote1");
        EjbLocalRef ejbLocalRefToMerge = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefToMerge.setMappedName("mapped2");
        ejbLocalRefToMerge.setEjbRefName("refName2");
        ejbLocalRefToMerge.setEjbRefType(EjbRefType.ENTITY_LITERAL);
        ejbLocalRefToMerge.setEjbLink("link2");
        ejbLocalRefToMerge.setLocalHome("home2");
        ejbLocalRefToMerge.setLocal("remote2");
        beanBase.getEjbLocalRefs().add(ejbLocalRefBase);
        beanToMerge.getEjbLocalRefs().add(ejbLocalRefBase);
        beanToMerge.getEjbLocalRefs().add(ejbLocalRefToMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getEjbLocalRefs().size());
        EjbLocalRef test = this.getEjbLocalRef(beanBase.getEjbLocalRefs(), "refName1");
        EjbLocalRef test2 = this.getEjbLocalRef(beanBase.getEjbLocalRefs(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)test.getEjbRefType());
        JndiRefsTest.assertEquals((String)"link1", (String)((EjbLocalRef)beanBase.getEjbLocalRefs().get(0)).getEjbLink());
        JndiRefsTest.assertEquals((String)"home1", (String)test.getLocalHome());
        JndiRefsTest.assertEquals((String)"remote1", (String)test.getLocal());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((Object)EjbRefType.ENTITY_LITERAL, (Object)test2.getEjbRefType());
        JndiRefsTest.assertEquals((String)"link2", (String)test2.getEjbLink());
        JndiRefsTest.assertEquals((String)"home2", (String)test2.getLocalHome());
        JndiRefsTest.assertEquals((String)"remote2", (String)test2.getLocal());
    }

    public void testEjbLocalRefsComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToLink = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        beanToLink.setEjbName("name");
        EjbLocalRef ejbLocalRefBase = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefBase.setEjbRefName("refName1");
        EjbLocalRef ejbLocalRefToMerge = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefToMerge.setMappedName("mapped2");
        ejbLocalRefToMerge.setEjbRefName("refName1");
        ejbLocalRefToMerge.setEjbRefType(EjbRefType.SESSION_LITERAL);
        ejbLocalRefToMerge.setEjbLink("link2");
        ejbLocalRefToMerge.setLocalHome("home2");
        ejbLocalRefToMerge.setLocal("remote2");
        EjbLocalRef ejbLocalRefToLink = JavaeeFactory.eINSTANCE.createEjbLocalRef();
        ejbLocalRefToLink.setEjbRefName("refName199");
        ejbLocalRefToLink.setEjbLink("link2");
        beanBase.getEjbLocalRefs().add(ejbLocalRefBase);
        beanToMerge.getEjbLocalRefs().add(ejbLocalRefBase);
        beanToMerge.getEjbLocalRefs().add(ejbLocalRefToMerge);
        beanToLink.getEjbLocalRefs().add(ejbLocalRefToLink);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEjbLocalRefs().size());
        EjbLocalRef test = this.getEjbLocalRef(beanBase.getEjbLocalRefs(), "refName1");
        JndiRefsTest.assertEquals((Object)EjbRefType.SESSION_LITERAL, (Object)test.getEjbRefType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"link2", (String)test.getEjbLink());
        JndiRefsTest.assertEquals((String)"home2", (String)test.getLocalHome());
        JndiRefsTest.assertEquals((String)"remote2", (String)test.getLocal());
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
    }

    private EjbLocalRef getEjbLocalRef(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            EjbLocalRef ref = (EjbLocalRef)object;
            if (!name.equals(ref.getEjbRefName())) continue;
            return ref;
        }
        return null;
    }

    public void testEnvEntrysBase() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EnvEntry envEntryBase = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryBase.setMappedName("mapped1");
        envEntryBase.setEnvEntryName("refName1");
        envEntryBase.setEnvEntryType(EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL);
        envEntryBase.setEnvEntryValue("true");
        EnvEntry envEntryMerge = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryMerge.setMappedName("mapped2");
        envEntryMerge.setEnvEntryName("refName2");
        envEntryMerge.setEnvEntryType(EnvEntryType.JAVA_LANG_BYTE_LITERAL);
        envEntryMerge.setEnvEntryValue("00");
        beanBase.getEnvEntries().add(envEntryBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEnvEntries().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryName());
        JndiRefsTest.assertEquals((Object)EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL, (Object)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryType());
        JndiRefsTest.assertEquals((String)"true", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryValue());
    }

    public void testEnvEntrysMerge() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EnvEntry envEntryBase = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryBase.setMappedName("mapped1");
        envEntryBase.setEnvEntryName("refName1");
        envEntryBase.setEnvEntryType(EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL);
        envEntryBase.setEnvEntryValue("true");
        EnvEntry envEntryMerge = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryMerge.setMappedName("mapped2");
        envEntryMerge.setEnvEntryName("refName2");
        envEntryMerge.setEnvEntryType(EnvEntryType.JAVA_LANG_BYTE_LITERAL);
        envEntryMerge.setEnvEntryValue("00");
        beanToMerge.getEnvEntries().add(envEntryBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEnvEntries().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryName());
        JndiRefsTest.assertEquals((Object)EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL, (Object)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryType());
        JndiRefsTest.assertEquals((String)"true", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryValue());
    }

    public void testEnvEntrysSame() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EnvEntry envEntryBase = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryBase.setMappedName("mapped1");
        envEntryBase.setEnvEntryName("refName1");
        envEntryBase.setEnvEntryType(EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL);
        envEntryBase.setEnvEntryValue("true");
        EnvEntry envEntryMerge = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryMerge.setMappedName("mapped2");
        envEntryMerge.setEnvEntryName("refName2");
        envEntryMerge.setEnvEntryType(EnvEntryType.JAVA_LANG_BYTE_LITERAL);
        envEntryMerge.setEnvEntryValue("00");
        beanBase.getEnvEntries().add(envEntryBase);
        beanToMerge.getEnvEntries().add(envEntryBase);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEnvEntries().size());
        JndiRefsTest.assertEquals((String)"mapped1", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getMappedName());
        JndiRefsTest.assertEquals((String)"refName1", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryName());
        JndiRefsTest.assertEquals((Object)EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL, (Object)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryType());
        JndiRefsTest.assertEquals((String)"true", (String)((EnvEntry)beanBase.getEnvEntries().get(0)).getEnvEntryValue());
    }

    public void testEnvEntrysComplex() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EnvEntry envEntryBase = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryBase.setMappedName("mapped1");
        envEntryBase.setEnvEntryName("refName1");
        envEntryBase.setEnvEntryType(EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL);
        envEntryBase.setEnvEntryValue("true");
        EnvEntry envEntryMerge = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryMerge.setMappedName("mapped2");
        envEntryMerge.setEnvEntryName("refName2");
        envEntryMerge.setEnvEntryType(EnvEntryType.JAVA_LANG_BYTE_LITERAL);
        envEntryMerge.setEnvEntryValue("00");
        beanBase.getEnvEntries().add(envEntryBase);
        beanToMerge.getEnvEntries().add(envEntryBase);
        beanToMerge.getEnvEntries().add(envEntryMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)2, (int)beanBase.getEnvEntries().size());
        EnvEntry test = this.getEnvEntry(beanBase.getEnvEntries(), "refName1");
        EnvEntry test2 = this.getEnvEntry(beanBase.getEnvEntries(), "refName2");
        JndiRefsTest.assertEquals((String)"mapped1", (String)test.getMappedName());
        JndiRefsTest.assertEquals((Object)EnvEntryType.JAVA_LANG_BOOLEAN_LITERAL, (Object)test.getEnvEntryType());
        JndiRefsTest.assertEquals((String)"true", (String)test.getEnvEntryValue());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test2.getMappedName());
        JndiRefsTest.assertEquals((Object)EnvEntryType.JAVA_LANG_BYTE_LITERAL, (Object)test2.getEnvEntryType());
        JndiRefsTest.assertEquals((String)"00", (String)test2.getEnvEntryValue());
    }

    public void testEnvEntrysComplexOverlapped() throws Exception {
        SessionBean beanBase = EjbFactory.eINSTANCE.createSessionBean();
        SessionBean beanToMerge = EjbFactory.eINSTANCE.createSessionBean();
        beanBase.setEjbName("name");
        beanToMerge.setEjbName("name");
        EnvEntry envEntryBase = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryBase.setEnvEntryName("refName1");
        EnvEntry envEntryMerge = JavaeeFactory.eINSTANCE.createEnvEntry();
        envEntryMerge.setMappedName("mapped2");
        envEntryMerge.setEnvEntryName("refName1");
        envEntryMerge.setEnvEntryType(EnvEntryType.JAVA_LANG_BYTE_LITERAL);
        envEntryMerge.setEnvEntryValue("00");
        beanBase.getEnvEntries().add(envEntryBase);
        beanToMerge.getEnvEntries().add(envEntryBase);
        beanToMerge.getEnvEntries().add(envEntryMerge);
        new JNDIRefsMerger((JavaEEObject)beanBase, (JavaEEObject)beanToMerge, 0).process();
        JndiRefsTest.assertEquals((int)1, (int)beanBase.getEnvEntries().size());
        EnvEntry test = this.getEnvEntry(beanBase.getEnvEntries(), "refName1");
        JndiRefsTest.assertEquals((Object)EnvEntryType.JAVA_LANG_BYTE_LITERAL, (Object)test.getEnvEntryType());
        JndiRefsTest.assertEquals((String)"mapped2", (String)test.getMappedName());
        JndiRefsTest.assertEquals((String)"00", (String)test.getEnvEntryValue());
    }

    private EnvEntry getEnvEntry(List refs, String name) {
        if (name == null) {
            return null;
        }
        for (Object object : refs) {
            EnvEntry ref = (EnvEntry)object;
            if (!name.equals(ref.getEnvEntryName())) continue;
            return ref;
        }
        return null;
    }
}

