/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ejb.operations;

import junit.framework.Test;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentImportDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleImportOperationTest;

public class EJBImportOperationTest
extends ModuleImportOperationTest {
    public EJBImportOperationTest() {
        super("EJBImportOperationTests");
    }

    public EJBImportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(EJBImportOperationTest.class);
    }

    protected String getModuleExtension() {
        return ".jar";
    }

    public void testEJBImport11_Defaults() throws Exception {
        this.runImportTests_All("EJB11_Defaults");
    }

    public void testEJBImport20_Defaults() throws Exception {
        this.runImportTests_All("EJB20_Defaults");
    }

    public void testEJBImport21_Defaults() throws Exception {
        this.runImportTests_All("EJB21_Defaults");
    }

    public void testEJBImport30_Defaults() throws Exception {
        this.runImportTests_All("EJB30_Defaults");
    }

    public void testEJBImport11_AddToEAR_Defaults() throws Exception {
        this.runImportTests_All("EJB11_AddToEAR_Defaults");
    }

    public void testEJBImport20_AddToEAR_Defaults() throws Exception {
        this.runImportTests_All("EJB20_AddToEAR_Defaults");
    }

    public void testEJBImport21_AddToEAR_Defaults() throws Exception {
        this.runImportTests_All("EJB21_AddToEAR_Defaults");
    }

    public void testEJBImport30_AddToEAR_Defaults() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_Defaults");
    }

    public void testEJBImport11_AddToEAR_NoClient() throws Exception {
        this.runImportTests_All("EJB11_AddToEAR_NoClient");
    }

    public void testEJBImport20_AddToEAR_NoClient() throws Exception {
        this.runImportTests_All("EJB20_AddToEAR_NoClient");
    }

    public void testEJBImport21_AddToEAR_NoClient() throws Exception {
        this.runImportTests_All("EJB21_AddToEAR_NoClient");
    }

    public void testEJBImport30_AddToEAR_NoClient() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_NoClient");
    }

    public void testEJBImport11_AddToEAR_DiffClientName() throws Exception {
        this.runImportTests_All("EJB11_AddToEAR_DiffClientName");
    }

    public void testEJBImport20_AddToEAR_DiffClientName() throws Exception {
        this.runImportTests_All("EJB20_AddToEAR_DiffClientName");
    }

    public void testEJBImport21_AddToEAR_DiffClientName() throws Exception {
        this.runImportTests_All("EJB21_AddToEAR_DiffClientName");
    }

    public void testEJBImport30_AddToEAR_DifClientName() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_DiffClientName");
    }

    public void testEJBImport11_AddToEAR_DiffClientSourceFolder() throws Exception {
        this.runImportTests_All("EJB11_AddToEAR_DiffClientSourceFolder");
    }

    public void testEJBImport20_AddToEAR_DiffClientSourceFolder() throws Exception {
        this.runImportTests_All("EJB20_AddToEAR_DiffClientSourceFolder");
    }

    public void testEJBImport21_AddToEAR_DiffClientSourceFolder() throws Exception {
        this.runImportTests_All("EJB21_AddToEAR_DiffClientSourceFolder");
    }

    public void testEJBImport30_AddToEAR_DiffClientSourceFolder() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_DiffClientSourceFolder");
    }

    public void testEJBImport11_AddToEAR_DiffClientName_DiffClientSourceFolder() throws Exception {
        this.runImportTests_All("EJB11_AddToEAR_DiffClientName_DiffClientSourceFolder");
    }

    public void testEJBImport20_AddToEAR_DiffClientName_DiffClientSourceFolder() throws Exception {
        this.runImportTests_All("EJB20_AddToEAR_DiffClientName_DiffClientSourceFolder");
    }

    public void testEJBImport21_AddToEAR_DiffClientName_DiffClientSourceFolder() throws Exception {
        this.runImportTests_All("EJB21_AddToEAR_DiffClientName_DiffClientSourceFolder");
    }

    public void testEJBImport30_AddToEAR_DiffClientName_DiffClientSourceFolder() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_DiffClientName_DiffClientSourceFolder");
    }

    public void testEJBImport30_Defaults_WithDD() throws Exception {
        this.runImportTests_All("EJB30_Defaults_WithDD");
    }

    public void testEJBImport30_AddToEAR_Defaults_WithDD() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_Defaults_WithDD");
    }

    public void testEJBImport30_AddToEAR_NoClient_WithDD() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_NoClient_WithDD");
    }

    public void testEJBImport30_AddToEAR_DiffClientName_WithDD() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_DiffClientName_WithDD");
    }

    public void testEJBImport30_AddToEAR_DiffClientSourceFolder_WithDD() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_DiffClientSourceFolder_WithDD");
    }

    public void testEJBImport30_AddToEAR_DiffClientName_DiffClientSourceFolder_WithDD() throws Exception {
        this.runImportTests_All("EJB30_AddToEAR_DiffClientName_DiffClientSourceFolder_WithDD");
    }

    protected IDataModel getImportDataModel(String filePath, String projectName, IOverwriteHandler overwriteHandler, IDataModel creationModel, boolean closeArchiveOnDispose) {
        return EJBImportOperationTest.getEJBImportDataModel(filePath, projectName, overwriteHandler, creationModel, closeArchiveOnDispose);
    }

    public static IDataModel getEJBImportDataModel(String filePath, String projectName, IOverwriteHandler overwriteHandler, IDataModel creationModel, boolean closeArchiveOnDispose) {
        IDataModel importModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentImportDataModelProvider());
        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)filePath);
        importModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)projectName);
        importModel.setProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose", (Object)closeArchiveOnDispose);
        if (overwriteHandler != null) {
            importModel.setProperty("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER", (Object)overwriteHandler);
        }
        if (creationModel != null) {
            importModel.setProperty("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION", (Object)creationModel);
        }
        return importModel;
    }

    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return EJBExportOperationTest.getEJBExportDataModel(projectName, destination, exportSource, runBuild, overwriteExisting);
    }
}

