/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import java.io.File;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.ear.operations.EARExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleExportOperationTest;

public abstract class JEEExportOperationTest
extends OperationTestCase {
    protected static final String[] JAVA_FILE_NAMES = new String[]{"JavaOne", "JavaTwo"};
    protected static final String BASE_DATA_DIR = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "JEEExportOperationTests" + File.separatorChar;

    public JEEExportOperationTest() {
        super("JEEProjectExportOperationTests");
    }

    public JEEExportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("All JEE Export Operation Tests");
        suite.addTest(ModuleExportOperationTest.suite());
        suite.addTest(EARExportOperationTest.suite());
        return suite;
    }

    protected static String getDataPath(String suffix) {
        return String.valueOf(BASE_DATA_DIR) + suffix;
    }

    protected static void deleteExported(String archivePath) {
        File f = new File(archivePath);
        f.delete();
    }

    protected abstract IDataModel getExportDataModel(String var1, String var2, boolean var3, boolean var4, boolean var5);

    protected abstract void runExportTests_All(IDataModel var1) throws Exception;

    protected abstract String getModuleExtension();

    protected String runAndVerifyExport_Defaults(String projectName) throws Exception {
        String archiveName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.getName() + "_Defaults" + this.getModuleExtension();
        String destination = JEEExportOperationTest.getDataPath(archiveName);
        IDataModel exportModel = this.getExportDataModel(projectName, destination, false, true, false);
        JEEExportOperationTest.runAndVerify((IDataModel)exportModel);
        return archiveName;
    }

    protected String runAndVerifyExport_WithSource(String projectName) throws Exception {
        String archiveName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.getName() + "_WithSource" + this.getModuleExtension();
        String destination = JEEExportOperationTest.getDataPath(archiveName);
        IDataModel exportModel = this.getExportDataModel(projectName, destination, true, true, false);
        JEEExportOperationTest.runAndVerify((IDataModel)exportModel);
        return archiveName;
    }

    protected String runAndVerifyExport_DontRunBuild(String projectName) throws Exception {
        String archiveName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.getName() + "_DontRunBuild" + this.getModuleExtension();
        String destination = JEEExportOperationTest.getDataPath(archiveName);
        IDataModel exportModel = this.getExportDataModel(projectName, destination, false, false, false);
        JEEExportOperationTest.runAndVerify((IDataModel)exportModel);
        return archiveName;
    }

    protected String runAndVerifyExport_WithSource_DontRunBuild(String projectName) throws Exception {
        String archiveName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.getName() + "_WithSource_DontRunBuild" + this.getModuleExtension();
        String destination = JEEExportOperationTest.getDataPath(archiveName);
        IDataModel exportModel = this.getExportDataModel(projectName, destination, true, false, false);
        JEEExportOperationTest.runAndVerify((IDataModel)exportModel);
        return archiveName;
    }

    protected void runTest_AttemptToOverwriteButCant(String projectName) throws Exception {
        String archiveName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.getName() + "_AttemptToOverwriteButCant" + this.getModuleExtension();
        String destination = JEEExportOperationTest.getDataPath(archiveName);
        try {
            IDataModel exportModel = this.getExportDataModel(projectName, destination, false, true, false);
            JEEExportOperationTest.runDataModel((IDataModel)exportModel);
            IDataModel exportModelOverwrite = this.getExportDataModel(projectName, destination, false, true, false);
            IStatus status = exportModelOverwrite.validate();
            int severity = status.getSeverity();
            Assert.assertEquals((String)"Validate on the model should be returning an error because model should not be able overwrite existing archive", (int)4, (int)severity);
        }
        finally {
            JEEExportOperationTest.deleteExported(archiveName);
        }
    }

    protected void runTest_AttemptToOverwriteSholdSucceed(String projectName) throws Exception {
        String archiveName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.getName() + "_AttemptToOverwriteSholdSucceed" + this.getModuleExtension();
        String destination = JEEExportOperationTest.getDataPath(archiveName);
        try {
            IDataModel exportModel = this.getExportDataModel(projectName, destination, false, true, true);
            JEEExportOperationTest.runDataModel((IDataModel)exportModel);
            IDataModel exportModelOverwrite = this.getExportDataModel(projectName, destination, false, true, true);
            IStatus status = exportModelOverwrite.validate();
            int severity = status.getSeverity();
            Assert.assertEquals((String)"Data model should be allowed to overwrite existing archive", (int)0, (int)severity);
        }
        finally {
            JEEExportOperationTest.deleteExported(archiveName);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        String dataPath = JEEExportOperationTest.getDataPath("");
        File dataFolder = new File(dataPath);
        File[] files = dataFolder.listFiles();
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
    }
}

