/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers;

import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.tests.DataModelVerifier;

public abstract class JEEProjectCreationDataModelVerifier
extends DataModelVerifier {
    protected IDataModel model = null;
    protected IProject project = null;
    protected IVirtualComponent component = null;
    protected String facetProjectType = null;
    protected boolean hasModelProvider = true;

    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.model = model;
        this.setFacetProjectType();
        String projName = model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        this.project = ProjectUtilities.getProject((String)projName);
        this.verifyProject();
        this.component = ComponentCore.createComponent((IProject)this.project);
        this.verifyComponent();
        this.verifyProjectVersion();
        if (this.hasModelProvider) {
            this.verifyModelProvider();
        }
    }

    protected abstract void setFacetProjectType();

    protected abstract IFile getDDFile();

    protected abstract void verifyDD(Object var1);

    private void verifyProject() {
        Assert.assertTrue((String)"The project should exist", (boolean)this.project.exists());
    }

    private void verifyComponent() {
        Assert.assertNotNull((String)"Component should not be null", (Object)this.component);
        Assert.assertTrue((String)"Component should exist", (boolean)this.component.exists());
    }

    private void verifyProjectVersion() throws Exception {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel(this.facetProjectType);
        ProjectFacetVersion version = (ProjectFacetVersion)facetModel.getProperty("IFacetDataModelPropeties.FACET_VERSION");
        IProjectFacet projFact = version.getProjectFacet();
        String projFactID = projFact.getId();
        boolean verifyVersion = ProjectFacetsManager.isProjectFacetDefined((String)projFactID);
        Assert.assertTrue((String)("Project facet: " + projFactID + " should be defined"), (boolean)verifyVersion);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
        Assert.assertTrue((String)("Project fact version: " + version + "should be defined"), (boolean)facetedProject.getProjectFacets().contains(version));
    }

    protected void verifyModelProvider() throws Exception {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.project);
        Object modelObj = provider.getModelObject();
        Object modelObj2 = null;
        IArchive archive = null;
        try {
            archive = JavaEEArchiveUtilities.INSTANCE.openArchive(this.component);
            IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            facetMap.getFacetDataModel(this.facetProjectType);
            Assert.assertNotNull((String)"Deployment Descriptor should not be null", (Object)modelObj);
            this.verifyDD(modelObj);
            System.err.println("TODO -- //modelObj2 = archive.getModelObject();");
            System.err.println("     -- see https://bugs.eclipse.org/bugs/show_bug.cgi?id=195670");
            if (modelObj != modelObj2) {
                System.err.println("TODO -- Deployment Descriptor should be equal to its self");
                System.err.println("     -- see https://bugs.eclipse.org/bugs/show_bug.cgi?id=195670");
            }
        }
        finally {
            if (archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
            }
        }
    }
}

