/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.facet;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.common.webxml.WebXmlUpdater;
import org.eclipse.jst.jsf.common.webxml.WebXmlUtilsForJavaEE;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class VendorSpecificWebXmlConfigurationForJavaEETest
extends TestCase {
    private static final IProjectFacetVersion WEB_MODULE_VERSION = ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.5");
    private static final IProjectFacetVersion JAVA_VERSION = JavaFacetUtils.JAVA_50;
    private static final String PROJECT_NAME_PREFIX = "_TEST_PROJECT_NAME_FOR_JAVA_EE";
    private static final String SERVLET_NAME = "_TEST_SERVLET_NAME";
    private static final String SERVLET_CLASS_NAME = "_TEST_SERVLET_CLASS_NAME";
    private static final String SERVLET_LOAD_ON_STARTUP = "1";
    private static final String SERVLET_URL_PATTERN = "*._TEST_SERVLET_URL_PATTERN";
    private static final String CONTEXT_PARAM_NAME = "_TEST_CONTEXT_PARAM_NAME";
    private static final String CONTEXT_PARAM_VALUE = "_TEST_CONTEXT_PARAM_VALUE";
    private static final String CONTEXT_PARAM_DESCRIPTION = "_TEST_CONTEXT_PARAM_DESCRIPTION";
    private static final String LISTENER_CLASS = "_TEST_LISTENER_CLASS";
    private final IProject project = this.createProject("_TEST_PROJECT_NAME_FOR_JAVA_EE");
    private final WebXmlUpdater updater = new WebXmlUpdater(this.project, null);
    private final WebApp webapp = (WebApp)this.updater.getProvider().getModelObject();

    public VendorSpecificWebXmlConfigurationForJavaEETest(String name) throws Exception {
        super(name);
    }

    private IProject createProject(String projectName) throws Exception {
        WebProjectTestEnvironment testEnv = new WebProjectTestEnvironment(projectName, JAVA_VERSION, WEB_MODULE_VERSION);
        testEnv.createProject(true);
        return testEnv.getTestProject();
    }

    public void testAddServlet() throws Exception {
        IProject project = this.createProject(PROJECT_NAME_PREFIX + ((Object)((Object)this)).getClass().getName() + this.getName());
        this.updater.addServlet(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_LOAD_ON_STARTUP);
        Servlet servlet = WebXmlUtilsForJavaEE.findServlet((String)SERVLET_CLASS_NAME, (WebApp)this.webapp);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_NAME, (String)servlet.getServletName());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_CLASS_NAME, (String)servlet.getServletClass());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_LOAD_ON_STARTUP, (String)servlet.getLoadOnStartup().toString());
        System.out.println(JSFTestUtil.safeDelete((IResource)project, (int)3, (int)500));
    }

    public void testAddContextParam() throws Exception {
        IProject project = this.createProject(PROJECT_NAME_PREFIX + ((Object)((Object)this)).getClass().getName() + this.getName());
        this.updater.addServlet(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_LOAD_ON_STARTUP);
        this.updater.addContextParam(CONTEXT_PARAM_NAME, CONTEXT_PARAM_VALUE, CONTEXT_PARAM_DESCRIPTION);
        ParamValue param = WebXmlUtilsForJavaEE.findContextParam((WebApp)this.webapp, (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)CONTEXT_PARAM_NAME, (String)param.getParamName());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)CONTEXT_PARAM_VALUE, (String)param.getParamValue());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)CONTEXT_PARAM_DESCRIPTION, (String)((Description)param.getDescriptions().get(0)).getValue());
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testAddServletMapping() throws Exception {
        IProject project = this.createProject(PROJECT_NAME_PREFIX + ((Object)((Object)this)).getClass().getName() + this.getName());
        this.updater.addServlet(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_LOAD_ON_STARTUP);
        this.updater.addServletMapping(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_URL_PATTERN);
        ServletMapping mapping = WebXmlUtilsForJavaEE.findServletMapping((WebApp)this.webapp, (String)SERVLET_NAME, (String)SERVLET_URL_PATTERN);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertNotNull((Object)mapping);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_NAME, (String)mapping.getServletName());
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)SERVLET_URL_PATTERN, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testAddListener() throws Exception {
        IProject project = this.createProject(PROJECT_NAME_PREFIX + ((Object)((Object)this)).getClass().getName() + this.getName());
        this.updater.addListener(LISTENER_CLASS);
        Listener listener = WebXmlUtilsForJavaEE.findListener((WebApp)this.webapp, (String)LISTENER_CLASS);
        VendorSpecificWebXmlConfigurationForJavaEETest.assertEquals((String)LISTENER_CLASS, (String)listener.getListenerClass());
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }
}

