/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryconfig;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;

public class JSFProjectLibraryReferenceTestCases
extends TestCase {
    private String JSF_NAME = "MockJSFLib";
    private boolean isImpl = false;
    private JSFLibrary jsfLib = null;
    private JSFLibraryInternalReference jsfLibRef = null;

    public JSFProjectLibraryReferenceTestCases(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jsfLib = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        this.jsfLib.setName(this.JSF_NAME);
        this.jsfLib.setImplementation(false);
        this.jsfLibRef = new JSFLibraryInternalReference(this.jsfLib, true, true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.jsfLib = null;
        this.jsfLibRef = null;
    }

    public void testJSFProjectLibraryReference() {
        JSFLibraryInternalReference jsfLibRef_ = new JSFLibraryInternalReference(this.jsfLib, true, true);
        Assert.assertNotNull((Object)jsfLibRef_);
        Assert.assertTrue((boolean)jsfLibRef_.isSelected());
        Assert.assertTrue((boolean)jsfLibRef_.isCheckedToBeDeployed());
        Assert.assertTrue((boolean)this.JSF_NAME.equals(jsfLibRef_.getName()));
        Assert.assertTrue((boolean)this.JSF_NAME.equals(jsfLibRef_.getID()));
        Assert.assertTrue((boolean)this.JSF_NAME.equals(jsfLibRef_.getLabel()));
        Assert.assertTrue((this.isImpl == jsfLibRef_.isImplementation() ? 1 : 0) != 0);
    }

    public void testGetLibrary() {
        Assert.assertNotNull((Object)this.jsfLibRef);
        Assert.assertEquals((Object)this.jsfLibRef.getLibrary(), (Object)this.jsfLib);
    }

    public void testIsCheckedToBeDeployed() {
        JSFLibraryInternalReference jsfLibRef_ = new JSFLibraryInternalReference(this.jsfLib, true, true);
        Assert.assertNotNull((Object)jsfLibRef_);
        Assert.assertTrue((boolean)jsfLibRef_.isCheckedToBeDeployed());
    }

    public void testSetSelected() {
        JSFLibraryInternalReference jsfLibRef_ = new JSFLibraryInternalReference(this.jsfLib, true, true);
        Assert.assertNotNull((Object)jsfLibRef_);
        Assert.assertTrue((boolean)jsfLibRef_.isSelected());
        jsfLibRef_.setSelected(false);
        Assert.assertFalse((boolean)jsfLibRef_.isSelected());
    }

    public void testIsImplementation() {
        Assert.assertFalse((boolean)this.jsfLibRef.isImplementation());
    }

    public void testGetArchiveFiles() {
        String path2TestJAR = String.valueOf(TestsPlugin.getInstallLocation().getPath()) + "testfiles/faces-all-bogus.jar";
        ArchiveFile af = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        af.setRelativeToWorkspace(false);
        af.setSourceLocation(path2TestJAR);
        af.setJSFLibrary(this.jsfLib);
        Assert.assertNotNull((Object)this.jsfLib.getArchiveFiles());
        Assert.assertTrue((this.jsfLib.getArchiveFiles().size() == 1 ? 1 : 0) != 0);
    }
}

