/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.set;

import junit.framework.TestCase;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.common.sets.ConcreteAxiomaticSet;

public class ConcreteAxiomaticSetTest
extends TestCase {
    AxiomaticSet _primaryColours;
    AxiomaticSet _secondaryColours;
    AxiomaticSet _allMainColours;
    AxiomaticSet _palette;
    AxiomaticSet _overlappingSet;
    AxiomaticSet _emptySet;

    protected void setUp() throws Exception {
        super.setUp();
        this._emptySet = new ConcreteAxiomaticSet();
        this._primaryColours = new ConcreteAxiomaticSet();
        this._primaryColours.add((Object)"blue");
        this._primaryColours.add((Object)"red");
        this._primaryColours.add((Object)"yellow");
        this._secondaryColours = new ConcreteAxiomaticSet();
        this._secondaryColours.add((Object)"green");
        this._secondaryColours.add((Object)"purple");
        this._secondaryColours.add((Object)"orange");
        this._allMainColours = new ConcreteAxiomaticSet();
        this._allMainColours.add((Object)"blue");
        this._allMainColours.add((Object)"red");
        this._allMainColours.add((Object)"yellow");
        this._allMainColours.add((Object)"green");
        this._allMainColours.add((Object)"purple");
        this._allMainColours.add((Object)"orange");
        this._palette = new ConcreteAxiomaticSet();
        this._palette.add((Object)"blue");
        this._palette.add((Object)"green");
        this._palette.add((Object)"burgundy");
        this._overlappingSet = new ConcreteAxiomaticSet();
        this._overlappingSet.add((Object)"blue");
        this._overlappingSet.add((Object)"red");
        this._overlappingSet.add((Object)"yellow");
        this._overlappingSet.add((Object)"green");
        this._overlappingSet.add((Object)"purple");
        this._overlappingSet.add((Object)"burgundy");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._primaryColours = null;
        this._secondaryColours = null;
        this._palette = null;
        this._emptySet = null;
    }

    public void testIntersect() {
        ConcreteAxiomaticSetTest.assertTrue((boolean)this._primaryColours.intersect(this._secondaryColours).isEmpty());
        ConcreteAxiomaticSetTest.assertFalse((boolean)this._primaryColours.intersect(this._palette).isEmpty());
        ConcreteAxiomaticSetTest.assertEquals((int)1, (int)this._primaryColours.intersect(this._palette).size());
        ConcreteAxiomaticSetTest.assertEquals((Object)"blue", (Object)this._primaryColours.intersect(this._palette).getFirstElement());
        ConcreteAxiomaticSetTest.assertEquals((Object)this._primaryColours.intersect(this._palette), (Object)this._palette.intersect(this._primaryColours));
        ConcreteAxiomaticSetTest.assertEquals((Object)this._primaryColours.intersect(this._overlappingSet).intersect(this._palette), (Object)this._overlappingSet.intersect(this._palette).intersect(this._primaryColours));
        ConcreteAxiomaticSetTest.assertTrue((boolean)this._primaryColours.intersect(this._secondaryColours).isEmpty());
        ConcreteAxiomaticSetTest.assertEquals((Object)this._primaryColours, (Object)this._allMainColours.intersect(this._primaryColours));
        ConcreteAxiomaticSetTest.assertEquals((Object)this._secondaryColours, (Object)this._allMainColours.intersect(this._secondaryColours));
    }

    public void testIsEquivalent() {
        ConcreteAxiomaticSetTest.assertTrue((boolean)this._primaryColours.isEquivalent(this._primaryColours));
        ConcreteAxiomaticSetTest.assertFalse((boolean)this._primaryColours.isEquivalent(this._secondaryColours));
    }

    public void testUnion() {
        ConcreteAxiomaticSetTest.assertEquals((Object)this._primaryColours, (Object)this._primaryColours.union(this._emptySet));
        ConcreteAxiomaticSetTest.assertEquals((Object)this._allMainColours, (Object)this._primaryColours.union(this._secondaryColours));
        ConcreteAxiomaticSetTest.assertEquals((Object)this._primaryColours.union(this._secondaryColours), (Object)this._secondaryColours.union(this._primaryColours));
        ConcreteAxiomaticSetTest.assertEquals((Object)this._primaryColours.union(this._secondaryColours).union(this._overlappingSet), (Object)this._secondaryColours.union(this._overlappingSet).union(this._primaryColours));
    }

    public void testIsDisjoint() {
        ConcreteAxiomaticSetTest.assertTrue((boolean)this._primaryColours.isDisjoint(this._secondaryColours));
        ConcreteAxiomaticSetTest.assertTrue((boolean)this._primaryColours.isDisjoint(this._emptySet));
        ConcreteAxiomaticSetTest.assertTrue((boolean)this._secondaryColours.isDisjoint(this._emptySet));
        ConcreteAxiomaticSetTest.assertTrue((boolean)this._emptySet.isDisjoint(this._allMainColours));
        ConcreteAxiomaticSetTest.assertFalse((boolean)this._primaryColours.isDisjoint(this._allMainColours));
    }

    public void testGetFirstElement() {
    }

    public void testSubtract() {
        ConcreteAxiomaticSetTest.assertEquals((Object)this._primaryColours, (Object)this._primaryColours.subtract(this._secondaryColours));
        ConcreteAxiomaticSetTest.assertEquals((Object)this._secondaryColours, (Object)this._allMainColours.subtract(this._primaryColours));
        ConcreteAxiomaticSetTest.assertEquals((Object)this._primaryColours, (Object)this._allMainColours.subtract(this._secondaryColours));
        ConcreteAxiomaticSetTest.assertEquals((Object)this._secondaryColours, (Object)this._secondaryColours.subtract(this._emptySet));
        AxiomaticSet remainder = this._allMainColours.subtract(this._overlappingSet);
        ConcreteAxiomaticSetTest.assertEquals((int)1, (int)remainder.size());
        ConcreteAxiomaticSetTest.assertTrue((boolean)remainder.contains((Object)"orange"));
    }
}

