/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.tagmatcher;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.core.tagmatcher.XPathMatchingAlgorithm;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class BaseTagMatcherTestCase
extends TestCase {
    protected WebProjectTestEnvironment _testEnv;
    protected JDTTestEnvironment _jdtTestEnv;
    protected String _srcFileName;
    protected String _destFileName;
    protected IFile _testJSP;
    protected IStructuredModel _structuredModel;
    protected IStructuredDocument _structuredDocument;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        this._testEnv = new WebProjectTestEnvironment("ELValidationTest_" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName());
        this._testEnv.createProject(false);
        BaseTagMatcherTestCase.assertNotNull((Object)this._testEnv);
        BaseTagMatcherTestCase.assertNotNull((Object)this._testEnv.getTestProject());
        BaseTagMatcherTestCase.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/myfaces_core.tld.data", "META-INF/myfaces_core.tld");
        this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/myfaces_html.tld.data", "META-INF/myfaces_html.tld");
        this._testJSP = (IFile)this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), this._srcFileName, this._destFileName);
        this._structuredModel = StructuredModelManager.getModelManager().getModelForRead(this._testJSP);
        this._structuredDocument = this._structuredModel.getStructuredDocument();
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this._structuredModel != null) {
            this._structuredModel.releaseFromRead();
        }
        this._testEnv.getTestProject().close(null);
    }

    protected final AxiomaticSet getAncestorsOf(String xpathToChild, int expectedAncestors) {
        IDOMDocument doc = ((IDOMModel)this._structuredModel).getDocument();
        XPathMatchingAlgorithm matcher = new XPathMatchingAlgorithm(xpathToChild);
        AxiomaticSet set = matcher.evaluate((Node)doc);
        BaseTagMatcherTestCase.assertEquals((int)1, (int)set.size());
        Node inputText = (Node)set.getFirstElement();
        matcher = new XPathMatchingAlgorithm("ancestor::*");
        AxiomaticSet result = matcher.evaluate(inputText);
        BaseTagMatcherTestCase.assertNotNull((Object)result);
        if (expectedAncestors >= 0) {
            BaseTagMatcherTestCase.assertEquals((int)expectedAncestors, (int)result.size());
        }
        return result;
    }
}

