/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.validation;

import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.XMLViewDefnValidator;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.osgi.framework.Bundle;

public class TestJSPSemanticValidation_AttrValueConverter
extends TestCase {
    private WebProjectTestEnvironment _webProject;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        ZipFile zipFile = JSFTestUtil.createZipFile((Bundle)TestsPlugin.getDefault().getBundle(), (String)"/testfiles/testzips/valueHolderTest11.zip");
        this._webProject = new WebProjectTestEnvironment((TestCase)this, JavaFacetUtils.JAVA_50, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.4"));
        this._webProject.createFromZip(zipFile, true);
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._webProject);
        JSFCoreUtilHelper.addJSFRuntimeJarsToClasspath(JSFVersion.V1_1, jsfFacedEnv);
    }

    public void testSanity() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestJSPSemanticValidation_AttrValueConverter.assertNotNull((Object)project);
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)project.isAccessible());
        IFile jspFile = project.getFile((IPath)new Path("WebContent/Case1_NoExplicitConverter.jspx"));
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)jspFile.isAccessible());
        IStructuredModel jspModel = null;
        try {
            jspModel = StructuredModelManager.getModelManager().getModelForRead(jspFile);
            assert (jspModel instanceof DOMModelForJSP);
        }
        finally {
            if (jspModel != null) {
                jspModel.releaseFromRead();
            }
        }
    }

    public void testCase1_NoExplicitConverter() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestJSPSemanticValidation_AttrValueConverter.assertNotNull((Object)project);
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)project.isAccessible());
        IFile jspFile = project.getFile((IPath)new Path("WebContent/Case1_NoExplicitConverter.jspx"));
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)jspFile.isAccessible());
        MockValidationReporter mockReporter = new MockValidationReporter();
        XMLViewDefnValidator validator = new XMLViewDefnValidator();
        validator.validateView(jspFile, (IJSFViewValidator.IValidationReporter)mockReporter);
        TestJSPSemanticValidation_AttrValueConverter.assertEquals((int)1, (int)mockReporter.getReportedProblems().size());
        mockReporter.assertExpectedMessage(10683, 27, 2);
    }

    public void testCase1a_NoExplicitConverterWithForClass() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestJSPSemanticValidation_AttrValueConverter.assertNotNull((Object)project);
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)project.isAccessible());
        IFile jspFile = project.getFile((IPath)new Path("WebContent/Case1a_NoExplicitConverterWithForClass.jspx"));
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)jspFile.isAccessible());
        MockValidationReporter mockReporter = new MockValidationReporter();
        XMLViewDefnValidator validator = new XMLViewDefnValidator();
        validator.validateView(jspFile, (IJSFViewValidator.IValidationReporter)mockReporter);
        TestJSPSemanticValidation_AttrValueConverter.assertEquals((int)0, (int)mockReporter.getReportedProblems().size());
    }

    public void testCase2_ExplicitConverterKnown() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestJSPSemanticValidation_AttrValueConverter.assertNotNull((Object)project);
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)project.isAccessible());
        IFile jspFile = project.getFile((IPath)new Path("WebContent/Case2_ExplicitConverterKnown.jspx"));
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)jspFile.isAccessible());
        MockValidationReporter mockReporter = new MockValidationReporter();
        XMLViewDefnValidator validator = new XMLViewDefnValidator();
        validator.validateView(jspFile, (IJSFViewValidator.IValidationReporter)mockReporter);
        TestJSPSemanticValidation_AttrValueConverter.assertEquals((int)11, (int)mockReporter.getReportedProblems().size());
        mockReporter.assertExpectedMessage(2410, 29, 2);
        mockReporter.assertExpectedMessage(2509, 29, 2);
        mockReporter.assertExpectedMessage(2612, 29, 2);
        mockReporter.assertExpectedMessage(2717, 29, 2);
        mockReporter.assertExpectedMessage(2832, 29, 2);
        mockReporter.assertExpectedMessage(2950, 29, 2);
        mockReporter.assertExpectedMessage(3060, 29, 2);
        mockReporter.assertExpectedMessage(3169, 29, 2);
        mockReporter.assertExpectedMessage(3282, 29, 2);
        mockReporter.assertExpectedMessage(3398, 29, 2);
        mockReporter.assertExpectedMessage(3510, 29, 2);
    }

    public void testCase2_ExplicitUnknownConverter() throws Exception {
        IProject project = this._webProject.getTestProject();
        TestJSPSemanticValidation_AttrValueConverter.assertNotNull((Object)project);
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)project.isAccessible());
        IFile jspFile = project.getFile((IPath)new Path("WebContent/Case3_ExplicitUnknownConverter.jspx"));
        TestJSPSemanticValidation_AttrValueConverter.assertTrue((boolean)jspFile.isAccessible());
        MockValidationReporter mockReporter = new MockValidationReporter();
        XMLViewDefnValidator validator = new XMLViewDefnValidator();
        validator.validateView(jspFile, (IJSFViewValidator.IValidationReporter)mockReporter);
        TestJSPSemanticValidation_AttrValueConverter.assertEquals((int)1, (int)mockReporter.getReportedProblems().size());
        mockReporter.assertExpectedMessage(804, 29, 2);
    }
}

