/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpath.tests;

import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.classpath.tests.AbstractTests;
import org.eclipse.jst.j2ee.classpath.tests.util.ClasspathDependencyTestUtil;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ClasspathDependencyCreationTests
extends AbstractTests {
    private ClasspathDependencyCreationTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Classpath Component Dependency Creation Tests");
        suite.addTest((Test)new ClasspathDependencyCreationTests("testNoClasspathDependencies"));
        suite.addTest((Test)new ClasspathDependencyCreationTests("testAddRemoveClasspathDependency"));
        suite.addTest((Test)new ClasspathDependencyCreationTests("testLibraryClasspathDependency"));
        suite.addTest((Test)new ClasspathDependencyCreationTests("testClassFolderDependency"));
        return suite;
    }

    public void testNoClasspathDependencies() throws Exception {
        IProject project = ProjectUtil.createUtilityProject("TestUtil", "TestEAR");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
    }

    public void testAddRemoveClasspathDependency() throws Exception {
        IProject project = ProjectUtil.createUtilityProject("TestUtil", "TestEAR");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        ClasspathDependencyTestUtil.addCustomClasspathContainer(javaProject);
        HashSet<IPath> entryPaths = new HashSet<IPath>();
        entryPaths.add(ClasspathDependencyTestUtil.CUSTOM_CLASSPATH_CONTAINER);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(javaProject, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, entryPaths);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        ClasspathDependencyTestUtil.verifyClasspathDependencies(comp, archiveNames);
        UpdateClasspathAttributeUtil.removeDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(javaProject, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
    }

    public void testLibraryClasspathDependency() throws Exception {
        IProject project = ProjectUtil.createWebProject("TestWeb", "TestEAR");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        ClasspathDependencyTestUtil.addLibraryEntry(javaProject, ClasspathDependencyTestUtil.TEST3_JAR_PATH, true);
        HashSet<IPath> entryPaths = new HashSet<IPath>();
        entryPaths.add(ClasspathDependencyTestUtil.TEST3_JAR_PATH);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(javaProject, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, entryPaths);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test3.jar");
        ClasspathDependencyTestUtil.verifyClasspathDependencies(comp, archiveNames);
    }

    public void testClassFolderDependency() throws Exception {
        IProject project = ProjectUtil.createWebProject("TestWeb", "TestEAR");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        Path binPath = new Path("bin");
        IPath fullBinPath = project.getFullPath().append((IPath)binPath);
        project.getFolder((IPath)binPath).create(true, true, null);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        ClasspathDependencyTestUtil.addLibraryEntry(javaProject, fullBinPath, true);
        HashSet<IPath> entryPaths = new HashSet<IPath>();
        entryPaths.add(fullBinPath);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(javaProject, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(javaProject);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(comp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)project.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(javaProject);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(javaProject, entryPaths);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add(fullBinPath.toString());
        ClasspathDependencyTestUtil.verifyClasspathDependencies(comp, archiveNames);
    }
}

