/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.dependency.tests.AbstractTests;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyVerificationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;

public class ProjectWebLibRefactoringTests
extends AbstractTests {
    public ProjectWebLibRefactoringTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Project WEB-INF/lib Dependency Refactoring Tests");
        suite.addTest((Test)new ProjectWebLibRefactoringTests("testDeleteWebLibDependency"));
        suite.addTest((Test)new ProjectWebLibRefactoringTests("testRenameWebLibDependency"));
        suite.addTest((Test)new ProjectWebLibRefactoringTests("testDeleteMultipleDependency"));
        suite.addTest((Test)new ProjectWebLibRefactoringTests("testRenameMultipleModuleDependency"));
        return suite;
    }

    public void testDeleteWebLibDependency() throws Exception {
        IProject[] projects = ProjectWebLibRefactoringTests.setupWebLibDependency();
        IProject earProject = projects[0];
        IProject webProject = projects[1];
        IProject utilProject = projects[2];
        ProjectUtil.deleteProject(utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, utilProject);
        DependencyVerificationUtil.verifyWebLibDependencyRemoved(webProject, utilProject);
    }

    public void testRenameWebLibDependency() throws Exception {
        IProject[] projects = ProjectWebLibRefactoringTests.setupWebLibDependency();
        IProject earProject = projects[0];
        IProject webProject = projects[1];
        IProject utilProject = projects[2];
        IProject newUtil = ProjectUtil.renameProject(utilProject, "newUtil");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject, utilProject, newUtil);
        DependencyVerificationUtil.verifyWebLibDependencyChanged(webProject, utilProject, newUtil);
    }

    public void testDeleteMultipleDependency() throws Exception {
        IProject[] projects = ProjectWebLibRefactoringTests.setupMultipleDependency();
        IProject earProject1 = projects[0];
        IProject earProject2 = projects[1];
        IProject webProject1 = projects[2];
        IProject webProject2 = projects[3];
        IProject utilProject = projects[4];
        ProjectUtil.deleteProject(utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject1, utilProject);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject2, utilProject);
        DependencyVerificationUtil.verifyWebLibDependencyRemoved(webProject1, utilProject);
        DependencyVerificationUtil.verifyWebLibDependencyRemoved(webProject2, utilProject);
    }

    public void testRenameMultipleModuleDependency() throws Exception {
        IProject[] projects = ProjectWebLibRefactoringTests.setupMultipleDependency();
        IProject earProject1 = projects[0];
        IProject earProject2 = projects[1];
        IProject webProject1 = projects[2];
        IProject webProject2 = projects[3];
        IProject utilProject = projects[4];
        IProject newUtil = ProjectUtil.renameProject(utilProject, "newUtil");
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject1, utilProject, newUtil);
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject2, utilProject, newUtil);
        DependencyVerificationUtil.verifyWebLibDependencyChanged(webProject1, utilProject, newUtil);
        DependencyVerificationUtil.verifyWebLibDependencyChanged(webProject2, utilProject, newUtil);
    }

    private static IProject[] setupWebLibDependency() throws Exception {
        IProject earProject = ProjectUtil.getProject("TestEAR");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject.getName());
        IProject webProject = ProjectUtil.createWebProject("TestWeb", earProject.getName());
        DependencyCreationUtil.createWebLibDependency(webProject, utilProject);
        DependencyVerificationUtil.verifyEARDependency(earProject, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject, webProject, true);
        DependencyVerificationUtil.verifyWebLibDependency(webProject, utilProject);
        return new IProject[]{earProject, webProject, utilProject};
    }

    private static IProject[] setupMultipleDependency() throws Exception {
        IProject earProject1 = ProjectUtil.getProject("TestEAR1");
        IProject earProject2 = ProjectUtil.createEARProject("TestEAR2");
        IProject utilProject = ProjectUtil.createUtilityProject("TestUtil", earProject1.getName());
        DependencyCreationUtil.createEARDependency(earProject2, utilProject);
        IProject webProject1 = ProjectUtil.createWebProject("TestWeb1", earProject1.getName());
        IProject webProject2 = ProjectUtil.createWebProject("TestWeb2", earProject2.getName());
        DependencyCreationUtil.createWebLibDependency(webProject1, utilProject);
        DependencyCreationUtil.createWebLibDependency(webProject2, utilProject);
        DependencyVerificationUtil.verifyEARDependency(earProject1, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject1, webProject1, true);
        DependencyVerificationUtil.verifyEARDependency(earProject2, utilProject, false);
        DependencyVerificationUtil.verifyEARDependency(earProject2, webProject2, true);
        DependencyVerificationUtil.verifyWebLibDependency(webProject1, utilProject);
        DependencyVerificationUtil.verifyWebLibDependency(webProject2, utilProject);
        return new IProject[]{earProject1, earProject2, webProject1, webProject2, utilProject};
    }
}

