/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class ConnectorArtifactEditFVTest
extends TestCase {
    private IProject jcaProject;
    private String jcaModuleName;

    public ConnectorArtifactEditFVTest() {
        if (TestWorkspace.init()) {
            this.jcaProject = TestWorkspace.getTargetProject("JCAArtifactEditTest");
            this.jcaModuleName = "JCAArtifactEditTestModule";
        } else {
            ConnectorArtifactEditFVTest.fail();
        }
    }

    public void testCreationDisposeFunction() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForWrite((IProject)this.jcaProject);
            edit.addListener(new EditModelListener(){

                public void editModelChanged(EditModelEvent anEvent) {
                    ConnectorArtifactEditFVTest.this.pass();
                }
            });
            Connector client = edit.getConnector();
            this.updateClient(client);
            edit.save((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private void updateClient(Connector client) {
        client.setDescription("FVT Description Test");
        client.setDisplayName("FVT DisplayName Test");
        client.setLargeIcon("fvtLargeIcon.gif");
    }

    private static void pass(Connector client) {
        boolean pass = client.getDescription().equals("FVT Description Test") && client.getDisplayName().equals("FVT DisplayName Test") && client.getLargeIcon().equals("fvtLargeIcon.gif");
        ConnectorArtifactEditFVTest.assertTrue((boolean)pass);
    }

    private void pass() {
        ConnectorArtifactEditFVTest.assertTrue((boolean)true);
    }

    public void testPersistenceFunction() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForWrite((IProject)this.jcaProject);
            Connector jca = edit.getConnector();
            ConnectorArtifactEditFVTest.pass(jca);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private static void pass(ApplicationClient jca) {
        boolean pass = jca.getDescription().equals("FVT Description Test") && jca.getDisplayName().equals("FVT DisplayName Test") && jca.getLargeIcon().equals("fvtLargeIcon.gif");
        ConnectorArtifactEditFVTest.assertTrue((boolean)pass);
    }

    private void validateResource() {
        ConnectorArtifactEdit edit = null;
        try {
            edit = ConnectorArtifactEdit.getConnectorArtifactEditForWrite((IProject)this.jcaProject);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentResource createResourceComponent() {
        ComponentResource resourceComponent = ComponentcoreFactory.eINSTANCE.createComponentResource();
        File testFile = TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH.toFile();
        if (testFile.exists()) {
            resourceComponent.setRuntimePath(TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH);
            resourceComponent.setSourcePath(TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH);
        } else {
            ConnectorArtifactEditFVTest.fail((String)"Missing: TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH");
        }
        return resourceComponent;
    }
}

