/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public class WebArtifactEditFVTest
extends TestCase {
    private IProject webProject;

    public WebArtifactEditFVTest() {
        if (TestWorkspace.init()) {
            this.webProject = TestWorkspace.getTargetProject("WebArtifactEditTest");
        } else {
            WebArtifactEditFVTest.fail();
        }
    }

    public void testCreationDisposeFunction() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.webProject);
            edit.addListener(new EditModelListener(){

                public void editModelChanged(EditModelEvent anEvent) {
                    WebArtifactEditFVTest.this.pass();
                }
            });
            WebApp client = edit.getWebApp();
            this.updateClient(client);
            edit.save((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDeployableResourceGather() {
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)this.webProject);
        J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(this.webProject, webComp);
        try {
            IModuleResource[] resources = deployable.members();
            WebArtifactEditFVTest.assertTrue((resources.length > 1 ? 1 : 0) != 0);
            int numOfModuleResourceFolders = 0;
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IModuleFolder) {
                    ++numOfModuleResourceFolders;
                }
                ++i;
            }
            WebArtifactEditFVTest.assertTrue((numOfModuleResourceFolders == 2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            WebArtifactEditFVTest.fail((String)e.getMessage());
        }
    }

    private void updateClient(WebApp client) {
        client.setDescription("FVT Description Test");
        client.setDisplayName("FVT DisplayName Test");
        client.setLargeIcon("fvtLargeIcon.gif");
    }

    private void pass() {
        WebArtifactEditFVTest.assertTrue((boolean)true);
    }

    public void testPersistenceFunction() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.webProject);
            WebApp web = edit.getWebApp();
            Filter filter = WebapplicationFactory.eINSTANCE.createFilter();
            filter.setName("WoohooFilter");
            filter.setFilterClassName("wtp.test.WhooHoo");
            ParamValue value = CommonFactory.eINSTANCE.createParamValue();
            value.setName("Param1");
            value.setValue("Value1");
            ArrayList<ParamValue> initParams = new ArrayList<ParamValue>();
            initParams.add(value);
            filter.getInitParamValues().addAll(initParams);
            EList filters = web.getFilters();
            filters.add((Object)filter);
            edit.saveIfNecessary(null);
            WebArtifactEditFVTest.pass(web);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private static void pass(WebApp web) {
        boolean pass = web.getDescription().equals("FVT Description Test") && web.getDisplayName().equals("FVT DisplayName Test") && web.getLargeIcon().equals("fvtLargeIcon.gif");
        WebArtifactEditFVTest.assertTrue((boolean)pass);
    }
}

