/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.tests.modulecore;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.ProjectComponents;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ArtifactEditModelFactory;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRoot;
import org.eclipse.wst.common.componentcore.internal.util.SourcePathProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class ModuleStructuralModelTest
extends TestCase {
    public static final String MODULE__RESOURCE_URI_PROTOCOL = "module:/resource/";
    private IProject project;
    private EMFWorkbenchContext emfContext;

    public ModuleStructuralModelTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new ModuleStructuralModelTest("testResolveDependentModule"));
        return suite;
    }

    public void setUp() throws Exception {
        this.getProjectForWebModuleAndLocalWebLib().delete(true, null);
        this.getProjectForRemoteWebLib().delete(true, null);
        this.setupContent();
        super.setUp();
    }

    public void testResourceTree() throws Exception {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)StructureEdit.getContainingProject((URI)this.getWebModuleURI()));
            WorkbenchComponent module = moduleCore.getWorkbenchModules()[0];
            ResourceTreeRoot sourceRoot = new ResourceTreeRoot(module, SourcePathProvider.INSTANCE);
            ComponentResource[] resources = sourceRoot.findModuleResources(URI.createURI((String)"/WebContent/WEB-INF/web.xml"));
            System.out.println(resources[0] != null ? resources[0].getSourcePath().toString() : "NOT FOUND");
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
    }

    public void testResolveDependentModule() throws Exception {
        StructureEdit moduleCore = null;
        try {
            IProject containingProject = StructureEdit.getContainingProject((URI)this.getWebModuleURI());
            moduleCore = StructureEdit.getStructureEditForRead((IProject)containingProject);
            WorkbenchComponent[] modules = moduleCore.getWorkbenchModules();
            moduleCore.getComponentModelRoot();
            moduleCore.getClass();
            StructureEdit.getDeployedName((URI)this.getWebModuleURI());
            EList dependentModules = null;
            int i = 0;
            while (i < modules.length) {
                System.out.println("Module: " + modules[i].getName());
                EList list = modules[i].getResources();
                int j = 0;
                while (j < list.size()) {
                    ComponentResource wmr = (ComponentResource)list.get(j);
                    StructureEdit.getEclipseResource((ComponentResource)wmr);
                    ++j;
                }
                dependentModules = modules[i].getReferencedComponents();
                int dependentIndex = 0;
                while (dependentIndex < dependentModules.size()) {
                    ReferencedComponent dependentModule = (ReferencedComponent)dependentModules.get(dependentIndex);
                    WorkbenchComponent resolvedModule = moduleCore.findComponentByURI(dependentModule.getHandle());
                    System.out.println("\tDependentModule: " + resolvedModule.getName() + " in " + resolvedModule.getHandle());
                    moduleCore.isLocalDependency(dependentModule);
                    ++dependentIndex;
                }
                ++i;
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
    }

    public void testLoadResource() throws Exception {
        ArtifactEditModel artifactModel = null;
        try {
            URI moduleURI = URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getWebModuleAndLocalWebLibModuleProjectName() + "/" + this.getWebModuleAndLocalWebLibModuleProjectName() + ".war"));
            artifactModel = this.getNature(this.getProjectForWebModuleAndLocalWebLib()).getArtifactEditModelForRead(moduleURI, (Object)this);
            WebArtifactEdit editUtility = (WebArtifactEdit)artifactModel.getAdapter(WebArtifactEdit.ADAPTER_TYPE);
            WebApp webApp = (WebApp)editUtility.getDeploymentDescriptorRoot();
            if (webApp == null) {
                System.out.println("Read failed.");
            } else {
                System.out.println("Found WebApp: " + webApp.getDisplayName());
            }
        }
        finally {
            if (artifactModel != null) {
                artifactModel.releaseAccess((Object)this);
            }
        }
    }

    public void testURIAPI() throws Exception {
        URI uri = URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getWebModuleAndLocalWebLibModuleProjectName() + '/' + this.getWebModuleDeployedName() + ".war" + '/' + this.getTestResourcePath()));
        System.out.println("URI : \"" + uri.toString() + "\"" + " with scheme \"" + uri.scheme() + "\" has " + uri.segmentCount() + " segments. They are ...");
        String[] segments = uri.segments();
        int i = 0;
        while (i < segments.length) {
            System.out.println("[" + i + "]: " + segments[i]);
            ++i;
        }
        if ("resource".equals(segments[0])) {
            StructureEdit moduleCore = null;
            try {
                moduleCore = StructureEdit.getStructureEditForRead((IProject)StructureEdit.getContainingProject((URI)uri));
                ComponentResource[] resource = moduleCore.findResourcesByRuntimePath(uri);
                System.out.println(resource != null ? resource[0].getSourcePath().toString() : "NOT FOUND");
            }
            finally {
                if (moduleCore != null) {
                    moduleCore.dispose();
                }
            }
        } else {
            "binary".equals(segments[0]);
        }
    }

    public void testLoadingDocument() throws Exception {
        ArtifactEditModelFactory factory = new ArtifactEditModelFactory();
        URI moduleURI = URI.createURI((String)("module:/" + this.getWebModuleAndLocalWebLibModuleProjectName() + '/' + this.getWebModuleDeployedName()));
        URI ddURI = URI.createURI((String)"/WEB-INF/web.xml");
        HashMap<String, URI> params = new HashMap<String, URI>();
        params.put("MODULE_URI", moduleURI);
        EMFWorkbenchContext context = this.createEMFWorkbenchContext();
        ArtifactEditModel editModel = (ArtifactEditModel)factory.createEditModelForWrite("org.eclipse.jst.modules.web", context, params);
        Resource ddResource = editModel.getResource(ddURI);
        EObject rootObject = (EObject)ddResource.getContents().get(0);
        if (rootObject == null) {
            System.out.println("Read failed.");
        } else {
            System.out.println("Found WebApp: " + ((WebApp)rootObject).getDisplayName());
        }
    }

    public void setupContent() throws Exception {
        StructureEdit localModuleCore = null;
        try {
            this.getProjectForWebModuleAndLocalWebLib();
            IProject containingProject = StructureEdit.getContainingProject((URI)this.getWebModuleURI());
            localModuleCore = StructureEdit.getStructureEditForWrite((IProject)containingProject);
            this.createLocalModules(localModuleCore);
            this.getProjectForRemoteWebLib();
            WorkbenchComponent webModule = localModuleCore.getComponent();
            this.addDependentModule(webModule, (IPath)new Path("WEB-INF/lib"), this.getLocalWebLibraryModuleURI());
            this.addDependentModule(webModule, (IPath)new Path("WEB-INF/lib"), this.getRemoteWebLibraryModuleURI());
            localModuleCore.saveIfNecessary(null);
        }
        finally {
            if (localModuleCore != null) {
                localModuleCore.dispose();
            }
        }
    }

    public void createLocalModules(StructureEdit moduleCore) throws Exception {
        ProjectComponents projectModules = moduleCore.getComponentModelRoot();
        WorkbenchComponent webLibraryModule = this.addWorkbenchModule(projectModules, this.getLocalWebLibraryDeployedName(), this.getLocalWebLibraryModuleURI());
        IFolder localWebLibrary = this.getProjectForWebModuleAndLocalWebLib().getFolder(this.getLocalWebLibraryFolderName());
        if (!localWebLibrary.exists()) {
            localWebLibrary.create(true, true, null);
        }
        this.addResource(webLibraryModule, (IResource)localWebLibrary, "/");
    }

    public IFile getModuleRelativeFile(String aModuleRelativePath) throws Exception {
        return this.getProjectForWebModuleAndLocalWebLib().getFile((IPath)new Path(String.valueOf(this.getModulesFolder()) + '/' + aModuleRelativePath));
    }

    public void addResource(WorkbenchComponent aModule, IResource aSourceFile, String aDeployPath) {
        ComponentResource resource = ComponentcoreFactory.eINSTANCE.createComponentResource();
        resource.setSourcePath(aSourceFile.getFullPath());
        resource.setRuntimePath((IPath)new Path(aDeployPath));
        aModule.getResources().add((Object)resource);
    }

    public WorkbenchComponent addWorkbenchModule(ProjectComponents theModules, String aDeployedName, URI aHandle) {
        WorkbenchComponent module = ComponentcoreFactory.eINSTANCE.createWorkbenchComponent();
        module.setName(aDeployedName);
        theModules.getComponents().add((Object)module);
        return module;
    }

    public void addDependentModule(WorkbenchComponent aModule, IPath aDeployedPath, URI aHandle) {
        ReferencedComponent aClasspathDependentModule = ComponentcoreFactory.eINSTANCE.createReferencedComponent();
        aClasspathDependentModule.setRuntimePath(aDeployedPath);
        aClasspathDependentModule.setHandle(aHandle);
        aModule.getReferencedComponents().add((Object)aClasspathDependentModule);
    }

    public EMFWorkbenchContext createEMFWorkbenchContext() throws Exception {
        if (this.emfContext == null) {
            this.emfContext = new EMFWorkbenchContext(this.getProjectForWebModuleAndLocalWebLib());
        }
        return this.emfContext;
    }

    public IProject getProjectForWebModuleAndLocalWebLib() throws Exception {
        return this.getWebProject(this.getWebModuleAndLocalWebLibModuleProjectName());
    }

    public IProject getProjectForRemoteWebLib() throws Exception {
        return this.getJavaProject(this.getRemoteWebLibModuleProjectName());
    }

    public IProject getWebProject(String aProjectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!project.exists()) {
            project = this.createWebProject(aProjectName);
        }
        return project;
    }

    public IProject getJavaProject(String aProjectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        project.exists();
        return project;
    }

    public IProject createWebProject(String aProjectName) throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
        if (!this.project.exists()) {
            IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProjectName);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
    }

    public ModuleCoreNature getNature(IProject aProject) {
        try {
            return (ModuleCoreNature)aProject.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URI getWebModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getWebModuleAndLocalWebLibModuleProjectName() + '/' + this.getWebModuleDeployedName()));
    }

    public URI getLocalWebLibraryModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getWebModuleAndLocalWebLibModuleProjectName() + '/' + this.getLocalWebLibraryDeployedName()));
    }

    public URI getRemoteWebLibraryModuleURI() {
        return URI.createURI((String)(MODULE__RESOURCE_URI_PROTOCOL + this.getRemoteWebLibModuleProjectName() + '/' + this.getRemoteWebLibraryDeployedName()));
    }

    public String getWebModuleAndLocalWebLibModuleProjectName() {
        return "MyModulesProject";
    }

    public String getRemoteWebLibModuleProjectName() {
        return "RemoteWebLibProject";
    }

    public String getWebModuleDeployedName() {
        return String.valueOf(this.getWebModuleAndLocalWebLibModuleProjectName()) + ".war";
    }

    public String getLocalWebLibraryDeployedName() {
        return "LocalWebLibrary.jar";
    }

    public String getRemoteWebLibraryDeployedName() {
        return String.valueOf(this.getRemoteWebLibModuleProjectName()) + ".jar";
    }

    public String getModulesFolder() {
        return "MyWebModule";
    }

    public String getTestResourcePath() {
        return "WEB-INF/web.xml";
    }

    public String getLocalWebLibraryFolderName() {
        return "WebLibraryContents";
    }

    public static interface IModuleTypesConstants {
        public static final String MODULE_TYPE_WEB = "org.eclipse.jst.modules.web";
    }
}

