/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryField;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.BinaryField;
import org.eclipse.wst.jsdt.internal.core.BinaryMethod;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;

class ClassFileInfo
extends OpenableElementInfo
implements SuffixConstants {
    protected JavaElement[] binaryChildren = null;

    ClassFileInfo() {
    }

    private void generateFieldInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IBinaryField[] fields = typeInfo.getFields();
        if (fields == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        int fieldCount = fields.length;
        while (i < fieldCount) {
            IBinaryField fieldInfo = fields[i];
            BinaryField field = new BinaryField((JavaElement)((Object)type), manager.intern(new String(fieldInfo.getName())));
            newElements.put(field, fieldInfo);
            childrenHandles.add(field);
            ++i;
        }
    }

    private void generateInnerClassHandles(IType type, IBinaryType typeInfo, ArrayList childrenHandles) {
        IBinaryNestedType[] innerTypes = typeInfo.getMemberTypes();
        if (innerTypes != null) {
            IPackageFragment pkg = (IPackageFragment)type.getAncestor(4);
            int i = 0;
            int typeCount = innerTypes.length;
            while (i < typeCount) {
                IBinaryNestedType binaryType = innerTypes[i];
                IClassFile parentClassFile = pkg.getClassFile(String.valueOf(new String(ClassFile.unqualifiedName(binaryType.getName()))) + ".js");
                BinaryType innerType = new BinaryType((JavaElement)((Object)parentClassFile), ClassFile.simpleName(binaryType.getName()));
                childrenHandles.add(innerType);
                ++i;
            }
        }
    }

    private void generateMethodInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles, ArrayList typeParameterHandles) {
        IBinaryMethod[] methods = typeInfo.getMethods();
        if (methods == null) {
            return;
        }
        int i = 0;
        int methodCount = methods.length;
        while (i < methodCount) {
            IBinaryMethod methodInfo = methods[i];
            char[] signature = methodInfo.getGenericSignature();
            if (signature == null) {
                signature = methodInfo.getMethodDescriptor();
            }
            String[] pNames = null;
            try {
                pNames = Signature.getParameterTypes(new String(signature));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                signature = methodInfo.getMethodDescriptor();
                pNames = Signature.getParameterTypes(new String(signature));
            }
            char[][] paramNames = new char[pNames.length][];
            int j = 0;
            while (j < pNames.length) {
                paramNames[j] = pNames[j].toCharArray();
                ++j;
            }
            char[][] parameterTypes = ClassFile.translatedNames(paramNames);
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            String selector = new String(methodInfo.getSelector());
            if (methodInfo.isConstructor()) {
                selector = type.getElementName();
            }
            selector = manager.intern(selector);
            int j2 = 0;
            while (j2 < pNames.length) {
                pNames[j2] = manager.intern(new String(parameterTypes[j2]));
                ++j2;
            }
            BinaryMethod method = new BinaryMethod((JavaElement)((Object)type), selector, pNames);
            childrenHandles.add(method);
            while (newElements.containsKey(method)) {
                method.occurrenceCount = method.occurrenceCount + 1;
            }
            newElements.put(method, methodInfo);
            ++i;
        }
    }

    boolean hasReadBinaryChildren() {
        return this.binaryChildren != null;
    }

    protected void readBinaryChildren(ClassFile classFile, HashMap newElements, IBinaryType typeInfo) {
        ArrayList childrenHandles = new ArrayList();
        BinaryType type = (BinaryType)classFile.getType();
        ArrayList typeParameterHandles = new ArrayList();
        if (typeInfo != null) {
            this.generateFieldInfos(type, typeInfo, newElements, childrenHandles);
            this.generateMethodInfos(type, typeInfo, newElements, childrenHandles, typeParameterHandles);
            this.generateInnerClassHandles(type, typeInfo, childrenHandles);
        }
        this.binaryChildren = new JavaElement[childrenHandles.size()];
        childrenHandles.toArray(this.binaryChildren);
    }

    void removeBinaryChildren() throws JavaScriptModelException {
        if (this.binaryChildren != null) {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            int i = 0;
            while (i < this.binaryChildren.length) {
                JavaElement child = this.binaryChildren[i];
                if (child instanceof BinaryType) {
                    manager.removeInfoAndChildren((JavaElement)child.getParent());
                } else {
                    manager.removeInfoAndChildren(child);
                }
                ++i;
            }
            this.binaryChildren = JavaElement.NO_ELEMENTS;
        }
    }
}

