/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaNavigatorContentProvider
extends PackageExplorerContentProvider
implements IPipelinedTreeContentProvider {
    public static final String JSDT_EXTENSION_ID = "org.eclipse.wst.jsdt.ui.javaContent";
    public static final String JDT_EXTENSION_ID = "org.eclipse.wst.jsdt.ui.javaContent";
    private IExtensionStateModel fStateModel;
    private Object fRealInput;
    private IPropertyChangeListener fLayoutPropertyListener;

    public JavaNavigatorContentProvider() {
        super(false);
    }

    public JavaNavigatorContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        IExtensionStateModel stateModel = commonContentExtensionSite.getExtensionStateModel();
        IMemento memento = commonContentExtensionSite.getMemento();
        this.fStateModel = stateModel;
        this.restoreState(memento);
        this.fLayoutPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("isLayoutFlat".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue() != false;
                    JavaNavigatorContentProvider.this.setIsFlatLayout(newValue);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.fLayoutPropertyListener);
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.wst.jsdt.ui.packages.cuchildren");
        this.setProvideMembers(showCUChildren);
    }

    public void dispose() {
        super.dispose();
        this.fStateModel.removePropertyChangeListener(this.fLayoutPropertyListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fRealInput = newInput;
        super.inputChanged(viewer, oldInput, this.findInputElement(newInput));
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (parent instanceof IJavaScriptModel) {
            return parent.equals(this.getViewerInput()) ? this.fRealInput : parent;
        }
        if (parent instanceof IJavaScriptProject) {
            return ((IJavaScriptProject)parent).getProject();
        }
        return parent;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)inputElement;
            return root.getProjects();
        }
        if (inputElement instanceof IJavaScriptModel) {
            return ((IJavaScriptModel)inputElement).getWorkspace().getRoot().getProjects();
        }
        if (inputElement instanceof IProject) {
            return super.getElements(JavaScriptCore.create((IProject)((IProject)inputElement)));
        }
        return super.getElements(inputElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            return ((IProject)element).isAccessible();
        }
        if (this.getProvideMembers() && element instanceof IFile && JavaScriptCore.isJavaScriptLikeFileName((String)((IFile)element).getName())) {
            return JavaScriptCore.create((IFile)((IFile)element)) != null;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)parentElement;
            return root.getProjects();
        }
        if (parentElement instanceof IProject) {
            return super.getChildren(JavaScriptCore.create((IProject)((IProject)parentElement)));
        }
        if (this.getProvideMembers() && parentElement instanceof IFile && JavaScriptCore.isJavaScriptLikeFileName((String)((IFile)parentElement).getName())) {
            return super.getChildren(JavaScriptCore.create((IFile)((IFile)parentElement)));
        }
        return super.getChildren(parentElement);
    }

    private Object findInputElement(Object newInput) {
        if (newInput instanceof IWorkspaceRoot) {
            return JavaScriptCore.create((IWorkspaceRoot)((IWorkspaceRoot)newInput));
        }
        return newInput;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    private void customizeChildren(Object parent, Set currentChildren) {
        int i;
        if (!this.getProvideMembers()) {
            return;
        }
        if (parent instanceof IFile && JavaScriptCore.isJavaScriptLikeFileName((String)((IFile)parent).getName())) {
            Object[] children = this.getChildren(parent);
            i = 0;
            while (i < children.length) {
                currentChildren.add(children[i]);
                ++i;
            }
        }
        if (parent instanceof IProject) {
            Object[] projectChildren = super.getChildren(JavaScriptCore.create((IProject)((IProject)parent)));
            i = 0;
            while (i < projectChildren.length) {
                currentChildren.add(projectChildren[i]);
                ++i;
            }
        }
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        this.customizeChildren(parent, currentChildren);
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        this.customizeChildren(input, currentElements);
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        if (object instanceof IJavaScriptElement && ((IJavaScriptElement)object).getElementType() == 5) {
            try {
                IResource underlyingResource = ((IJavaScriptUnit)object).getUnderlyingResource();
                if (underlyingResource != null && underlyingResource.getType() < 4) {
                    return underlyingResource.getParent();
                }
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        return suggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        return addModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        return removeModification;
    }

    private void deconvertJavaProjects(PipelinedShapeModification modification) {
        LinkedHashSet<IProject> convertedChildren = new LinkedHashSet<IProject>();
        Iterator iterator = modification.getChildren().iterator();
        while (iterator.hasNext()) {
            Object added = iterator.next();
            if (!(added instanceof IJavaScriptProject)) continue;
            iterator.remove();
            convertedChildren.add(((IJavaScriptProject)added).getProject());
        }
        modification.getChildren().addAll(convertedChildren);
    }

    private boolean convertToJavaElements(PipelinedShapeModification modification) {
        IJavaScriptElement element;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (element = JavaScriptCore.create((IResource)((IContainer)parent))) != null && element.exists()) {
            if (!(element instanceof IJavaScriptModel) && !(element instanceof IJavaScriptProject)) {
                modification.setParent((Object)element);
            }
            return this.convertToJavaElements(modification.getChildren());
        }
        return false;
    }

    private boolean convertToJavaElements(Set currentChildren) {
        LinkedHashSet<Object> convertedChildren = new LinkedHashSet<Object>();
        Iterator childrenItr = currentChildren.iterator();
        while (childrenItr.hasNext()) {
            Object child = childrenItr.next();
            if (child instanceof IFolder || child instanceof IFile) {
                IJavaScriptElement newChild = JavaScriptCore.create((IResource)((IResource)child));
                if (newChild == null || !newChild.exists()) continue;
                childrenItr.remove();
                convertedChildren.add(newChild);
                continue;
            }
            if (!(child instanceof IJavaScriptProject)) continue;
            childrenItr.remove();
            convertedChildren.add(((IJavaScriptProject)child).getProject());
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        return false;
    }

    protected void postRefresh(List toRefresh, boolean updateLabels, Collection runnables) {
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IJavaScriptModel)) continue;
            iter.remove();
            toRefresh.add(element.equals(this.getViewerInput()) ? this.fRealInput : element);
            super.postRefresh(toRefresh, updateLabels, runnables);
            return;
        }
        super.postRefresh(toRefresh, updateLabels, runnables);
    }
}

