/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.wst.jsdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.wst.jsdt.internal.ui.search.SearchLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class PostfixLabelProvider
extends SearchLabelProvider {
    private ITreeContentProvider fContentProvider = new LevelTreeContentProvider.FastJavaElementProvider();

    public PostfixLabelProvider(JavaSearchResultPage page) {
        super(page);
    }

    public Image getImage(Object element) {
        Image image = super.getImage(element);
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    public String getText(Object element) {
        String labelWithCounts = this.getLabelWithCounts(element, this.internalGetText(element));
        return String.valueOf(labelWithCounts) + this.getQualification(element);
    }

    private String getQualification(Object element) {
        StringBuffer res = new StringBuffer();
        ITreeContentProvider provider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        Object visibleParent = provider.getParent(element);
        Object realParent = this.fContentProvider.getParent(element);
        Object lastElement = element;
        while (realParent != null && !(realParent instanceof IJavaScriptModel) && !realParent.equals(visibleParent)) {
            if (!this.isSameInformation(realParent, lastElement)) {
                res.append(JavaScriptElementLabels.CONCAT_STRING).append(this.internalGetText(realParent));
            }
            lastElement = realParent;
            realParent = this.fContentProvider.getParent(realParent);
        }
        return res.toString();
    }

    protected boolean hasChildren(Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        return contentProvider.hasChildren(element);
    }

    private String internalGetText(Object element) {
        String text = super.getText(element);
        if (text != null && text.length() > 0) {
            return text;
        }
        return this.getParticipantText(element);
    }

    private boolean isSameInformation(Object realParent, Object lastElement) {
        if (lastElement instanceof IType) {
            IType type = (IType)lastElement;
            if (realParent instanceof IClassFile ? type.getClassFile().equals(realParent) : realParent instanceof IJavaScriptUnit && type.getJavaScriptUnit().equals(realParent)) {
                return true;
            }
        }
        return false;
    }

    public ColoredString getRichTextLabel(Object element) {
        ColoredString coloredString = this.getColoredLabelWithCounts(element, super.getRichTextLabel(element));
        coloredString.append(this.getQualification(element), ColoredJavaElementLabels.QUALIFIER_STYLE);
        return coloredString;
    }
}

