/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameResourceDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public class RenameResourceProcessor
extends RenameProcessor
implements IScriptableRefactoring,
ICommentProvider,
INameUpdating {
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameResourceProcessor";
    private String fComment;
    private String fNewElementName;
    private RenameModifications fRenameModifications;
    private IResource fResource;
    static /* synthetic */ Class class$0;

    public RenameResourceProcessor(IResource resource) {
        this.fResource = resource;
        if (resource != null) {
            this.setNewElementName(resource.getName());
        }
    }

    public boolean canEnableComment() {
        return true;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws JavaScriptModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            this.fRenameModifications = new RenameModifications();
            this.fRenameModifications.rename(this.fResource, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker((Class)clazz);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.fRenameModifications.buildDelta(deltaFactory);
            refactoringStatus = new RefactoringStatus();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return RefactoringStatus.create((IStatus)Resources.checkInSync(this.fResource));
    }

    public RefactoringStatus checkNewElementName(String newName) throws JavaScriptModelException {
        Assert.isNotNull((Object)newName, (String)"new name");
        IContainer c = this.fResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_Internal_Error);
        }
        if (c.findMember(newName) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_alread_exists);
        }
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_invalidName);
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, this.fResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), this.fResource.getType())));
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws JavaScriptModelException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            String project = null;
            if (this.fResource.getType() != 4) {
                project = this.fResource.getProject().getName();
            }
            String header = Messages.format(RefactoringCoreMessages.RenameResourceChange_descriptor_description, new String[]{this.fResource.getFullPath().toString(), this.getNewElementName()});
            String description = Messages.format(RefactoringCoreMessages.RenameResourceChange_descriptor_description_short, this.fResource.getName());
            String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
            RenameResourceDescriptor descriptor = new RenameResourceDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(7);
            descriptor.setResource(this.fResource);
            descriptor.setNewName(this.getNewElementName());
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameResourceChange((RefactoringDescriptor)descriptor, this.fResource, this.getNewElementName(), comment));
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    private String createNewPath(String newName) {
        return this.fResource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    public String[] getAffectedProjectNatures() throws CoreException {
        return ResourceProcessors.computeAffectedNatures(this.fResource);
    }

    public String getComment() {
        return this.fComment;
    }

    public String getCurrentElementName() {
        return this.fResource.getName();
    }

    public Object[] getElements() {
        return new Object[]{this.fResource};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public Object getNewElement() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.createNewPath(this.getNewElementName()));
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameResourceProcessor_name;
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String name;
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                this.fResource = JDTRefactoringDescriptor.handleToResource(extended.getProject(), handle);
                if (this.fResource == null || !this.fResource.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(this.fResource, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.resource");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName(name);
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws JavaScriptModelException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fResource);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fRenameModifications.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewElementName = newName;
    }
}

