/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    char[] packageName = CharOperation.NO_CHAR;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;

    public SourceIndexerRequestor(SourceIndexer indexer) {
        this.indexer = indexer;
    }

    public void acceptConstructorReference(char[] typeName, int argCount, int sourcePosition) {
        this.indexer.addConstructorReference(typeName, argCount);
        int lastDot = CharOperation.lastIndexOf('.', typeName);
        if (lastDot != -1) {
            char[][] qualification = CharOperation.splitOn('.', CharOperation.subarray(typeName, 0, lastDot));
            int i = 0;
            int length = qualification.length;
            while (i < length) {
                this.indexer.addNameReference(qualification[i]);
                ++i;
            }
        }
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        this.indexer.addFieldReference(fieldName);
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[][] tokens, boolean onDemand) {
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition) {
        this.indexer.addMethodReference(methodName, argCount);
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        this.packageName = name;
    }

    public void acceptProblem(CategorizedProblem problem) {
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        int length = typeName.length;
        int i = 0;
        while (i < length - 1) {
            this.acceptUnknownReference(typeName[i], 0);
            ++i;
        }
        this.acceptTypeReference(typeName[length - 1], 0);
    }

    public void acceptTypeReference(char[] simpleTypeName, int sourcePosition) {
        this.indexer.addTypeReference(simpleTypeName);
    }

    public void acceptUnknownReference(char[][] name, int sourceStart, int sourceEnd) {
        int i = 0;
        while (i < name.length) {
            this.acceptUnknownReference(name[i], 0);
            ++i;
        }
    }

    public void acceptUnknownReference(char[] name, int sourcePosition) {
        this.indexer.addNameReference(name);
    }

    public char[][] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        char[][] qualification = new char[this.depth][];
        System.arraycopy(this.enclosingTypeNames, 0, qualification, 0, this.depth);
        return qualification;
    }

    private void enterClass(ISourceElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.anonymousMember) {
            this.pushTypeName(typeInfo.name);
            return;
        }
        if (typeInfo.superclass != null) {
            this.indexer.addConstructorReference(typeInfo.superclass, 0);
        }
        char[][] typeNames = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        char[] typeName = typeInfo.name;
        char[] pkgName = this.packageName;
        int index = CharOperation.lastIndexOf('.', typeName);
        if (index > 0) {
            pkgName = CharOperation.subarray(typeName, 0, index);
            typeName = CharOperation.subarray(typeName, index + 1, typeName.length);
        }
        this.indexer.addClassDeclaration(typeInfo.modifiers, pkgName, typeName, typeNames, typeInfo.superclass, typeInfo.secondary);
        this.pushTypeName(typeInfo.name);
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.indexer.addConstructorDeclaration(methodInfo.name, methodInfo.parameterTypes);
        ++this.methodDepth;
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        if (this.depth > 0 || this.methodDepth == 0) {
            boolean isVar = this.depth == 0;
            this.indexer.addFieldDeclaration(fieldInfo.type, fieldInfo.name, isVar);
        }
        ++this.methodDepth;
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        ++this.methodDepth;
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        boolean isFunction = this.depth == 0;
        this.indexer.addMethodDeclaration(methodInfo.name, methodInfo.parameterTypes, methodInfo.returnType, isFunction);
        ++this.methodDepth;
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        switch (TypeDeclaration.kind(typeInfo.modifiers)) {
            case 1: {
                this.enterClass(typeInfo);
            }
        }
    }

    public void exitCompilationUnit(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        --this.methodDepth;
    }

    public void exitInitializer(int declarationEnd) {
        --this.methodDepth;
    }

    public void exitMethod(int declarationEnd, int defaultValueStart, int defaultValueEnd) {
        --this.methodDepth;
    }

    public void exitType(int declarationEnd) {
        this.popTypeName();
    }

    /*
     * Enabled aggressive block sorting
     */
    private char[] getSimpleName(char[] typeName) {
        int lastDot = -1;
        int lastGenericStart = -1;
        int depthCount = 0;
        int length = typeName.length;
        int i = length - 1;
        block5: while (i >= 0) {
            switch (typeName[i]) {
                case '.': {
                    if (depthCount != 0) break;
                    lastDot = i;
                    break block5;
                }
                case '<': {
                    if (--depthCount != 0) break;
                    lastGenericStart = i;
                    break;
                }
                case '>': {
                    ++depthCount;
                }
            }
            --i;
        }
        if (lastGenericStart >= 0) {
            return CharOperation.subarray(typeName, lastDot + 1, lastGenericStart);
        }
        if (lastDot < 0) {
            return typeName;
        }
        return CharOperation.subarray(typeName, lastDot + 1, length);
    }

    public void popTypeName() {
        if (this.depth > 0) {
            this.enclosingTypeNames[--this.depth] = null;
        } else if (JobManager.VERBOSE) {
            try {
                this.enclosingTypeNames[-1] = null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    public void pushTypeName(char[] typeName) {
        if (this.depth == this.enclosingTypeNames.length) {
            char[][] cArrayArray = new char[this.depth * 2][];
            this.enclosingTypeNames = cArrayArray;
            System.arraycopy(this.enclosingTypeNames, 0, cArrayArray, 0, this.depth);
        }
        this.enclosingTypeNames[this.depth++] = typeName;
    }
}

