/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.navigator.ContainerFolder;
import org.eclipse.wst.jsdt.internal.ui.packageview.JsGlobalScopeContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.LibraryContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.NamespaceGroup;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.ProjectLibraryRoot;
import org.eclipse.wst.jsdt.ui.StandardJavaScriptElementContentProvider;

public class PackageExplorerContentProvider
extends StandardJavaScriptElementContentProvider
implements ITreeContentProvider,
IElementChangedListener,
IPropertyChangeListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    private TreeViewer fViewer;
    private Object fInput;
    private boolean fIsFlatLayout = false;
    private boolean fShowLibrariesNode = false;
    private boolean fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
    private Collection fPendingUpdates = null;
    private UIJob fUpdateJob;

    public PackageExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
        JavaScriptPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.fUpdateJob = null;
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.flatPackagesInPackageExplorer");
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void elementChanged(ElementChangedEvent event) {
        ArrayList runnables = new ArrayList();
        try {
            try {
                if (this.inputDeleted(runnables)) {
                    Object var4_3 = null;
                    this.executeRunnables(runnables);
                    return;
                }
                this.processDelta(event.getDelta(), runnables);
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.executeRunnables(runnables);
            throw throwable;
        }
        {
            Object var4_5 = null;
            this.executeRunnables(runnables);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeRunnables(Collection runnables) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            if (ctrl.getDisplay().getThread() == Thread.currentThread() && !this.fViewer.isBusy()) {
                this.runUpdates(runnables);
            } else {
                PackageExplorerContentProvider packageExplorerContentProvider = this;
                synchronized (packageExplorerContentProvider) {
                    if (this.fPendingUpdates == null) {
                        this.fPendingUpdates = runnables;
                    } else {
                        this.fPendingUpdates.addAll(runnables);
                    }
                }
                this.postAsyncUpdate(ctrl.getDisplay());
            }
        }
    }

    private void postAsyncUpdate(Display display) {
        if (this.fUpdateJob == null) {
            this.fUpdateJob = new UIJob(display, PackagesMessages.PackageExplorerContentProvider_update_job_description){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TreeViewer viewer = PackageExplorerContentProvider.this.fViewer;
                    if (viewer != null && viewer.isBusy()) {
                        this.schedule(100L);
                    } else {
                        PackageExplorerContentProvider.this.runPendingUpdates();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fUpdateJob.setSystem(true);
        }
        this.fUpdateJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPendingUpdates() {
        Control control;
        Collection pendingUpdates;
        PackageExplorerContentProvider packageExplorerContentProvider = this;
        synchronized (packageExplorerContentProvider) {
            pendingUpdates = this.fPendingUpdates;
            this.fPendingUpdates = null;
        }
        if (pendingUpdates != null && this.fViewer != null && (control = this.fViewer.getControl()) != null && !control.isDisposed()) {
            this.runUpdates(pendingUpdates);
        }
    }

    private void runUpdates(Collection runnables) {
        Iterator runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
        }
    }

    private boolean inputDeleted(Collection runnables) {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IJavaScriptElement && ((IJavaScriptElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        if (this.fInput instanceof IWorkingSet) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput, runnables);
        return true;
    }

    public void dispose() {
        super.dispose();
        JavaScriptCore.removeElementChangedListener((IElementChangedListener)this);
        JavaScriptPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot root) throws JavaScriptModelException {
        if (this.fIsFlatLayout) {
            return super.getPackageFragmentRootContent(root);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren(root, null, result);
        if (!this.isProjectPackageFragmentRoot(root)) {
            Object[] nonJavaResources = root.getNonJavaScriptResources();
            int i = 0;
            while (i < nonJavaResources.length) {
                result.add(nonJavaResources[i]);
                ++i;
            }
        }
        return result.toArray();
    }

    protected Object[] getPackageContent(IPackageFragment fragment) throws JavaScriptModelException {
        if (this.fIsFlatLayout) {
            return super.getPackageContent(fragment);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren((IPackageFragmentRoot)fragment.getParent(), fragment, result);
        Object[] nonPackages = super.getPackageContent(fragment);
        if (result.isEmpty()) {
            return nonPackages;
        }
        int i = 0;
        while (i < nonPackages.length) {
            result.add(nonPackages[i]);
            ++i;
        }
        return result.toArray();
    }

    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        if (this.fIsFlatLayout) {
            return super.getFolderContent(folder);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackagesInFolder(folder, result);
        Object[] others = super.getFolderContent(folder);
        if (result.isEmpty()) {
            return others;
        }
        int i = 0;
        while (i < others.length) {
            result.add(others[i]);
            ++i;
        }
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IJavaScriptModel) {
                return PackageExplorerContentProvider.concatenate(this.getJavaProjects((IJavaScriptModel)parentElement), this.getNonJavaProjects((IJavaScriptModel)parentElement));
            }
            if (parentElement instanceof ContainerFolder) {
                return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)((ContainerFolder)parentElement).getParentObject());
            }
            if (parentElement instanceof PackageFragmentRootContainer) {
                return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)parentElement, this.fIsFlatLayout, null);
            }
            if (parentElement instanceof NamespaceGroup && ((NamespaceGroup)parentElement).getPackageFragmentRootContainer() != null) {
                return this.getContainerPackageFragmentRoots(((NamespaceGroup)parentElement).getPackageFragmentRootContainer(), true, (NamespaceGroup)parentElement);
            }
            if (parentElement instanceof ProjectLibraryRoot) {
                Object[] children1 = ((ProjectLibraryRoot)parentElement).getChildren();
                ArrayList<IPackageFragmentRoot> sourceRoots = new ArrayList<IPackageFragmentRoot>();
                try {
                    IPackageFragmentRoot[] packageFragmentRoots = ((ProjectLibraryRoot)parentElement).getProject().getPackageFragmentRoots();
                    int i = 0;
                    while (i < packageFragmentRoots.length) {
                        IIncludePathEntry entry = packageFragmentRoots[i].getRawIncludepathEntry();
                        if (3 == entry.getEntryKind()) {
                            boolean hidden = false;
                            IIncludePathAttribute[] attribs = entry.getExtraAttributes();
                            int k = 0;
                            while (!hidden && attribs != null && k < attribs.length) {
                                hidden |= attribs[k] == IIncludePathAttribute.HIDE;
                                ++k;
                            }
                            if (!hidden) {
                                sourceRoots.add(packageFragmentRoots[i]);
                            }
                        }
                        ++i;
                    }
                }
                catch (JavaScriptModelException e) {
                    e.printStackTrace();
                }
                Object[] combined = new Object[children1.length + sourceRoots.size()];
                System.arraycopy(children1, 0, combined, 0, children1.length);
                if (!sourceRoots.isEmpty()) {
                    System.arraycopy(sourceRoots.toArray(), 0, combined, children1.length, sourceRoots.size());
                }
                return combined;
            }
            if (parentElement instanceof IProject) {
                IProject project = (IProject)parentElement;
                if (project.isAccessible()) {
                    return project.members();
                }
                return NO_CHILDREN;
            }
            if (parentElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)parentElement).isVirtual()) {
                return this.getLibraryChildren((IPackageFragmentRoot)parentElement, this.fIsFlatLayout, null);
            }
            if (parentElement instanceof NamespaceGroup && ((NamespaceGroup)parentElement).getPackageFragmentRoot() != null && ((NamespaceGroup)parentElement).getPackageFragmentRoot().isVirtual()) {
                return this.getLibraryChildren(((NamespaceGroup)parentElement).getPackageFragmentRoot(), true, (NamespaceGroup)parentElement);
            }
            if (parentElement instanceof IPackageFragmentRoot && 3 == ((IPackageFragmentRoot)parentElement).getRawIncludepathEntry().getEntryKind()) {
                return this.getSourceChildren(parentElement, this.fIsFlatLayout, null);
            }
            if (parentElement instanceof NamespaceGroup && ((NamespaceGroup)parentElement).getPackageFragmentRoot() != null && 3 == ((NamespaceGroup)parentElement).getPackageFragmentRoot().getRawIncludepathEntry().getEntryKind()) {
                return this.getSourceChildren(((NamespaceGroup)parentElement).getPackageFragmentRoot(), true, (NamespaceGroup)parentElement);
            }
            if (parentElement instanceof IJavaScriptUnit) {
                return this.getSourceChildren(parentElement, this.fIsFlatLayout, null);
            }
            if (parentElement instanceof NamespaceGroup && ((NamespaceGroup)parentElement).getJavaScriptUnit() != null) {
                return this.getSourceChildren(((NamespaceGroup)parentElement).getJavaScriptUnit(), true, (NamespaceGroup)parentElement);
            }
            return super.getChildren(parentElement);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return NO_CHILDREN;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return NO_CHILDREN;
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof JsGlobalScopeContainer) {
            return ((JsGlobalScopeContainer)element).hasChildren();
        }
        if (element instanceof ProjectLibraryRoot) {
            return ((ProjectLibraryRoot)element).hasChildren();
        }
        return super.hasChildren(element);
    }

    private Object[] getSourceChildren(Object parentElement, boolean neverGroup, NamespaceGroup onlyGroup) throws JavaScriptModelException {
        Object[] rawChildren = new Object[]{};
        if (parentElement instanceof IPackageFragmentRoot) {
            rawChildren = ((IParent)parentElement).getChildren();
        } else if (parentElement instanceof IJavaScriptUnit) {
            rawChildren = new Object[]{parentElement};
        }
        if (rawChildren == null) {
            return new Object[0];
        }
        ArrayList<Object> allChildren = new ArrayList<Object>();
        ArrayList<Object> expanded = new ArrayList<Object>();
        expanded.addAll(Arrays.asList(rawChildren));
        if (expanded.isEmpty()) {
            return new Object[0];
        }
        Object next = expanded.remove(0);
        HashMap<String, NamespaceGroup> groups = new HashMap<String, NamespaceGroup>();
        while (next != null) {
            if (next instanceof IPackageFragment) {
                expanded.addAll(Arrays.asList(((IPackageFragment)next).getChildren()));
            } else if (next instanceof IPackageFragmentRoot) {
                expanded.addAll(Arrays.asList(((IPackageFragmentRoot)next).getChildren()));
            } else if (next instanceof IClassFile || next instanceof IJavaScriptUnit) {
                String displayName;
                int j;
                IJavaScriptElement[] filtered = this.filter(((IParent)next).getChildren());
                List<IJavaScriptElement> newChildren = Arrays.asList(filtered);
                allChildren.removeAll(newChildren);
                if (this.fIsFlatLayout || neverGroup) {
                    if (onlyGroup == null) {
                        allChildren.addAll(newChildren);
                    } else {
                        j = 0;
                        while (j < filtered.length) {
                            switch (filtered[j].getElementType()) {
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 14: {
                                    displayName = filtered[j].getDisplayName();
                                    int groupNamesEnd = displayName.lastIndexOf(46);
                                    if (groupNamesEnd != onlyGroup.fNamePrefixLength || !displayName.startsWith(onlyGroup.fNamePrefix)) break;
                                    allChildren.add(filtered[j]);
                                    break;
                                }
                                default: {
                                    allChildren.add(filtered[j]);
                                }
                            }
                            ++j;
                        }
                    }
                } else {
                    j = 0;
                    while (j < filtered.length) {
                        switch (filtered[j].getElementType()) {
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 14: {
                                displayName = filtered[j].getDisplayName();
                                int groupEnd = displayName.lastIndexOf(46);
                                if (groupEnd > 0) {
                                    String groupName = displayName.substring(0, groupEnd);
                                    if (groups.containsKey(groupName)) break;
                                    NamespaceGroup group = null;
                                    if (parentElement instanceof IPackageFragmentRoot) {
                                        group = new NamespaceGroup((IPackageFragmentRoot)parentElement, groupName);
                                    } else if (parentElement instanceof IJavaScriptUnit) {
                                        group = new NamespaceGroup((IJavaScriptUnit)parentElement, groupName);
                                    }
                                    if (group == null) break;
                                    groups.put(groupName, group);
                                    allChildren.add(group);
                                    break;
                                }
                                allChildren.add(filtered[j]);
                                break;
                            }
                            default: {
                                allChildren.add(filtered[j]);
                            }
                        }
                        ++j;
                    }
                }
            }
            next = expanded.size() > 0 ? expanded.remove(0) : null;
        }
        return allChildren.toArray();
    }

    private Object[] getLibraryChildren(IPackageFragmentRoot container, boolean neverGroup, NamespaceGroup onlyGroup) {
        Object[] children = null;
        try {
            children = container.getChildren();
        }
        catch (JavaScriptModelException ex1) {
            ex1.printStackTrace();
        }
        if (children == null) {
            return null;
        }
        ArrayList<Object> allChildren = new ArrayList<Object>();
        HashMap<String, NamespaceGroup> groups = null;
        if (!this.fIsFlatLayout) {
            groups = new HashMap<String, NamespaceGroup>();
        }
        boolean unique = false;
        try {
            while (!unique && children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    String display2;
                    String display1 = ((IJavaScriptElement)children[0]).getDisplayName();
                    if (display1 != (display2 = ((IJavaScriptElement)children[i]).getDisplayName()) && (display1 == null || display1.compareTo(display2) != 0)) {
                        allChildren.addAll(Arrays.asList(children));
                        unique = true;
                        break;
                    }
                    ++i;
                }
                ArrayList<IJavaScriptElement> more = new ArrayList<IJavaScriptElement>();
                int i2 = 0;
                while (!unique && i2 < children.length) {
                    if (children[i2] instanceof IPackageFragment) {
                        more.addAll(Arrays.asList(((IPackageFragment)children[i2]).getChildren()));
                    } else if (children[i2] instanceof IPackageFragmentRoot) {
                        more.addAll(Arrays.asList(((IPackageFragmentRoot)children[i2]).getChildren()));
                    } else if (children[i2] instanceof IClassFile || children[i2] instanceof IJavaScriptUnit) {
                        String displayName;
                        int j;
                        IJavaScriptElement[] filtered = this.filter(((IParent)children[i2]).getChildren());
                        List<IJavaScriptElement> newChildren = Arrays.asList(filtered);
                        allChildren.removeAll(newChildren);
                        if (this.fIsFlatLayout || neverGroup) {
                            if (onlyGroup == null) {
                                allChildren.addAll(newChildren);
                            } else {
                                j = 0;
                                while (j < filtered.length) {
                                    switch (filtered[j].getElementType()) {
                                        case 7: 
                                        case 8: 
                                        case 9: 
                                        case 10: 
                                        case 14: {
                                            displayName = filtered[j].getDisplayName();
                                            int groupNamesEnd = displayName.lastIndexOf(46);
                                            if (groupNamesEnd != onlyGroup.fNamePrefixLength || !displayName.startsWith(onlyGroup.fNamePrefix)) break;
                                            allChildren.add(filtered[j]);
                                            break;
                                        }
                                        default: {
                                            allChildren.add(filtered[j]);
                                        }
                                    }
                                    ++j;
                                }
                            }
                        } else {
                            j = 0;
                            while (j < filtered.length) {
                                switch (filtered[j].getElementType()) {
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 14: {
                                        displayName = filtered[j].getDisplayName();
                                        int groupEnd = displayName.lastIndexOf(46);
                                        if (groupEnd > 0) {
                                            String groupName = displayName.substring(0, groupEnd);
                                            if (groups.containsKey(groupName)) break;
                                            NamespaceGroup group = new NamespaceGroup(container, groupName);
                                            groups.put(groupName, group);
                                            allChildren.add(group);
                                            break;
                                        }
                                        allChildren.add(filtered[j]);
                                        break;
                                    }
                                    default: {
                                        allChildren.add(filtered[j]);
                                    }
                                }
                                ++j;
                            }
                        }
                    } else {
                        unique = true;
                        break;
                    }
                    ++i2;
                }
                if (unique) continue;
                children = more.toArray();
            }
        }
        catch (JavaScriptModelException ex) {
            ex.printStackTrace();
        }
        return allChildren.toArray();
    }

    protected Object[] getPackageFragmentRoots(IJavaScriptProject project) throws JavaScriptModelException {
        IIncludePathEntry classpathEntry;
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ArrayList<ProjectLibraryRoot> result = new ArrayList<ProjectLibraryRoot>();
        boolean addJARContainer = false;
        ArrayList<Object> projectPackageFragmentRoots = new ArrayList<Object>();
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            classpathEntry = root.getRawIncludepathEntry();
            IIncludePathAttribute[] attribs = classpathEntry.getExtraAttributes();
            int p = 0;
            while (p < attribs.length) {
                if (attribs[p] == IIncludePathAttribute.HIDE) {
                    // empty if block
                }
                ++p;
            }
            int entryKind = classpathEntry.getEntryKind();
            if (entryKind != 5) {
                if (this.fShowLibrariesNode && entryKind != 3 && entryKind != 5) {
                    addJARContainer = true;
                    projectPackageFragmentRoots.add(root);
                } else {
                    this.isProjectPackageFragmentRoot(root);
                }
            }
            ++i;
        }
        if (addJARContainer) {
            projectPackageFragmentRoots.add(new LibraryContainer(project));
        }
        IIncludePathEntry[] rawClasspath = project.getRawIncludepath();
        int i2 = 0;
        while (i2 < rawClasspath.length) {
            classpathEntry = rawClasspath[i2];
            if (classpathEntry.getEntryKind() == 5) {
                projectPackageFragmentRoots.add(new JsGlobalScopeContainer(project, classpathEntry));
            }
            ++i2;
        }
        ProjectLibraryRoot projectLibs = new ProjectLibraryRoot(project);
        result.add(0, projectLibs);
        return result.toArray();
    }

    public Object getParent(Object element) {
        IJavaScriptProject project;
        if (element instanceof NamespaceGroup) {
            return ((NamespaceGroup)element).getParent();
        }
        if (element instanceof IPackageFragmentRoot && (project = (IJavaScriptProject)((IPackageFragmentRoot)element).getAncestor(2)) != null) {
            return new ProjectLibraryRoot(project);
        }
        return super.getParent(element);
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer container) {
        return this.getContainerPackageFragmentRoots(container, false, null);
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer container, boolean neverGroup, NamespaceGroup onlyGroup) {
        IAdaptable[] children = container.getChildren();
        if (children == null) {
            return new Object[0];
        }
        ArrayList<Object> allChildren = new ArrayList<Object>();
        ArrayList<Object> expanded = new ArrayList<Object>();
        expanded.addAll(Arrays.asList(children));
        if (expanded.isEmpty()) {
            return new Object[0];
        }
        HashMap<String, NamespaceGroup> groups = null;
        if (!this.fIsFlatLayout) {
            groups = new HashMap<String, NamespaceGroup>();
        }
        Object next = expanded.remove(0);
        while (next != null) {
            try {
                if (next instanceof IPackageFragment) {
                    expanded.addAll(Arrays.asList(((IPackageFragment)next).getChildren()));
                } else if (next instanceof IPackageFragmentRoot) {
                    expanded.addAll(Arrays.asList(((IPackageFragmentRoot)next).getChildren()));
                } else if (next instanceof IClassFile || next instanceof IJavaScriptUnit) {
                    String displayName;
                    int j;
                    IJavaScriptElement[] filtered = this.filter(((IParent)next).getChildren());
                    List<IJavaScriptElement> newChildren = Arrays.asList(filtered);
                    allChildren.removeAll(newChildren);
                    if (this.fIsFlatLayout || neverGroup) {
                        if (onlyGroup == null) {
                            allChildren.addAll(newChildren);
                        } else {
                            j = 0;
                            while (j < filtered.length) {
                                switch (filtered[j].getElementType()) {
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 14: {
                                        displayName = filtered[j].getDisplayName();
                                        int groupNamesEnd = displayName.lastIndexOf(46);
                                        if (groupNamesEnd != onlyGroup.fNamePrefixLength || !displayName.startsWith(onlyGroup.fNamePrefix)) break;
                                        allChildren.add(filtered[j]);
                                        break;
                                    }
                                    default: {
                                        allChildren.add(filtered[j]);
                                    }
                                }
                                ++j;
                            }
                        }
                    } else {
                        j = 0;
                        while (j < filtered.length) {
                            switch (filtered[j].getElementType()) {
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 14: {
                                    displayName = filtered[j].getDisplayName();
                                    int groupEnd = displayName.lastIndexOf(46);
                                    if (groupEnd > 0) {
                                        String groupName = displayName.substring(0, groupEnd);
                                        if (groups.containsKey(groupName)) break;
                                        NamespaceGroup group = new NamespaceGroup(container, groupName);
                                        groups.put(groupName, group);
                                        allChildren.add(group);
                                        break;
                                    }
                                    allChildren.add(filtered[j]);
                                    break;
                                }
                                default: {
                                    allChildren.add(filtered[j]);
                                }
                            }
                            ++j;
                        }
                    }
                } else {
                    allChildren.add(next);
                }
            }
            catch (JavaScriptModelException ex) {
                ex.printStackTrace();
            }
            next = expanded.size() > 0 ? expanded.remove(0) : null;
        }
        return allChildren.toArray();
    }

    private Object[] getContainerPackageFragmentRootsDeprc(PackageFragmentRootContainer container, boolean createFolder) {
        if (container != null) {
            Object[] children = container.getChildren();
            if (children == null) {
                return null;
            }
            ArrayList<IAdaptable> allChildren = new ArrayList<IAdaptable>();
            boolean unique = false;
            while (!unique && children != null && children.length > 0) {
                String display1 = null;
                int i = 0;
                while (i < children.length) {
                    String display2;
                    display1 = ((IJavaScriptElement)children[0]).getDisplayName();
                    if (display1 != (display2 = ((IJavaScriptElement)children[i]).getDisplayName()) && (display1 == null || display1.compareTo(display2) != 0)) {
                        allChildren.addAll(Arrays.asList(children));
                        unique = true;
                        break;
                    }
                    ++i;
                }
                if (!unique && createFolder) {
                    ContainerFolder folder = new ContainerFolder(display1, container);
                    return new Object[]{folder};
                }
                ArrayList<IJavaScriptElement> more = new ArrayList<IJavaScriptElement>();
                int i2 = 0;
                while (!unique && i2 < children.length) {
                    block17: {
                        try {
                            if (children[i2] instanceof IPackageFragment) {
                                more.addAll(Arrays.asList(((IPackageFragment)children[i2]).getChildren()));
                                break block17;
                            }
                            if (children[i2] instanceof IPackageFragmentRoot) {
                                more.addAll(Arrays.asList(((IPackageFragmentRoot)children[i2]).getChildren()));
                                break block17;
                            }
                            if (children[i2] instanceof IClassFile) {
                                more.addAll(Arrays.asList(this.filter(((IClassFile)children[i2]).getChildren())));
                                break block17;
                            }
                            if (children[i2] instanceof IJavaScriptUnit) {
                                more.addAll(Arrays.asList(this.filter(((IJavaScriptUnit)children[i2]).getChildren())));
                                break block17;
                            }
                            unique = true;
                            break;
                        }
                        catch (JavaScriptModelException ex) {
                            ex.printStackTrace();
                        }
                    }
                    ++i2;
                }
                if (unique) continue;
                children = more.toArray();
            }
            return allChildren.toArray();
        }
        IAdaptable[] children = container.getChildren();
        if (children == null) {
            return null;
        }
        ArrayList<IJavaScriptElement> allChildren = new ArrayList<IJavaScriptElement>();
        int i = 0;
        while (i < children.length) {
            try {
                allChildren.addAll(Arrays.asList(((IPackageFragmentRoot)children[i]).getChildren()));
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
        return allChildren.toArray();
    }

    private Object[] getNonJavaProjects(IJavaScriptModel model) throws JavaScriptModelException {
        return model.getNonJavaScriptResources();
    }

    protected Object internalGetParent(Object element) {
        if (!this.fIsFlatLayout && element instanceof IPackageFragment) {
            return this.getHierarchicalPackageParent((IPackageFragment)element);
        }
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            try {
                IIncludePathEntry entry = root.getRawIncludepathEntry();
                int entryKind = entry.getEntryKind();
                if (entryKind == 5) {
                    return new JsGlobalScopeContainer(root.getJavaScriptProject(), entry);
                }
                if (this.fShowLibrariesNode && (entryKind == 1 || entryKind == 4)) {
                    return new LibraryContainer(root.getJavaScriptProject());
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        } else if (element instanceof PackageFragmentRootContainer) {
            return ((PackageFragmentRootContainer)element).getJavaProject();
        }
        return super.internalGetParent(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            JavaScriptCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            JavaScriptCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    private void getHierarchicalPackageChildren(IPackageFragmentRoot parent, IPackageFragment fragment, Collection result) throws JavaScriptModelException {
        String prefix;
        IJavaScriptElement[] children = parent.getChildren();
        String string = prefix = fragment != null ? String.valueOf(fragment.getElementName()) + '/' : "";
        if (prefix.length() == 1) {
            prefix = "";
        }
        int prefixLen = prefix.length();
        int i = 0;
        while (i < children.length) {
            IPackageFragment curr = (IPackageFragment)children[i];
            if (fragment == null) {
                if (curr.isDefaultPackage()) {
                    result.add(curr);
                }
            } else {
                String name = curr.getElementName();
                if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(47, prefixLen) == -1) {
                    if (this.fFoldPackages) {
                        curr = PackageExplorerContentProvider.getFolded(children, curr);
                    }
                    result.add(curr);
                }
            }
            ++i;
        }
    }

    private void getHierarchicalPackagesInFolder(IFolder folder, Collection result) throws CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IFolder curr;
            IJavaScriptElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = JavaScriptCore.create((IFolder)(curr = (IFolder)resource))) instanceof IPackageFragment && element.exists()) {
                if (this.fFoldPackages) {
                    IPackageFragment fragment = (IPackageFragment)element;
                    IPackageFragmentRoot root = (IPackageFragmentRoot)fragment.getParent();
                    element = PackageExplorerContentProvider.getFolded(root.getChildren(), fragment);
                }
                result.add(element);
            }
            ++i;
        }
    }

    public Object getHierarchicalPackageParent(IPackageFragment child) {
        String name = child.getElementName();
        IPackageFragmentRoot parent = (IPackageFragmentRoot)child.getParent();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            IPackageFragment element = parent.getPackageFragment(realParentName);
            if (element.exists()) {
                try {
                    if (this.fFoldPackages && PackageExplorerContentProvider.isEmpty(element) && PackageExplorerContentProvider.findSinglePackageChild(element, parent.getChildren()) != null) {
                        return this.getHierarchicalPackageParent(element);
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
                return element;
            }
            IResource resource = element.getResource();
            if (resource != null) {
                return resource;
            }
        }
        if (parent.getResource() instanceof IProject) {
            return parent.getJavaScriptProject();
        }
        return parent;
    }

    private static IPackageFragment getFolded(IJavaScriptElement[] children, IPackageFragment pack) throws JavaScriptModelException {
        while (PackageExplorerContentProvider.isEmpty(pack)) {
            IPackageFragment collapsed = PackageExplorerContentProvider.findSinglePackageChild(pack, children);
            if (collapsed == null) {
                return pack;
            }
            pack = collapsed;
        }
        return pack;
    }

    private static boolean isEmpty(IPackageFragment fragment) throws JavaScriptModelException {
        return !fragment.containsJavaResources() && fragment.getNonJavaScriptResources().length == 0;
    }

    private static IPackageFragment findSinglePackageChild(IPackageFragment fragment, IJavaScriptElement[] children) {
        String prefix = String.valueOf(fragment.getElementName()) + '/';
        int prefixLen = prefix.length();
        IPackageFragment found = null;
        int i = 0;
        while (i < children.length) {
            IJavaScriptElement element = children[i];
            String name = element.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(47, prefixLen) == -1) {
                if (found == null) {
                    found = (IPackageFragment)element;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return found;
    }

    private boolean processDelta(IJavaScriptElementDelta delta, Collection runnables) throws JavaScriptModelException {
        Object parent;
        IJavaScriptProject proj;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IJavaScriptElement element = delta.getElement();
        int elementType = element.getElementType();
        if (!(elementType == 1 || elementType == 2 || (proj = element.getJavaScriptProject()) != null && proj.getProject().isOpen())) {
            return false;
        }
        if (!this.fIsFlatLayout && elementType == 4) {
            if (kind == 2) {
                parent = this.getHierarchicalPackageParent((IPackageFragment)element);
                if (parent instanceof IPackageFragmentRoot) {
                    this.postRemove(element, runnables);
                    return false;
                }
                this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                return true;
            }
            if (kind == 1) {
                parent = this.getHierarchicalPackageParent((IPackageFragment)element);
                if (parent instanceof IPackageFragmentRoot) {
                    return false;
                }
                this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                return true;
            }
            this.handleAffectedChildren(delta, element, runnables);
            return false;
        }
        if (elementType == 5) {
            IJavaScriptUnit cu = (IJavaScriptUnit)element;
            if (!JavaModelUtil.isPrimary(cu)) {
                return false;
            }
            if (!this.getProvideMembers() && cu.isWorkingCopy() && kind == 4) {
                return false;
            }
            if (kind == 4 && (flags & 1) == 1) {
                return false;
            }
            if (!this.isOnClassPath(cu)) {
                return false;
            }
        }
        if (elementType == 2) {
            if ((flags & 0x600) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if ((flags & 0x20000) != 0) {
                this.postRefresh(element, 0, element, runnables);
                if (element.getElementType() == 2) {
                    this.postRefresh(((IJavaScriptProject)element).getProject(), 0, ((IJavaScriptProject)element).getProject(), runnables);
                }
                return false;
            }
            if (kind == 1) {
                return false;
            }
        }
        if (kind == 2) {
            parent = this.internalGetParent(element);
            if (element instanceof IPackageFragment) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(parent, 1, element, runnables);
                }
                return true;
            }
            this.postRemove(element, runnables);
            if (parent instanceof IPackageFragment) {
                this.postUpdateIcon((IJavaScriptElement)((IPackageFragment)parent), runnables);
            }
            if (this.isPackageFragmentEmpty(element.getParent())) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                }
                return true;
            }
            return false;
        }
        if (kind == 1 && (parent = this.internalGetParent(element)) instanceof IPackageFragment) {
            Object grandparent = this.internalGetParent(parent);
            if (parent.equals(this.fInput)) {
                this.postRefresh(parent, 1, element, runnables);
            } else if (this.fViewer.testFindItem(parent) == null) {
                this.postRefresh(grandparent, 2, element, runnables);
            } else {
                this.postRefresh(parent, 1, element, runnables);
            }
            return true;
        }
        if (elementType == 5) {
            if (kind == 4) {
                IJavaScriptElement parent2;
                this.postRefresh(element, 0, element, runnables);
                IResource underlyingResource = ((IJavaScriptUnit)element).getUnderlyingResource();
                if (underlyingResource != null) {
                    this.postRefresh(underlyingResource, 0, element, runnables);
                }
                if ((flags & 0x40000) != 0 && (parent2 = element.getAncestor(3)) != null) {
                    this.postRefresh(parent2, 0, element, runnables);
                }
                this.updateSelection(delta, runnables);
            }
            return false;
        }
        if (elementType == 6) {
            return false;
        }
        if (elementType == 3) {
            if ((flags & 0x8000) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if ((flags & 0x3000) != 0) {
                this.postUpdateIcon(element, runnables);
            }
            if (this.isClassPathChange(delta)) {
                this.postRefresh(element.getJavaScriptProject(), 4, element, runnables);
                return true;
            }
        }
        this.handleAffectedChildren(delta, element, runnables);
        return false;
    }

    private static boolean isStructuralCUChange(int flags) {
        return (flags & 8) != 0 || (flags & 0x4001) == 1;
    }

    void handleAffectedChildren(IJavaScriptElementDelta delta, IJavaScriptElement element, Collection runnables) throws JavaScriptModelException {
        int count = 0;
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            int i = 0;
            while (i < resourceDeltas.length) {
                int kind = resourceDeltas[i].getKind();
                if (kind == 1 || kind == 2) {
                    ++count;
                }
                ++i;
            }
        }
        IJavaScriptElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            int kind = affectedChildren[i].getKind();
            if (kind == 1 || kind == 2) {
                ++count;
            }
            ++i;
        }
        if (count > 1) {
            if (element instanceof IPackageFragment) {
                IJavaScriptElement parent = (IJavaScriptElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element, 0, element, runnables);
                } else {
                    this.postRefresh(parent, 1, element, runnables);
                }
            } else if (element instanceof IPackageFragmentRoot) {
                Object toRefresh = this.internalGetParent(element);
                this.postRefresh(toRefresh, 0, toRefresh, runnables);
            } else {
                this.postRefresh(element, 0, element, runnables);
            }
            return;
        }
        if (resourceDeltas != null) {
            i = 0;
            while (i < resourceDeltas.length) {
                if (this.processResourceDelta(resourceDeltas[i], element, runnables)) {
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < affectedChildren.length) {
            if (this.processDelta(affectedChildren[i], runnables)) {
                return;
            }
            ++i;
        }
    }

    protected void processAffectedChildren(IJavaScriptElementDelta[] affectedChildren, Collection runnables) throws JavaScriptModelException {
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i], runnables);
            ++i;
        }
    }

    private boolean isOnClassPath(IJavaScriptUnit element) {
        IJavaScriptProject project = element.getJavaScriptProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnIncludepath((IJavaScriptElement)element);
    }

    private void updateSelection(IJavaScriptElementDelta delta, Collection runnables) {
        final IJavaScriptElement addedElement = this.findAddedElement(delta);
        if (addedElement != null) {
            final StructuredSelection selection = new StructuredSelection((Object)addedElement);
            runnables.add(new Runnable(){

                public void run() {
                    if (PackageExplorerContentProvider.this.fViewer.testFindItem((Object)addedElement) != null) {
                        PackageExplorerContentProvider.this.fViewer.setSelection((ISelection)selection);
                    }
                }
            });
        }
    }

    private IJavaScriptElement findAddedElement(IJavaScriptElementDelta delta) {
        if (delta.getKind() == 1) {
            return delta.getElement();
        }
        int i = 0;
        IJavaScriptElementDelta[] affectedChildren = delta.getAffectedChildren();
        if (i < affectedChildren.length) {
            return this.findAddedElement(affectedChildren[i]);
        }
        return null;
    }

    private void postUpdateIcon(final IJavaScriptElement element, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
            }
        });
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent, Collection runnables) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent), 1, parent, runnables);
                return true;
            }
            this.postRemove(resource, runnables);
            return false;
        }
        if ((status & 1) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent), 1, parent, runnables);
                return true;
            }
            return false;
        }
        if ((status & 4) != 0 && (flags & 0x8000) != 0) {
            this.postRefresh(parent, 1, resource, runnables);
            return true;
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent), runnables);
            return true;
        }
        IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
        int count = 0;
        int i = 0;
        while (i < resourceDeltas.length) {
            int kind = resourceDeltas[i].getKind();
            if ((kind == 1 || kind == 2) && ++count > 1) {
                this.postRefresh(parent, 1, resource, runnables);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < resourceDeltas.length) {
            if (this.processResourceDelta(resourceDeltas[i], resource, runnables)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
    }

    public void setShowLibrariesNode(boolean state) {
        this.fShowLibrariesNode = state;
    }

    private void postRefresh(Object root, int relation, Object affectedElement, Collection runnables) {
        if (this.isParent(root, this.fInput)) {
            root = this.fInput;
        }
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        toRefresh.add(root);
        this.augmentElementToRefresh(toRefresh, relation, affectedElement);
        this.postRefresh(toRefresh, true, runnables);
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
    }

    private boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    protected void postRefresh(final List toRefresh, final boolean updateLabels, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                Iterator iter = toRefresh.iterator();
                while (iter.hasNext()) {
                    PackageExplorerContentProvider.this.fViewer.refresh(iter.next(), updateLabels);
                }
            }
        });
    }

    protected void postRemove(final Object element, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.remove(element);
            }
        });
    }

    protected void postProjectStateChanged(final Object root, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.refresh(root, true);
                PackageExplorerContentProvider.this.fViewer.setSelection(PackageExplorerContentProvider.this.fViewer.getSelection());
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.getControl().setRedraw(false);
                Object[] expandedObjects = this.fViewer.getExpandedElements();
                this.fViewer.refresh();
                this.fViewer.setExpandedElements(expandedObjects);
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }
}

