/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.navigator.internal.EMFRootObjectProvider;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public abstract class JEE5ContentProvider
implements ITreeContentProvider,
EMFRootObjectProvider.IRefreshHandlerListener,
IModelProviderListener,
IResourceChangeListener {
    protected Viewer viewer;
    protected static final Class IPROJECT_CLASS = IProject.class;
    protected static Map<IProject, IModelProvider> groupProvidersMap = new HashMap<IProject, IModelProvider>();
    protected static Map<IProject, AbstractGroupProvider> groupContentProviders = new HashMap<IProject, AbstractGroupProvider>();

    public JEE5ContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
    }

    protected IModelProvider getCachedModelProvider(IProject project) {
        IModelProvider provider = groupProvidersMap.get(project);
        if (provider == null) {
            provider = ModelProviderManager.getModelProvider((IProject)project);
            provider.addListener((IModelProviderListener)this);
            groupProvidersMap.put(project, provider);
        }
        return provider;
    }

    protected AbstractGroupProvider getCachedContentProvider(IProject project) {
        AbstractGroupProvider provider = groupContentProviders.get(project);
        if (provider == null) {
            if (project == null || !project.isAccessible()) {
                return null;
            }
            provider = this.getNewContentProviderInstance(project);
            groupContentProviders.put(project, provider);
        } else {
            Object modelObject = ModelProviderManager.getModelProvider((IProject)project).getModelObject();
            if (provider.getJavaEEObject() != modelObject) {
                if (modelObject == null) {
                    provider.setValid(false);
                    return provider;
                }
                provider.reinit((JavaEEObject)modelObject);
            }
        }
        return provider;
    }

    protected abstract AbstractGroupProvider getNewContentProviderInstance(IProject var1);

    public void projectChanged(final IProject project) {
        try {
            Runnable refreshThread = new Runnable(){

                public void run() {
                    if (JEE5ContentProvider.this.viewer != null) {
                        try {
                            if (JEE5ContentProvider.this.viewer.getControl() != null && !JEE5ContentProvider.this.viewer.getControl().isDisposed()) {
                                JEE5ContentProvider.this.viewer.getControl().setRedraw(false);
                                ISelection sel = ((TreeViewer)JEE5ContentProvider.this.viewer).getSelection();
                                ITreeContentProvider contentProvider = (ITreeContentProvider)((TreeViewer)JEE5ContentProvider.this.viewer).getContentProvider();
                                contentProvider.getChildren((Object)project);
                                Object[] expandedElements = ((TreeViewer)JEE5ContentProvider.this.viewer).getExpandedElements();
                                ((StructuredViewer)JEE5ContentProvider.this.viewer).refresh((Object)project);
                                ((TreeViewer)JEE5ContentProvider.this.viewer).setSelection(sel);
                                this.expandElements(expandedElements);
                            }
                        }
                        finally {
                            if (JEE5ContentProvider.this.viewer.getControl() != null && !JEE5ContentProvider.this.viewer.getControl().isDisposed()) {
                                JEE5ContentProvider.this.viewer.getControl().setRedraw(true);
                            }
                        }
                    }
                }

                private void expandElements(Object[] expandedElements) {
                    ArrayList<Object> newExpandedElements = new ArrayList<Object>();
                    ArrayList allElements = new ArrayList();
                    JEE5ContentProvider.this.getViewerElements(allElements, (Widget)((TreeViewer)JEE5ContentProvider.this.viewer).getControl());
                    Object[] expandedElementsAfterRefresh = ((TreeViewer)JEE5ContentProvider.this.viewer).getExpandedElements();
                    newExpandedElements.addAll(Arrays.asList(expandedElementsAfterRefresh));
                    int i = 0;
                    while (i < expandedElements.length) {
                        boolean expanded = false;
                        int j = 0;
                        while (j < expandedElementsAfterRefresh.length) {
                            if (expandedElements[i].equals(expandedElementsAfterRefresh[j])) {
                                expanded = true;
                                break;
                            }
                            ++j;
                        }
                        if (expanded) {
                            for (Object ob : allElements) {
                                SessionBean bean2;
                                SessionBean bean;
                                if (ob instanceof SessionBean && expandedElements[i] instanceof SessionBean) {
                                    bean = (SessionBean)ob;
                                    bean2 = (SessionBean)expandedElements[i];
                                    if (bean.getEjbName().equals(bean2.getEjbName())) {
                                        newExpandedElements.add(ob);
                                    }
                                }
                                if (ob instanceof MessageDrivenBean && expandedElements[i] instanceof MessageDrivenBean) {
                                    bean = (MessageDrivenBean)ob;
                                    bean2 = (MessageDrivenBean)expandedElements[i];
                                    if (bean.getEjbName().equals(bean2.getEjbName())) {
                                        newExpandedElements.add(ob);
                                    }
                                }
                                if (!(ob instanceof EntityBean) || !(expandedElements[i] instanceof EntityBean)) continue;
                                bean = (EntityBean)ob;
                                bean2 = (EntityBean)expandedElements[i];
                                if (!bean.getEjbName().equals(bean2.getEjbName())) continue;
                                newExpandedElements.add(ob);
                            }
                        }
                        ++i;
                    }
                    ((TreeViewer)JEE5ContentProvider.this.viewer).setExpandedElements(newExpandedElements.toArray());
                }
            };
            Display.getDefault().asyncExec(refreshThread);
        }
        catch (Exception e) {
            JEEUIPlugin.logError("Error during refresh", e);
        }
    }

    private void getViewerElements(List result, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            result.add(item.getData());
            this.getViewerElements(result, (Widget)item);
            ++i;
        }
    }

    protected Item[] getChildren(Widget o) {
        if (o instanceof TreeItem) {
            return ((TreeItem)o).getItems();
        }
        if (o instanceof Tree) {
            return ((Tree)o).getItems();
        }
        return null;
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.projectChanged(event.getProject());
    }

    public void onRefresh(final Object element) {
        if (this.viewer instanceof AbstractTreeViewer) {
            if (Display.getCurrent() != null) {
                ((AbstractTreeViewer)this.viewer).refresh(element, true);
            } else {
                UIJob job = new UIJob("Update the Navigator Content Viewer Job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ((AbstractTreeViewer)JEE5ContentProvider.this.viewer).refresh(element, true);
                        return Status.OK_STATUS;
                    }
                };
                ISchedulingRule rule = new ISchedulingRule(){

                    public boolean contains(ISchedulingRule rule) {
                        return rule == this;
                    }

                    public boolean isConflicting(ISchedulingRule rule) {
                        return rule == this;
                    }
                };
                job.setRule(rule);
                job.schedule();
            }
        }
    }

    public void dispose() {
        groupProvidersMap.clear();
        groupContentProviders.clear();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 && event.getResource() != null && event.getResource().getType() == 4) {
            groupContentProviders.remove(event.getResource());
            groupProvidersMap.remove(event.getResource());
        }
    }
}

