/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IConditionalExpression;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ConditionalExpression
extends OperatorExpression
implements IConditionalExpression {
    public Expression condition;
    public Expression valueIfTrue;
    public Expression valueIfFalse;
    public Constant optimizedBooleanConstant;
    public Constant optimizedIfTrueConstant;
    public Constant optimizedIfFalseConstant;
    int trueInitStateIndex = -1;
    int falseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ConditionalExpression(Expression condition, Expression valueIfTrue, Expression valueIfFalse) {
        this.condition = condition;
        this.valueIfTrue = valueIfTrue;
        this.valueIfFalse = valueIfFalse;
        this.sourceStart = condition.sourceStart;
        this.sourceEnd = valueIfFalse.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo mergedInfo;
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != Constant.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != Constant.NotAConstant && !cst.booleanValue();
        int mode = flowInfo.reachMode();
        flowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo, cst == Constant.NotAConstant);
        FlowInfo trueFlowInfo = flowInfo.initsWhenTrue().copy();
        if (isConditionOptimizedFalse) {
            trueFlowInfo.setReachMode(1);
        }
        trueFlowInfo = this.valueIfTrue.analyseCode(currentScope, flowContext, trueFlowInfo);
        FlowInfo falseFlowInfo = flowInfo.initsWhenFalse().copy();
        if (isConditionOptimizedTrue) {
            falseFlowInfo.setReachMode(1);
        }
        falseFlowInfo = this.valueIfFalse.analyseCode(currentScope, flowContext, falseFlowInfo);
        if (isConditionOptimizedTrue) {
            mergedInfo = trueFlowInfo.addPotentialInitializationsFrom(falseFlowInfo);
        } else if (isConditionOptimizedFalse) {
            mergedInfo = falseFlowInfo.addPotentialInitializationsFrom(trueFlowInfo);
        } else {
            cst = this.optimizedIfTrueConstant;
            boolean isValueIfTrueOptimizedTrue = cst != null && cst != Constant.NotAConstant && cst.booleanValue();
            boolean isValueIfTrueOptimizedFalse = cst != null && cst != Constant.NotAConstant && !cst.booleanValue();
            cst = this.optimizedIfFalseConstant;
            boolean isValueIfFalseOptimizedTrue = cst != null && cst != Constant.NotAConstant && cst.booleanValue();
            boolean isValueIfFalseOptimizedFalse = cst != null && cst != Constant.NotAConstant && !cst.booleanValue();
            UnconditionalFlowInfo trueInfoWhenTrue = trueFlowInfo.initsWhenTrue().unconditionalCopy();
            UnconditionalFlowInfo falseInfoWhenTrue = falseFlowInfo.initsWhenTrue().unconditionalCopy();
            UnconditionalFlowInfo trueInfoWhenFalse = trueFlowInfo.initsWhenFalse().unconditionalInits();
            UnconditionalFlowInfo falseInfoWhenFalse = falseFlowInfo.initsWhenFalse().unconditionalInits();
            if (isValueIfTrueOptimizedFalse) {
                trueInfoWhenTrue.setReachMode(1);
            }
            if (isValueIfFalseOptimizedFalse) {
                falseInfoWhenTrue.setReachMode(1);
            }
            if (isValueIfTrueOptimizedTrue) {
                trueInfoWhenFalse.setReachMode(1);
            }
            if (isValueIfFalseOptimizedTrue) {
                falseInfoWhenFalse.setReachMode(1);
            }
            mergedInfo = FlowInfo.conditional(trueInfoWhenTrue.mergedWith(falseInfoWhenTrue), trueInfoWhenFalse.mergedWith(falseInfoWhenFalse));
        }
        mergedInfo.setReachMode(mode);
        return mergedInfo;
    }

    public int nullStatus(FlowInfo flowInfo) {
        int ifFalseNullStatus;
        Constant cst = this.condition.optimizedBooleanConstant();
        if (cst != Constant.NotAConstant) {
            if (cst.booleanValue()) {
                return this.valueIfTrue.nullStatus(flowInfo);
            }
            return this.valueIfFalse.nullStatus(flowInfo);
        }
        int ifTrueNullStatus = this.valueIfTrue.nullStatus(flowInfo);
        if (ifTrueNullStatus == (ifFalseNullStatus = this.valueIfFalse.nullStatus(flowInfo))) {
            return ifTrueNullStatus;
        }
        return 0;
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.condition.printExpression(indent, output).append(" ? ");
        this.valueIfTrue.printExpression(0, output).append(" : ");
        return this.valueIfFalse.printExpression(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        Constant falseConstant;
        Constant trueConstant;
        this.constant = Constant.NotAConstant;
        TypeBinding conditionType = this.condition.resolveTypeExpecting(scope, TypeBinding.BOOLEAN);
        TypeBinding originalValueIfTrueType = this.valueIfTrue.resolveType(scope);
        TypeBinding originalValueIfFalseType = this.valueIfFalse.resolveType(scope);
        if (conditionType == null || originalValueIfTrueType == null || originalValueIfFalseType == null) {
            return null;
        }
        TypeBinding valueIfTrueType = originalValueIfTrueType;
        TypeBinding valueIfFalseType = originalValueIfFalseType;
        Constant condConstant = this.condition.constant;
        if (condConstant != Constant.NotAConstant && (trueConstant = this.valueIfTrue.constant) != Constant.NotAConstant && (falseConstant = this.valueIfFalse.constant) != Constant.NotAConstant) {
            Constant constant = this.constant = condConstant.booleanValue() ? trueConstant : falseConstant;
        }
        if (valueIfTrueType == valueIfFalseType) {
            if (valueIfTrueType == TypeBinding.BOOLEAN) {
                this.optimizedIfTrueConstant = this.valueIfTrue.optimizedBooleanConstant();
                this.optimizedIfFalseConstant = this.valueIfFalse.optimizedBooleanConstant();
                if (this.optimizedIfTrueConstant != Constant.NotAConstant && this.optimizedIfFalseConstant != Constant.NotAConstant && this.optimizedIfTrueConstant.booleanValue() == this.optimizedIfFalseConstant.booleanValue()) {
                    this.optimizedBooleanConstant = this.optimizedIfTrueConstant;
                } else {
                    condConstant = this.condition.optimizedBooleanConstant();
                    if (condConstant != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = condConstant.booleanValue() ? this.optimizedIfTrueConstant : this.optimizedIfFalseConstant;
                    }
                }
            }
            this.resolvedType = valueIfTrueType;
            return this.resolvedType;
        }
        if (valueIfTrueType.isNumericType() && valueIfFalseType.isNumericType()) {
            if ((valueIfTrueType == TypeBinding.SHORT || valueIfTrueType == TypeBinding.CHAR) && valueIfFalseType == TypeBinding.INT && this.valueIfFalse.isConstantValueOfTypeAssignableToType(valueIfFalseType, valueIfTrueType)) {
                this.resolvedType = valueIfTrueType;
                return this.resolvedType;
            }
            if ((valueIfFalseType == TypeBinding.SHORT || valueIfFalseType == TypeBinding.CHAR) && valueIfTrueType == TypeBinding.INT && this.valueIfTrue.isConstantValueOfTypeAssignableToType(valueIfTrueType, valueIfFalseType)) {
                this.resolvedType = valueIfFalseType;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 10) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 10)) {
                this.resolvedType = TypeBinding.INT;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 7) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 7)) {
                this.resolvedType = TypeBinding.LONG;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 9) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 9)) {
                this.resolvedType = TypeBinding.FLOAT;
                return this.resolvedType;
            }
            this.resolvedType = TypeBinding.DOUBLE;
            return this.resolvedType;
        }
        if (valueIfFalseType.isCompatibleWith(valueIfTrueType)) {
            this.resolvedType = valueIfTrueType != TypeBinding.NULL ? valueIfTrueType : valueIfFalseType;
            return this.resolvedType;
        }
        if (valueIfTrueType.isCompatibleWith(valueIfFalseType)) {
            this.resolvedType = valueIfFalseType != TypeBinding.NULL ? valueIfFalseType : valueIfTrueType;
            return this.resolvedType;
        }
        if (valueIfFalseType.isValidBinding() && valueIfTrueType.isValidBinding()) {
            scope.problemReporter().conditionalArgumentsIncompatibleTypes(this, valueIfTrueType, valueIfFalseType);
        }
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
            this.valueIfTrue.traverse(visitor, scope);
            this.valueIfFalse.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 24;
    }
}

