/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript;

import java.util.Iterator;
import org.eclipse.wst.jsdt.web.core.javascript.Messages;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class NodeHelper {
    protected static final char DOUBLE_QUOTE_CHAR = '\"';
    protected static final String DOUBLE_QUOTE_ENTITY = "&quot;";
    protected static final char SINGLE_QUOTE_CHAR = '\'';
    protected static final String SINGLE_QUOTE_ENTITY = "&#039;";
    protected IStructuredDocumentRegion region;

    public static boolean isInArray(String[] StringArray, String text) {
        if (StringArray == null || text == null) {
            return false;
        }
        int i = 0;
        while (i < StringArray.length) {
            if (StringArray[i].equalsIgnoreCase(text.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int lastIndex = string.length() - 1;
        char firstChar = string.charAt(0);
        char lastChar = string.charAt(lastIndex);
        return firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
    }

    public NodeHelper(IStructuredDocumentRegion region) {
        this.region = region;
    }

    public boolean attrEquals(String attribute, String value) {
        String attValue = this.getAttributeValue(attribute);
        if (attValue == null) {
            return false;
        }
        return attValue.equalsIgnoreCase(value);
    }

    public String AttrToString() {
        if (this.region == null) {
            return null;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        String StructuredValue = String.valueOf(Messages.NodeHelper00) + this.getTagName() + Messages.NodeHelper01;
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            StructuredValue = String.valueOf(StructuredValue) + "\t\t" + this.region.getText(r);
            if (regionIterator.hasNext()) {
                regionIterator.next();
            }
            if (r.getType() != "XML_TAG_ATTRIBUTE_EQUALS") continue;
            if (regionIterator.hasNext()) {
                r = (ITextRegion)regionIterator.next();
            }
            if (r.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            StructuredValue = String.valueOf(StructuredValue) + "\t\t" + this.stripEndQuotes(this.region.getText(r)) + "\n";
        }
        return StructuredValue;
    }

    public boolean containsAttribute(String[] name) {
        if (name == null) {
            return false;
        }
        if (this.region == null) {
            return false;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext()) {
            String tagname;
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME" || !NodeHelper.isInArray(name, tagname = this.region.getText(r).trim())) continue;
            return true;
        }
        return false;
    }

    public String getAttributeValue(String name) {
        if (this.region == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext()) {
            String tagname;
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME" || !(tagname = this.region.getText(r).trim()).equalsIgnoreCase(name)) continue;
            if (regionIterator.hasNext()) {
                regionIterator.next();
            }
            if (regionIterator.hasNext()) {
                r = (ITextRegion)regionIterator.next();
            }
            if (r.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            return this.stripEndQuotes(this.region.getText(r));
        }
        return null;
    }

    public String getElementAsFlatString() {
        if (this.region == null) {
            return null;
        }
        String fullRegionText = this.region.getFullText();
        if (fullRegionText == null) {
            return null;
        }
        return fullRegionText.replaceAll("[^a-zA-Z0-9]", "");
    }

    public String getTagName() {
        if (this.region == null) {
            return null;
        }
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            if (r.getType() != "XML_TAG_NAME") continue;
            return this.region.getText(r);
        }
        return null;
    }

    public boolean isEndTag() {
        if (this.region == null) {
            return false;
        }
        return "XML_END_TAG_OPEN".equals(this.region.getFirstRegion().getType());
    }

    public boolean isSelfClosingTag() {
        if (this.region == null) {
            return false;
        }
        return "XML_EMPTY_TAG_CLOSE".equals(this.region.getLastRegion().getType());
    }

    public boolean nameEquals(String name) {
        if (this.region == null || name == null) {
            return false;
        }
        return name.equalsIgnoreCase(this.getTagName());
    }

    public void setDocumentRegion(IStructuredDocumentRegion newRegion) {
        if (newRegion == null) {
            throw new IllegalArgumentException();
        }
        this.region = newRegion;
    }

    public String stripEndQuotes(String text) {
        if (text == null) {
            return null;
        }
        if (NodeHelper.isQuoted(text)) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public String toString() {
        ITextRegionList t = this.region.getRegions();
        Iterator regionIterator = t.iterator();
        String nodeText = new String();
        while (regionIterator.hasNext()) {
            ITextRegion r = (ITextRegion)regionIterator.next();
            String nodeType = r.getType();
            nodeText = String.valueOf(nodeText) + Messages.NodeHelper11 + nodeType + Messages.NodeHelper12 + this.region.getText(r) + "\n";
        }
        return nodeText;
    }
}

