/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.core.model;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptLoadBreakpoint;

public class JavaScriptDebugModel {
    public static final String MODEL_ID = "org.eclipse.wst.jsdt.debug.model";

    public static IJavaScriptLineBreakpoint createLineBreakpoint(IResource resource, int linenumber, int charstart, int charend, Map attributes, boolean register) throws DebugException {
        return new JavaScriptLineBreakpoint(resource, linenumber, charstart, charend, attributes, register);
    }

    public static IJavaScriptLoadBreakpoint createScriptLoadBreakpoint(IResource resource, int charstart, int charend, Map attributes, boolean register) throws DebugException {
        return new JavaScriptLoadBreakpoint(resource, charstart, charend, attributes, register);
    }

    public static IJavaScriptFunctionBreakpoint createFunctionBreakpoint(IResource resource, String name, String signature, int charstart, int charend, Map attributes, boolean register) throws DebugException {
        return new JavaScriptFunctionBreakpoint(resource, name, signature, charstart, charend, attributes, register);
    }

    public static String numberToString(Number n) {
        if (n == null) {
            return "NaN";
        }
        double d = n.doubleValue();
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        String number = Double.toString(d);
        if (number.endsWith(".0")) {
            number = number.substring(0, number.length() - 2);
        }
        return number;
    }
}

