/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertIterableLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.ILinkedFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class ConvertLoopFix
extends LinkedFix {
    public static IFix createCleanUp(JavaScriptUnit compilationUnit, boolean convertForLoops, boolean convertIterableForLoops, boolean makeFinal) {
        if (!JavaModelUtil.is50OrHigher(compilationUnit.getJavaElement().getJavaScriptProject())) {
            return null;
        }
        if (!convertForLoops && !convertIterableForLoops) {
            return null;
        }
        ArrayList operations = new ArrayList();
        ControlStatementFinder finder = new ControlStatementFinder(convertForLoops, convertIterableForLoops, makeFinal, operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] ops = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new ConvertLoopFix(FixMessages.ControlStatementsFix_change_name, compilationUnit, ops);
    }

    public static IFix createConvertIterableLoopToEnhancedFix(JavaScriptUnit compilationUnit, ForStatement loop) {
        ConvertIterableLoopOperation loopConverter = new ConvertIterableLoopOperation(loop);
        IStatus status = loopConverter.satisfiesPreconditions();
        if (status.getSeverity() == 4) {
            return null;
        }
        ConvertLoopFix result = new ConvertLoopFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new ILinkedFixRewriteOperation[]{loopConverter});
        result.setStatus(status);
        return result;
    }

    protected ConvertLoopFix(String name, JavaScriptUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class ControlStatementFinder
    extends GenericVisitor {
        private final Hashtable fUsedNames;
        private final boolean fFindForLoopsToConvert;
        private final boolean fConvertIterableForLoops;

        public ControlStatementFinder(boolean findForLoopsToConvert, boolean convertIterableForLoops, boolean makeFinal, List resultingCollection) {
            this.fFindForLoopsToConvert = findForLoopsToConvert;
            this.fConvertIterableForLoops = convertIterableForLoops;
            this.fUsedNames = new Hashtable();
        }

        public void endVisit(ForStatement node) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                this.fUsedNames.remove(node);
            }
            super.endVisit(node);
        }
    }
}

