/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.jpt.db.DatabaseObject;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DTPDatabaseObjectWrapper
implements DTPDatabaseObject {
    private final DTPDatabaseObject parent;
    private final ICatalogObjectListener catalogObjectListener;
    final ICatalogObject catalogObject;

    DTPDatabaseObjectWrapper(DTPDatabaseObject parent, Object dtpObject) {
        this.parent = parent;
        if (this.getConnectionProfile().isConnected()) {
            this.catalogObject = (ICatalogObject)dtpObject;
            this.catalogObjectListener = this.buildCatalogObjectListener();
            if (this.getConnectionProfile().hasAnyListeners()) {
                this.startListening();
            }
        } else {
            this.catalogObject = null;
            this.catalogObjectListener = null;
        }
    }

    private ICatalogObjectListener buildCatalogObjectListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject dmElement, int eventType) {
                if (dmElement == DTPDatabaseObjectWrapper.this.catalogObject) {
                    DTPDatabaseObjectWrapper.this.catalogObjectChanged();
                }
            }
        };
    }

    void catalogObjectChanged() {
        this.clear();
    }

    abstract void clear();

    DTPDatabaseObject getParent() {
        return this.parent;
    }

    @Override
    public DTPConnectionProfileWrapper getConnectionProfile() {
        return this.parent.getConnectionProfile();
    }

    @Override
    public DTPDatabaseWrapper getDatabase() {
        return this.getConnectionProfile().getDatabase();
    }

    <T extends DatabaseObject> T selectDatabaseObjectForIdentifier(Iterable<T> databaseObjects, String identifier) {
        return this.selectDatabaseObjectNamed(databaseObjects, this.convertIdentifierToName(identifier));
    }

    private String convertIdentifierToName(String identifier) {
        return this.getConnectionProfile().convertIdentifierToName(identifier);
    }

    <T extends DatabaseObject> T selectDatabaseObjectNamed(Iterable<T> databaseObjects, String name) {
        for (DatabaseObject dbObject : databaseObjects) {
            if (!dbObject.getName().equals(name)) continue;
            return (T)dbObject;
        }
        return null;
    }

    @Override
    public String getIdentifier(String defaultName) {
        return this.getDatabase().convertNameToIdentifier(this.getName(), defaultName);
    }

    @Override
    public String getIdentifier() {
        return this.convertNameToIdentifier(this.getName());
    }

    String convertNameToIdentifier(String name) {
        return this.getConnectionProfile().convertNameToIdentifier(name);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    void startListening() {
        this.checkListener();
        RefreshManager.getInstance().AddListener(this.catalogObject, this.catalogObjectListener);
    }

    void stopListening() {
        this.checkListener();
        RefreshManager.getInstance().removeListener(this.catalogObject, this.catalogObjectListener);
    }

    private void checkListener() {
        if (this.catalogObjectListener == null) {
            throw new IllegalStateException("the catalog listener is null");
        }
    }
}

