/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPluginIcons;
import org.eclipse.jst.j2ee.internal.wizard.AvailableUtilJarsAndWebLibProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class EARComponentImportOptionsPage
extends DataModelWizardPage {
    private Button deselectAllButton;
    private Button selectAllButton;
    private Label moduleProjectLocationLabel;
    protected Button browseButton;
    protected Button useAlternateRootBtn;
    protected Text systemDefaultText;
    protected ArchiveWrapper aWrapper;
    public CheckboxTableViewer availableJARsViewer;
    public boolean utilJarSelectionChanged = false;

    public EARComponentImportOptionsPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(J2EEUIMessages.getResourceString("40"));
        this.setDescription(J2EEUIMessages.getResourceString("39"));
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor(J2EEUIPluginIcons.EAR_IMPORT_WIZARD_BANNER));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setInfopopID("org.eclipse.jst.j2ee.ui.EAR_IMPORT_EAR_WIZARD_PAGE2");
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createJARsComposite(composite);
        this.createProjectRootComposite(composite);
        return composite;
    }

    protected void updateButtonEnablements() {
        this.utilJarSelectionChanged = true;
    }

    protected void createAvailableJarsList(Composite listGroup) {
        this.availableJARsViewer = CheckboxTableViewer.newCheckList((Composite)listGroup, (int)2816);
        GridData gData = new GridData(1808);
        gData.widthHint = 200;
        gData.heightHint = 80;
        this.availableJARsViewer.getControl().setLayoutData((Object)gData);
        AvailableUtilJarsAndWebLibProvider availableUtilJARsProvider = new AvailableUtilJarsAndWebLibProvider();
        this.availableJARsViewer.setContentProvider((IContentProvider)availableUtilJARsProvider);
        this.availableJARsViewer.setLabelProvider((IBaseLabelProvider)availableUtilJARsProvider);
        this.availableJARsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EARComponentImportOptionsPage.this.availableJARCheckStateChanged(event);
            }
        });
        this.availableJARsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EARComponentImportOptionsPage.this.updateButtonEnablements();
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.availableJARsViewer.getTable().setLayout((Layout)tableLayout);
        this.availableJARsViewer.getTable().setHeaderVisible(false);
        this.availableJARsViewer.getTable().setLinesVisible(false);
        this.model.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if (event.getPropertyName().equals("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST")) {
                    EARComponentImportOptionsPage.this.availableJARsViewer.setCheckedElements(((List)EARComponentImportOptionsPage.this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST")).toArray());
                }
            }
        });
    }

    private void handleDeselectAllButtonPressed() {
        ArrayList emptySelection = new ArrayList(2);
        this.model.setProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST", emptySelection);
        this.validatePage();
    }

    private void handleSelectAllButtonPressed() {
        ArrayList<Object> allSelection = new ArrayList<Object>(2);
        Object selection = null;
        int i = 0;
        while ((selection = this.availableJARsViewer.getElementAt(i)) != null) {
            allSelection.add(selection);
            ++i;
        }
        this.model.setProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST", allSelection);
        this.validatePage();
    }

    protected void handleBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.browseButton.getShell());
        dialog.setMessage(J2EEUIMessages.getResourceString("57"));
        String dirName = this.getBrowseStartLocation();
        if (!this.isNullOrEmpty(dirName) && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.systemDefaultText.setText(selectedDirectory);
        }
    }

    protected String getBrowseStartLocation() {
        String text = this.systemDefaultText.getText();
        return text;
    }

    protected void createButtonsGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1808));
        this.selectAllButton = new Button(buttonGroup, 8);
        this.selectAllButton.setText(J2EEUIMessages.getResourceString("47"));
        GridData gd = new GridData(272);
        gd.widthHint = 160;
        this.selectAllButton.setLayoutData((Object)gd);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EARComponentImportOptionsPage.this.handleSelectAllButtonPressed();
            }
        });
        this.deselectAllButton = new Button(buttonGroup, 8);
        this.deselectAllButton.setText(J2EEUIMessages.getResourceString("48"));
        gd = new GridData(272);
        gd.widthHint = 160;
        this.deselectAllButton.setLayoutData((Object)gd);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EARComponentImportOptionsPage.this.handleDeselectAllButtonPressed();
            }
        });
    }

    protected void createJARsComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(J2EEUIMessages.getResourceString("49"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        Label description = new Label((Composite)group, 0);
        description.setText(J2EEUIMessages.getResourceString("50"));
        GridData gd2 = new GridData(256);
        gd2.horizontalSpan = 3;
        description.setLayoutData((Object)gd2);
        this.createAvailableJarsList((Composite)group);
        this.createButtonsGroup((Composite)group);
    }

    protected void createProjectRootComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(J2EEUIMessages.getResourceString("53"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label description = new Label((Composite)group, 0);
        description.setText(J2EEUIMessages.getResourceString("54"));
        GridData gd2 = new GridData(256);
        gd2.horizontalSpan = 3;
        description.setLayoutData((Object)gd2);
        this.moduleProjectLocationLabel = new Label((Composite)group, 0);
        this.moduleProjectLocationLabel.setText(J2EEUIMessages.getResourceString("55"));
        this.moduleProjectLocationLabel.setLayoutData((Object)new GridData(256));
        this.systemDefaultText = new Text((Composite)group, 2120);
        GridData gd = new GridData(768);
        this.systemDefaultText.setLayoutData((Object)gd);
        this.synchHelper.synchText(this.systemDefaultText, "IEnterpriseApplicationImportDataModelProperties.NESTED_MODULE_ROOT", null);
        this.browseButton = new Button((Composite)group, 8);
        this.browseButton.setText(J2EEUIMessages.getResourceString("93"));
        gd = new GridData(128);
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EARComponentImportOptionsPage.this.handleBrowseButtonPressed();
            }
        });
    }

    private void refreshEARFileIfNecessary() {
        if (this.isEARFileChanged()) {
            this.aWrapper = (ArchiveWrapper)this.model.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
            this.refresh();
        }
    }

    protected void setJARsCompositeEnabled(boolean enabled) {
        this.availableJARsViewer.getTable().setEnabled(enabled);
        this.availableJARsViewer.setAllChecked(false);
        this.availableJARsViewer.setAllGrayed(!enabled);
        this.selectAllButton.setEnabled(enabled);
        this.deselectAllButton.setEnabled(enabled);
    }

    private void refresh() {
        this.availableJARsViewer.setInput((Object)this.aWrapper);
    }

    public boolean isEARFileChanged() {
        return this.aWrapper != this.model.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
    }

    protected void enter() {
        super.enter();
        this.refreshEARFileIfNecessary();
    }

    public void availableJARCheckStateChanged(CheckStateChangedEvent event) {
        this.model.setProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST", (Object)this.getJARsForProjects());
        this.validatePage();
    }

    public List getJARsForProjects() {
        this.refreshEARFileIfNecessary();
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.availableJARsViewer.getCheckedElements()));
        return result;
    }

    protected boolean isNullOrEmpty(String aString) {
        return aString == null || aString.length() == 0;
    }

    protected String[] getValidationPropertyNames() {
        return new String[0];
    }

    protected void restoreWidgetValues() {
    }

    public void storeDefaultSettings() {
    }
}

