/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.ui.refactoring.LanguageElementNode;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class CompilationUnitChangeNode
extends TextEditChangeNode {
    static final TextEditChangeNode.ChildNode[] EMPTY_CHILDREN = new TextEditChangeNode.ChildNode[0];
    static /* synthetic */ Class class$0;

    public CompilationUnitChangeNode(TextEditBasedChange change) {
        super(change);
    }

    protected TextEditChangeNode.ChildNode[] createChildNodes() {
        IJavaScriptUnit cunit;
        TextEditBasedChange change = this.getTextEditBasedChange();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaScriptUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cunit = (IJavaScriptUnit)change.getAdapter((Class)clazz)) != null) {
            ArrayList<TextEditChangeNode.ChildNode> children = new ArrayList<TextEditChangeNode.ChildNode>(5);
            HashMap map = new HashMap(20);
            TextEditBasedChangeGroup[] changes = this.getSortedChangeGroups(change);
            int i = 0;
            while (i < changes.length) {
                TextEditBasedChangeGroup tec = changes[i];
                try {
                    IJavaScriptElement element = this.getModifiedJavaElement(tec, cunit);
                    if (element.equals(cunit)) {
                        children.add(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
                    } else {
                        JavaLanguageNode pjce = this.getChangeElement(map, element, children, this);
                        pjce.addChild(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode.ChildNode)pjce, (TextEditBasedChangeGroup)tec));
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    children.add(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
                }
                ++i;
            }
            return children.toArray(new TextEditChangeNode.ChildNode[children.size()]);
        }
        return EMPTY_CHILDREN;
    }

    private TextEditBasedChangeGroup[] getSortedChangeGroups(TextEditBasedChange change) {
        TextEditBasedChangeGroup[] edits = change.getChangeGroups();
        ArrayList<TextEditBasedChangeGroup> result = new ArrayList<TextEditBasedChangeGroup>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].getTextEditGroup().isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextEditBasedChangeGroup[result.size()]);
    }

    private IJavaScriptElement getModifiedJavaElement(TextEditBasedChangeGroup edit, IJavaScriptUnit cunit) throws JavaScriptModelException {
        IRegion range = edit.getRegion();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return cunit;
        }
        IJavaScriptElement result = cunit.getElementAt(range.getOffset());
        if (result == null) {
            return cunit;
        }
        try {
            while (true) {
                ISourceReference ref = (ISourceReference)result;
                Region sRange = new Region(ref.getSourceRange().getOffset(), ref.getSourceRange().getLength());
                if (result.getElementType() != 5 && result.getParent() != null && !this.coveredBy(edit, (IRegion)sRange)) {
                    result = result.getParent();
                    continue;
                }
                break;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    private JavaLanguageNode getChangeElement(Map map, IJavaScriptElement element, List children, TextEditChangeNode cunitChange) {
        JavaLanguageNode result = (JavaLanguageNode)((Object)map.get(element));
        if (result != null) {
            return result;
        }
        IJavaScriptElement parent = element.getParent();
        if (parent instanceof IJavaScriptUnit) {
            result = new JavaLanguageNode(cunitChange, element);
            children.add(result);
            map.put(element, result);
        } else {
            JavaLanguageNode parentChange = this.getChangeElement(map, parent, children, cunitChange);
            result = new JavaLanguageNode((TextEditChangeNode.ChildNode)parentChange, element);
            parentChange.addChild((TextEditChangeNode.ChildNode)result);
            map.put(element, result);
        }
        return result;
    }

    private boolean coveredBy(TextEditBasedChangeGroup group, IRegion sourceRegion) {
        int sLength = sourceRegion.getLength();
        if (sLength == 0) {
            return false;
        }
        int sOffset = sourceRegion.getOffset();
        int sEnd = sOffset + sLength - 1;
        TextEdit[] edits = group.getTextEdits();
        int i = 0;
        while (i < edits.length) {
            TextEdit edit = edits[i];
            if (edit.isDeleted()) {
                return false;
            }
            int rOffset = edit.getOffset();
            int rLength = edit.getLength();
            int rEnd = rOffset + rLength - 1;
            if (rLength == 0 ? sOffset >= rOffset || rOffset > sEnd : sOffset > rOffset || rEnd > sEnd) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class JavaLanguageNode
    extends LanguageElementNode {
        private IJavaScriptElement fJavaElement;
        private static JavaElementImageProvider fgImageProvider = new JavaElementImageProvider();

        public JavaLanguageNode(TextEditChangeNode parent, IJavaScriptElement element) {
            super(parent);
            this.fJavaElement = element;
            Assert.isNotNull((Object)this.fJavaElement);
        }

        public JavaLanguageNode(TextEditChangeNode.ChildNode parent, IJavaScriptElement element) {
            super(parent);
            this.fJavaElement = element;
            Assert.isNotNull((Object)this.fJavaElement);
        }

        public String getText() {
            return JavaScriptElementLabels.getElementLabel(this.fJavaElement, JavaScriptElementLabels.ALL_DEFAULT);
        }

        public ImageDescriptor getImageDescriptor() {
            return fgImageProvider.getJavaImageDescriptor(this.fJavaElement, 3);
        }

        public IRegion getTextRange() throws CoreException {
            ISourceRange range = ((ISourceReference)this.fJavaElement).getSourceRange();
            return new Region(range.getOffset(), range.getLength());
        }
    }

    private static class OffsetComparator
    implements Comparator {
        private OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextEditBasedChangeGroup c1 = (TextEditBasedChangeGroup)o1;
            TextEditBasedChangeGroup c2 = (TextEditBasedChangeGroup)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditBasedChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }
}

