/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public final class ExtractSupertypeProcessor
extends PullUpRefactoringProcessor {
    private static final String ATTRIBUTE_EXTRACT = "extract";
    private static final String ATTRIBUTE_TYPES = "types";
    private static final GroupCategorySet SET_EXTRACT_SUPERTYPE = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.extractSupertype", RefactoringCoreMessages.ExtractSupertypeProcessor_category_name, RefactoringCoreMessages.ExtractSupertypeProcessor_category_description));
    private final Map fLayerChanges = new HashMap();
    private IType[] fPossibleCandidates = new IType[0];
    private String fSuperSource;
    private String fTypeName = "";
    private IType[] fTypesToExtract = new IType[0];

    public ExtractSupertypeProcessor(IMember[] members, CodeGenerationSettings settings) {
        super(members, settings, true);
        IType declaring;
        if (members != null && (declaring = this.getDeclaringType()) != null) {
            this.fTypesToExtract = new IType[]{declaring};
        }
    }

    protected final RefactoringStatus checkDeclaringSuperTypes(IProgressMonitor monitor) throws JavaScriptModelException {
        return new RefactoringStatus();
    }

    protected CompilationUnitRewrite getCompilationUnitRewrite(Map rewrites, IJavaScriptUnit unit) {
        Assert.isNotNull((Object)rewrites);
        Assert.isNotNull((Object)unit);
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(this.fOwner, unit);
            rewrite.rememberContent();
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    public RefactoringStatus checkExtractedCompilationUnit() {
        RefactoringStatus status = new RefactoringStatus();
        IJavaScriptUnit cu = this.getDeclaringType().getJavaScriptUnit();
        if (this.fTypeName == null || "".equals(this.fTypeName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        status.merge(Checks.checkTypeName(this.fTypeName));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(Checks.checkCompilationUnitName(JavaModelUtil.getRenamedCUName(cu, this.fTypeName)));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(Checks.checkCompilationUnitNewName(cu, this.fTypeName));
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        block3: {
            RefactoringStatus refactoringStatus;
            RefactoringStatus status = new RefactoringStatus();
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_checking);
                status.merge(this.checkExtractedCompilationUnit());
                if (!status.hasFatalError()) break block3;
                refactoringStatus = status;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1), context);
        Object var4_7 = null;
        monitor.done();
        return refactoringStatus;
    }

    public IType computeExtractedType(String name) {
        if (name != null && !name.equals("")) {
            IType declaring = this.getDeclaringType();
            try {
                IJavaScriptUnit[] units = declaring.getPackageFragment().getJavaScriptUnits(this.fOwner);
                String newName = JavaModelUtil.getRenamedCUName(declaring.getJavaScriptUnit(), name);
                IJavaScriptUnit result = null;
                int index = 0;
                while (index < units.length) {
                    if (units[index].getElementName().equals(newName)) {
                        result = units[index];
                    }
                    ++index;
                }
                if (result != null) {
                    IType type = result.getType(name);
                    this.setDestinationType(type);
                    return type;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
        }
        return null;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IType declaring = this.getDeclaringType();
            IJavaScriptProject javaProject = declaring.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (declaring.isLocal() || declaring.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_descriptor_description_short, this.fTypeName);
            String header = Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_descriptor_description, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fDestinationType, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fCachedDeclaringType, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            IType[] types = this.getTypesToExtract();
            String[] settings = new String[types.length];
            int index = 0;
            while (index < settings.length) {
                settings[index] = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)types[index], JavaScriptElementLabels.ALL_FULLY_QUALIFIED);
                ++index;
            }
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractSupertypeProcessor_subtypes_pattern, settings));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_refactored_element_pattern, JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fDestinationType, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
            settings = new String[this.fMembersToMove.length];
            index = 0;
            while (index < settings.length) {
                settings[index] = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fMembersToMove[index], JavaScriptElementLabels.ALL_FULLY_QUALIFIED);
                ++index;
            }
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractInterfaceProcessor_extracted_members_pattern, settings));
            this.addSuperTypeSettings(comment, true);
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.extract.superclass", project, description, comment.asString(), arguments, flags);
            arguments.put("name", this.fTypeName);
            arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.getDeclaringType()));
            arguments.put("replace", Boolean.valueOf(this.fReplace).toString());
            arguments.put("instanceof", Boolean.valueOf(this.fInstanceOf).toString());
            arguments.put("stubs", Boolean.valueOf(this.fCreateMethodStubs).toString());
            arguments.put(ATTRIBUTE_EXTRACT, new Integer(this.fMembersToMove.length).toString());
            int offset = 0;
            while (offset < this.fMembersToMove.length) {
                arguments.put("element" + (offset + 1), descriptor.elementToHandle((IJavaScriptElement)this.fMembersToMove[offset]));
                ++offset;
            }
            arguments.put("delete", new Integer(this.fDeletedMethods.length).toString());
            offset = 0;
            while (offset < this.fDeletedMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + 1), descriptor.elementToHandle((IJavaScriptElement)this.fDeletedMethods[offset]));
                ++offset;
            }
            arguments.put("abstract", new Integer(this.fAbstractMethods.length).toString());
            offset = 0;
            while (offset < this.fAbstractMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + this.fDeletedMethods.length + 1), descriptor.elementToHandle((IJavaScriptElement)this.fAbstractMethods[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_TYPES, new Integer(this.fTypesToExtract.length).toString());
            offset = 0;
            while (offset < this.fTypesToExtract.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + this.fDeletedMethods.length + this.fAbstractMethods.length + 1), descriptor.elementToHandle((IJavaScriptElement)this.fTypesToExtract[offset]));
                ++offset;
            }
            DynamicValidationRefactoringChange change = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.ExtractSupertypeProcessor_extract_supertype, (Change[])this.fChangeManager.getAllChanges());
            IFile file = ResourceUtil.getFile(declaring.getJavaScriptUnit());
            if (this.fSuperSource != null && this.fSuperSource.length() > 0) {
                change.add(new CreateCompilationUnitChange(declaring.getPackageFragment().getJavaScriptUnit(JavaModelUtil.getRenamedCUName(declaring.getJavaScriptUnit(), this.fTypeName)), this.fSuperSource, file.getCharset(false)));
            }
            dynamicValidationRefactoringChange = change;
            Object var15_19 = null;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            monitor.done();
            this.clearCaches();
            throw throwable;
        }
        monitor.done();
        this.clearCaches();
        return dynamicValidationRefactoringChange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final RefactoringStatus createExtractedSuperType(IType superType, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)monitor);
        this.fSuperSource = null;
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 20);
            IType declaring = this.getDeclaringType();
            CompilationUnitRewrite declaringRewrite = new CompilationUnitRewrite(this.fOwner, declaring.getJavaScriptUnit());
            AbstractTypeDeclaration declaringDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(declaring, declaringRewrite.getRoot());
            if (declaringDeclaration != null) {
                String name = JavaModelUtil.getRenamedCUName(declaring.getJavaScriptUnit(), this.fTypeName);
                IJavaScriptUnit original = declaring.getPackageFragment().getJavaScriptUnit(name);
                IJavaScriptUnit copy = this.getSharedWorkingCopy(original.getPrimary(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                this.fSuperSource = this.createSuperTypeSource(copy, superType, declaringDeclaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (this.fSuperSource != null) {
                    copy.getBuffer().setContents(this.fSuperSource);
                    JavaModelUtil.reconcile(copy);
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        monitor.done();
        return status;
    }

    protected final void createModifiedSubType(IJavaScriptUnit unit, JavaScriptUnit root, IType extractedType, ITypeBinding extractedBinding, AbstractTypeDeclaration subDeclaration, RefactoringStatus status) {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)subDeclaration);
        Assert.isNotNull((Object)extractedType);
        try {
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fOwner, unit, root);
            this.createTypeSignature(rewrite, subDeclaration, extractedType, extractedBinding, (IProgressMonitor)new NullProgressMonitor());
            Document document = new Document(unit.getBuffer().getContents());
            CompilationUnitChange change = rewrite.createChange();
            if (change != null) {
                this.fLayerChanges.put(unit.getPrimary(), change);
                TextEdit edit = change.getEdit();
                if (edit != null) {
                    TextEditCopier copier = new TextEditCopier(edit);
                    TextEdit copy = copier.perform();
                    copy.apply((IDocument)document, 0);
                }
            }
            IJavaScriptUnit copy = this.getSharedWorkingCopy(unit, (IProgressMonitor)new NullProgressMonitor());
            copy.getBuffer().setContents(document.get());
            JavaModelUtil.reconcile(copy);
        }
        catch (CoreException exception) {
            JavaScriptPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
        catch (MalformedTreeException exception) {
            JavaScriptPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
        catch (BadLocationException exception) {
            JavaScriptPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
    }

    protected final void createNecessaryConstructors(CompilationUnitRewrite targetRewrite, IType superType, AbstractTypeDeclaration targetDeclaration, RefactoringStatus status) {
        ITypeBinding binding;
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)targetDeclaration);
        if (superType != null && (binding = targetDeclaration.resolveBinding()) != null && binding.isClass()) {
            IFunctionBinding[] bindings = StubUtility2.getVisibleConstructors(binding, true, true);
            int deprecationCount = 0;
            int i = 0;
            while (i < bindings.length) {
                if (bindings[i].isDeprecated()) {
                    ++deprecationCount;
                }
                ++i;
            }
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            if (rewrite != null) {
                boolean createDeprecated = deprecationCount == bindings.length;
                int i2 = 0;
                while (i2 < bindings.length) {
                    IFunctionBinding curr = bindings[i2];
                    if (!curr.isDeprecated() || createDeprecated) {
                        try {
                            FunctionDeclaration stub = StubUtility2.createConstructorStub(targetRewrite.getCu(), targetRewrite.getASTRewrite(), targetRewrite.getImportRewrite(), curr, binding.getName(), 1, false, false, this.fSettings);
                            if (stub != null) {
                                rewrite.insertLast((ASTNode)stub, null);
                            }
                        }
                        catch (CoreException exception) {
                            JavaScriptPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                        }
                    }
                    ++i2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String createSuperTypeSource(IJavaScriptUnit extractedWorkingCopy, IType superType, AbstractTypeDeclaration declaringDeclaration, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)extractedWorkingCopy);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        String source = null;
        try {
            String imports;
            ITypeBinding superBinding;
            monitor.beginTask("", 2);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
            IType declaring = this.getDeclaringType();
            String delimiter = StubUtility.getLineDelimiterUsed(extractedWorkingCopy.getJavaScriptProject());
            String typeComment = null;
            String fileComment = null;
            if (this.fSettings.createComments) {
                typeComment = CodeGeneration.getTypeComment(extractedWorkingCopy, this.fTypeName, delimiter);
                fileComment = CodeGeneration.getFileComment(extractedWorkingCopy, delimiter);
            }
            StringBuffer buffer = new StringBuffer(64);
            ITypeBinding binding = declaringDeclaration.resolveBinding();
            if (binding != null && (superBinding = binding.getSuperclass()) != null) {
                this.fTypeBindings.add(superBinding);
            }
            if ((imports = this.createTypeImports(extractedWorkingCopy, monitor)) != null && !"".equals(imports)) {
                buffer.append(imports);
            }
            this.createTypeDeclaration(extractedWorkingCopy, superType, declaringDeclaration, typeComment, buffer, status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            source = this.createTypeTemplate(extractedWorkingCopy, "", fileComment, "", buffer.toString());
            if (source == null) {
                if (!declaring.getPackageFragment().isDefaultPackage()) {
                    if (imports.length() > 0) {
                        buffer.insert(0, imports);
                    }
                    buffer.insert(0, "package " + declaring.getPackageFragment().getElementName() + ";");
                }
                source = buffer.toString();
            }
            Document document = new Document(source);
            TextEdit edit = CodeFormatterUtil.format2(8, source, 0, delimiter, extractedWorkingCopy.getJavaScriptProject().getOptions(true));
            if (edit != null) {
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (MalformedTreeException exception) {
                    JavaScriptPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                }
                catch (BadLocationException exception) {
                    JavaScriptPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                }
                source = document.get();
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var17_20 = null;
        }
        monitor.done();
        return source;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createTypeDeclaration(IJavaScriptUnit extractedWorkingCopy, IType superType, AbstractTypeDeclaration declaringDeclaration, String comment, StringBuffer buffer, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)extractedWorkingCopy);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)buffer);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
            IJavaScriptProject project = extractedWorkingCopy.getJavaScriptProject();
            String delimiter = StubUtility.getLineDelimiterUsed(project);
            if (comment != null && !"".equals(comment)) {
                buffer.append(comment);
                buffer.append(delimiter);
            }
            buffer.append("public");
            if (superType != null && Flags.isAbstract((int)superType.getFlags())) {
                buffer.append(' ');
                buffer.append("abstract ");
            }
            buffer.append(' ');
            buffer.append("class ");
            buffer.append(this.fTypeName);
            if (superType != null && !"java.lang.Object".equals(superType.getFullyQualifiedName())) {
                buffer.append(' ');
                buffer.append("extends ");
                buffer.append(superType.getElementName());
            }
            buffer.append(" {");
            buffer.append(delimiter);
            buffer.append(delimiter);
            buffer.append('}');
            String string = buffer.toString();
            extractedWorkingCopy.getBuffer().setContents(string);
            Document document = new Document(string);
            CompilationUnitRewrite targetRewrite = new CompilationUnitRewrite(this.fOwner, extractedWorkingCopy);
            AbstractTypeDeclaration targetDeclaration = (AbstractTypeDeclaration)targetRewrite.getRoot().types().get(0);
            this.createTypeSignature(targetRewrite, superType, declaringDeclaration, targetDeclaration);
            this.createNecessaryConstructors(targetRewrite, superType, targetDeclaration, status);
            TextEdit edit = targetRewrite.createChange().getEdit();
            try {
                edit.apply((IDocument)document, 2);
            }
            catch (MalformedTreeException exception) {
                JavaScriptPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            catch (BadLocationException exception) {
                JavaScriptPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            buffer.setLength(0);
            buffer.append(document.get());
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var16_19 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createTypeSignature(CompilationUnitRewrite subRewrite, AbstractTypeDeclaration declaration, IType extractedType, ITypeBinding extractedBinding, IProgressMonitor monitor) throws JavaScriptModelException {
        Assert.isNotNull((Object)subRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)extractedType);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 10);
            AST ast = subRewrite.getAST();
            Type type = null;
            if (extractedBinding != null) {
                type = subRewrite.getImportRewrite().addImport(extractedBinding, ast);
            } else {
                subRewrite.getImportRewrite().addImport(extractedType.getFullyQualifiedName('.'));
                type = ast.newSimpleType((Name)ast.newSimpleName(extractedType.getElementName()));
            }
            subRewrite.getImportRemover().registerAddedImport(extractedType.getFullyQualifiedName('.'));
            ASTRewrite rewriter = subRewrite.getASTRewrite();
            if (type != null && declaration instanceof TypeDeclaration) {
                TypeDeclaration extended = (TypeDeclaration)declaration;
                Type superClass = extended.getSuperclassType();
                if (superClass != null) {
                    rewriter.replace((ASTNode)superClass, (ASTNode)type, (TextEditGroup)subRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractSupertypeProcessor_add_supertype, SET_EXTRACT_SUPERTYPE));
                    subRewrite.getImportRemover().registerRemovedNode((ASTNode)superClass);
                } else {
                    rewriter.set((ASTNode)extended, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, (TextEditGroup)subRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractSupertypeProcessor_add_supertype, SET_EXTRACT_SUPERTYPE));
                }
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected final void createTypeSignature(CompilationUnitRewrite targetRewrite, IType superType, AbstractTypeDeclaration declaringDeclaration, AbstractTypeDeclaration targetDeclaration) {
        TypeDeclaration declaration;
        Type superclassType;
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)targetDeclaration);
        if (declaringDeclaration instanceof TypeDeclaration && (superclassType = (declaration = (TypeDeclaration)declaringDeclaration).getSuperclassType()) != null) {
            Type type = null;
            ITypeBinding binding = superclassType.resolveBinding();
            if (binding != null) {
                type = targetRewrite.getImportRewrite().addImport(binding, targetRewrite.getAST());
                targetRewrite.getImportRemover().registerAddedImports(type);
            }
            if (type != null && targetDeclaration instanceof TypeDeclaration) {
                TypeDeclaration extended = (TypeDeclaration)targetDeclaration;
                Type targetSuperType = extended.getSuperclassType();
                if (targetSuperType != null) {
                    targetRewrite.getASTRewrite().replace((ASTNode)targetSuperType, (ASTNode)type, null);
                } else {
                    targetRewrite.getASTRewrite().set((ASTNode)extended, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, null);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus createWorkingCopyLayer(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            try {
                AbstractTypeDeclaration extractDeclaration;
                monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 70);
                status.merge(super.createWorkingCopyLayer((IProgressMonitor)new SubProgressMonitor(monitor, 10)));
                IType declaring = this.getDeclaringType();
                status.merge(this.createExtractedSuperType(this.getDeclaringSuperTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 10)).getSuperclass(declaring), (IProgressMonitor)new SubProgressMonitor(monitor, 10)));
                if (status.hasFatalError()) {
                    RefactoringStatus refactoringStatus = status;
                    Object var24_6 = null;
                    monitor.done();
                    return refactoringStatus;
                }
                IType extractedType = this.computeExtractedType(this.fTypeName);
                this.setDestinationType(extractedType);
                ArrayList<IType> subTypes = new ArrayList<IType>(Arrays.asList(this.fTypesToExtract));
                if (!subTypes.contains(declaring)) {
                    subTypes.add(declaring);
                }
                HashMap<IJavaScriptUnit, ArrayList<IType>> unitToTypes = new HashMap<IJavaScriptUnit, ArrayList<IType>>(subTypes.size());
                HashSet<IJavaScriptUnit> units = new HashSet<IJavaScriptUnit>(subTypes.size());
                int index = 0;
                while (index < subTypes.size()) {
                    IType type = (IType)subTypes.get(index);
                    IJavaScriptUnit unit = type.getJavaScriptUnit();
                    units.add(unit);
                    ArrayList<IType> collection = (ArrayList<IType>)unitToTypes.get(unit);
                    if (collection == null) {
                        collection = new ArrayList<IType>(2);
                        unitToTypes.put(unit, collection);
                    }
                    collection.add(type);
                    ++index;
                }
                HashMap<IJavaScriptProject, ArrayList<IJavaScriptUnit>> projectToUnits = new HashMap<IJavaScriptProject, ArrayList<IJavaScriptUnit>>();
                Collection collection = null;
                IJavaScriptProject project = null;
                IJavaScriptUnit current = null;
                Iterator iterator = units.iterator();
                while (iterator.hasNext()) {
                    current = (IJavaScriptUnit)iterator.next();
                    project = current.getJavaScriptProject();
                    collection = (ArrayList<IJavaScriptUnit>)projectToUnits.get(project);
                    if (collection == null) {
                        collection = new ArrayList<IJavaScriptUnit>();
                        projectToUnits.put(project, (ArrayList<IJavaScriptUnit>)collection);
                    }
                    collection.add(current);
                }
                ITypeBinding[] extractBindings = new ITypeBinding[1];
                ASTParser extractParser = ASTParser.newParser((int)3);
                extractParser.setWorkingCopyOwner(this.fOwner);
                extractParser.setResolveBindings(true);
                extractParser.setProject(project);
                extractParser.setSource(extractedType.getJavaScriptUnit());
                JavaScriptUnit extractUnit = (JavaScriptUnit)extractParser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (extractUnit != null && (extractDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(extractedType, extractUnit)) != null) {
                    extractBindings[0] = extractDeclaration.resolveBinding();
                }
                ASTParser parser = ASTParser.newParser((int)3);
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
                try {
                    Set keySet = projectToUnits.keySet();
                    subMonitor.beginTask("", keySet.size());
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                    Iterator iterator2 = keySet.iterator();
                    while (iterator2.hasNext()) {
                        Object var20_26;
                        project = (IJavaScriptProject)iterator2.next();
                        collection = (Collection)projectToUnits.get(project);
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(project);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaScriptElement)project));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                        try {
                            subsubMonitor.beginTask("", collection.size());
                            subsubMonitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                            parser.createASTs(collection.toArray(new IJavaScriptUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor, unitToTypes, extractedType, extractBindings, status){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                private final /* synthetic */ Map val$unitToTypes;
                                private final /* synthetic */ IType val$extractedType;
                                private final /* synthetic */ ITypeBinding[] val$extractBindings;
                                private final /* synthetic */ RefactoringStatus val$status;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                    this.val$unitToTypes = map;
                                    this.val$extractedType = iType;
                                    this.val$extractBindings = iTypeBindingArray;
                                    this.val$status = refactoringStatus;
                                }

                                /*
                                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public final void acceptAST(IJavaScriptUnit unit, JavaScriptUnit node) {
                                    try {
                                        try {
                                            Collection types = (Collection)this.val$unitToTypes.get(unit);
                                            if (types != null) {
                                                Iterator innerIterator = types.iterator();
                                                while (innerIterator.hasNext()) {
                                                    IType currentType = (IType)innerIterator.next();
                                                    AbstractTypeDeclaration currentDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(currentType, node);
                                                    if (currentDeclaration == null) continue;
                                                    ExtractSupertypeProcessor.this.createModifiedSubType(unit, node, this.val$extractedType, this.val$extractBindings[0], currentDeclaration, this.val$status);
                                                }
                                            }
                                        }
                                        catch (CoreException exception) {
                                            JavaScriptPlugin.log(exception);
                                            this.val$status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_9 = null;
                                        this.val$subsubMonitor.worked(1);
                                        throw throwable;
                                    }
                                    {
                                        Object var7_10 = null;
                                    }
                                    this.val$subsubMonitor.worked(1);
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)subsubMonitor);
                            var20_26 = null;
                        }
                        catch (Throwable throwable) {
                            var20_26 = null;
                            subsubMonitor.done();
                            throw throwable;
                        }
                        subsubMonitor.done();
                    }
                    Object var22_30 = null;
                    subMonitor.done();
                }
                catch (Throwable throwable) {
                    Object var22_29 = null;
                    subMonitor.done();
                    throw throwable;
                }
            }
            catch (CoreException exception) {
                JavaScriptPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            Object var24_8 = null;
        }
        catch (Throwable throwable) {
            Object var24_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IType[] getCandidateTypes(RefactoringStatus status, IProgressMonitor monitor) {
        IType declaring;
        Assert.isNotNull((Object)monitor);
        if (this.fPossibleCandidates != null) {
            if (this.fPossibleCandidates.length != 0) return this.fPossibleCandidates;
        }
        if ((declaring = this.getDeclaringType()) == null) return this.fPossibleCandidates;
        try {
            try {
                monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_computing_possible_types, 10);
                IType superType = this.getDeclaringSuperTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).getSuperclass(declaring);
                if (superType != null) {
                    this.fPossibleCandidates = superType.newTypeHierarchy(this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 9, 2)).getSubclasses(superType);
                    LinkedList<IType> list = new LinkedList<IType>(Arrays.asList(this.fPossibleCandidates));
                    HashSet<String> names = new HashSet<String>();
                    Iterator iterator = list.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.fPossibleCandidates = list.toArray(new IType[list.size()]);
                        }
                        IType type = (IType)iterator.next();
                        if (type.isReadOnly() || type.isBinary() || type.isAnonymous() || !type.isClass() || names.contains(type.getFullyQualifiedName())) {
                            iterator.remove();
                            continue;
                        }
                        names.add(type.getFullyQualifiedName());
                    }
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        monitor.done();
        return this.fPossibleCandidates;
    }

    public Object[] getElements() {
        return new Object[]{this.getDeclaringType()};
    }

    public IType getExtractedType() {
        return this.getDestinationType();
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    public IType[] getTypesToExtract() {
        return this.fTypesToExtract;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            String attribute;
            IType type;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fTypeName = name;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                IJavaScriptElement element2 = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element2 == null || element2.getElementType() != 7) {
                    return ScriptableRefactoring.createInputFatalStatus(element2, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.extract.superclass");
                }
                type = null;
                IJavaScriptUnit unit = ((IType)element2).getJavaScriptUnit();
                if (unit != null && unit.exists()) {
                    try {
                        IJavaScriptUnit copy = this.getSharedWorkingCopy(unit, (IProgressMonitor)new NullProgressMonitor());
                        IJavaScriptElement[] elements = copy.findElements(element2);
                        if (elements != null && elements.length == 1 && elements[0] instanceof IType && elements[0].exists()) {
                            type = (IType)elements[0];
                        }
                    }
                    catch (JavaScriptModelException javaScriptModelException) {}
                }
                if (type == null) {
                    return ScriptableRefactoring.createInputFatalStatus(element2, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.extract.superclass");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCachedDeclaringType = type;
            String stubs = extended.getAttribute("stubs");
            if (stubs == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "stubs"));
            }
            this.fCreateMethodStubs = Boolean.valueOf(stubs);
            String instance = extended.getAttribute("instanceof");
            if (instance == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
            }
            this.fInstanceOf = Boolean.valueOf(instance);
            String replace = extended.getAttribute("replace");
            if (replace == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "replace"));
            }
            this.fReplace = Boolean.valueOf(replace);
            int extractCount = 0;
            int abstractCount = 0;
            int deleteCount = 0;
            int typeCount = 0;
            String value = extended.getAttribute("abstract");
            if (value != null && !"".equals(value)) {
                try {
                    abstractCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "abstract"));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "abstract"));
            }
            value = extended.getAttribute("delete");
            if (value != null && !"".equals(value)) {
                try {
                    deleteCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "delete"));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "delete"));
            }
            value = extended.getAttribute(ATTRIBUTE_EXTRACT);
            if (value != null && !"".equals(value)) {
                try {
                    extractCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXTRACT));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXTRACT));
            }
            value = extended.getAttribute(ATTRIBUTE_TYPES);
            if (value != null && !"".equals(value)) {
                try {
                    typeCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPES));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPES));
            }
            RefactoringStatus status = new RefactoringStatus();
            ArrayList<IJavaScriptElement> elements = new ArrayList<IJavaScriptElement>();
            int index = 0;
            while (index < extractCount) {
                attribute = "element" + (index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JDTRefactoringDescriptor.handleToElement(this.fOwner, extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.extract.superclass"));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < deleteCount) {
                attribute = "element" + (extractCount + index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JDTRefactoringDescriptor.handleToElement(this.fOwner, extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.extract.superclass"));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fDeletedMethods = elements.toArray(new IFunction[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < abstractCount) {
                attribute = "element" + (extractCount + abstractCount + index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JDTRefactoringDescriptor.handleToElement(this.fOwner, extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.extract.superclass"));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fAbstractMethods = elements.toArray(new IFunction[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < typeCount) {
                attribute = "element" + (extractCount + abstractCount + deleteCount + index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JDTRefactoringDescriptor.handleToElement(this.fOwner, extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.extract.superclass"));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fTypesToExtract = elements.toArray(new IType[elements.size()]);
            IJavaScriptProject project = null;
            if (this.fMembersToMove.length > 0) {
                project = this.fMembersToMove[0].getJavaScriptProject();
            }
            this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
            if (!status.isOK()) {
                return status;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void registerChanges(TextEditBasedChangeManager manager) throws CoreException {
        try {
            int index;
            IJavaScriptUnit[] units;
            IJavaScriptUnit extractedUnit = this.getExtractedType().getJavaScriptUnit();
            IJavaScriptUnit unit = null;
            CompilationUnitRewrite rewrite = null;
            Iterator<Object> iterator = this.fCompilationUnitRewrites.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                unit = (IJavaScriptUnit)iterator.next();
                if (unit.equals(extractedUnit)) {
                    TextEdit edit;
                    CompilationUnitChange change;
                    rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit);
                    if (rewrite == null || (change = rewrite.createChange()) == null || (edit = change.getEdit()) == null) continue;
                    Document document = new Document(this.fSuperSource);
                    try {
                        edit.apply((IDocument)document, 2);
                    }
                    catch (MalformedTreeException exception) {
                        JavaScriptPlugin.log(exception);
                    }
                    catch (BadLocationException exception) {
                        JavaScriptPlugin.log(exception);
                    }
                    this.fSuperSource = document.get();
                    manager.remove(extractedUnit);
                    continue;
                }
                rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit);
                if (rewrite == null) continue;
                CompilationUnitChange layerChange = (CompilationUnitChange)((Object)this.fLayerChanges.get(unit.getPrimary()));
                CompilationUnitChange rewriteChange = rewrite.createChange();
                if (rewriteChange != null && layerChange != null) {
                    MultiStateCompilationUnitChange change = new MultiStateCompilationUnitChange(rewriteChange.getName(), unit);
                    change.addChange((TextChange)layerChange);
                    change.addChange((TextChange)rewriteChange);
                    this.fLayerChanges.remove(unit.getPrimary());
                    manager.manage(unit, (TextEditBasedChange)change);
                    continue;
                }
                if (layerChange != null) {
                    manager.manage(unit, (TextEditBasedChange)layerChange);
                    this.fLayerChanges.remove(unit.getPrimary());
                    continue;
                }
                if (rewriteChange == null) continue;
                manager.manage(unit, (TextEditBasedChange)rewriteChange);
            }
            iterator = this.fLayerChanges.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    units = manager.getAllCompilationUnits();
                    index = 0;
                    break;
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                manager.manage((IJavaScriptUnit)entry.getKey(), (TextEditBasedChange)entry.getValue());
            }
            while (index < units.length) {
                if (units[index].getPath().equals((Object)extractedUnit.getPath())) {
                    manager.remove(units[index]);
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.fLayerChanges.clear();
            throw throwable;
        }
        {
            Object var10_15 = null;
            this.fLayerChanges.clear();
            return;
        }
    }

    public void resetChanges() {
        this.fLayerChanges.clear();
    }

    public void setTypeName(String name) {
        Assert.isNotNull((Object)name);
        this.fTypeName = name;
    }

    public void setTypesToExtract(IType[] types) {
        Assert.isNotNull((Object)types);
        this.fTypesToExtract = types;
    }
}

