/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.dialogs.ScriptSelectionDialog;

public class AddScriptLoadBreakpointAction
implements IViewActionDelegate {
    public void run(IAction action) {
        try {
            ScriptSelectionDialog dialog = new ScriptSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setTitle(Messages.add_script_load_bp);
            if (dialog.open() == 0) {
                final IFile file = (IFile)dialog.getFirstResult();
                final String scriptname = file.getName();
                final String scriptpath = file.getFullPath().makeRelative().toString();
                IJavaScriptLoadBreakpoint breakpoint = this.findBreakpoint(scriptpath, scriptname);
                if (breakpoint != null) {
                    breakpoint.setEnabled(true);
                    return;
                }
                Job job = new Job(Messages.creating_script_load_bp){

                    protected IStatus run(IProgressMonitor monitor) {
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put("org.eclipse.wst.jsdt.debug.core.type_name", scriptname);
                        attributes.put("org.eclipse.wst.jsdt.debug.core.script_path", scriptpath);
                        try {
                            JavaScriptDebugModel.createScriptLoadBreakpoint((IResource)file, (int)-1, (int)-1, attributes, (boolean)true);
                        }
                        catch (DebugException de) {
                            JavaScriptDebugUIPlugin.log(de);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(10);
                job.setSystem(true);
                job.schedule();
            }
        }
        catch (CoreException ce) {
            JavaScriptDebugUIPlugin.log(ce);
        }
    }

    IJavaScriptLoadBreakpoint findBreakpoint(String scriptpath, String scriptname) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.wst.jsdt.debug.model");
        IJavaScriptLoadBreakpoint breakpoint = null;
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof IJavaScriptLoadBreakpoint && (breakpoint = (IJavaScriptLoadBreakpoint)breakpoints[i]).getTypeName().equals(scriptname) && breakpoint.getScriptPath().equals(scriptpath)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

