/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CaseStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class BlockScope
extends Scope {
    public LocalVariableBinding[] locals;
    public MethodBinding[] methods;
    public int numberMethods;
    public int localIndex;
    public int startIndex;
    public int offset;
    public int maxOffset;
    public BlockScope[] shiftScopes;
    public Scope[] subscopes = new Scope[1];
    public int subscopeCount = 0;
    public CaseStatement enclosingCase;
    public static final VariableBinding[] EmulationPathToImplicitThis = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInConstructorCall = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInStaticContext = new VariableBinding[0];

    public BlockScope(BlockScope parent) {
        this(parent, true);
    }

    public BlockScope(BlockScope parent, boolean addToParentScope) {
        this(1, parent);
        this.locals = new LocalVariableBinding[5];
        this.methods = new MethodBinding[5];
        if (addToParentScope) {
            parent.addSubscope(this);
        }
        this.startIndex = parent.localIndex;
    }

    public BlockScope(BlockScope parent, int variableCount) {
        this(1, parent);
        this.locals = new LocalVariableBinding[variableCount];
        this.methods = new MethodBinding[5];
        parent.addSubscope(this);
        this.startIndex = parent.localIndex;
    }

    protected BlockScope(int kind, Scope parent) {
        super(kind, parent);
        this.locals = new LocalVariableBinding[5];
        this.methods = new MethodBinding[5];
    }

    public final void addAnonymousType(TypeDeclaration anonymousType, ReferenceBinding superBinding) {
        ClassScope anonymousClassScope = new ClassScope((Scope)this, anonymousType);
        anonymousClassScope.buildAnonymousTypeBinding(this.enclosingSourceType(), superBinding);
    }

    public final void addLocalType(TypeDeclaration localType) {
        ClassScope localTypeScope = new ClassScope((Scope)this, localType);
        this.addSubscope(localTypeScope);
        localTypeScope.buildLocalTypeBinding(this.enclosingSourceType());
    }

    public void addLocalVariable(LocalVariableBinding binding) {
        int n;
        this.checkAndSetModifiersForVariable(binding);
        if (this.localIndex == this.locals.length) {
            this.locals = new LocalVariableBinding[this.localIndex * 2];
            System.arraycopy(this.locals, 0, this.locals, 0, this.localIndex);
        }
        this.locals[this.localIndex++] = binding;
        binding.declaringScope = this;
        MethodScope outerMostMethodScope = this.outerMostMethodScope();
        if (outerMostMethodScope != null) {
            int n2 = outerMostMethodScope.analysisIndex;
            n = n2;
            outerMostMethodScope.analysisIndex = n2 + 1;
        } else {
            int n3 = this.compilationUnitScope().analysisIndex;
            n = n3;
            this.compilationUnitScope().analysisIndex = n3 + 1;
        }
        binding.id = n;
        if (binding.declaration != null && binding.declaration.initialization instanceof FunctionExpression || binding.declaration.inferredType != null && binding.declaration.inferredType.isFunction()) {
            MethodBinding methodBinding = new MethodBinding(0, binding.name, TypeBinding.UNKNOWN, null, this.enclosingTypeBinding());
            methodBinding.createFunctionTypeBinding(this);
            this.addLocalMethod(methodBinding);
        }
    }

    public void addLocalMethod(MethodBinding methodBinding) {
        if (this.numberMethods == this.methods.length) {
            this.methods = new MethodBinding[this.numberMethods * 2];
            System.arraycopy(this.methods, 0, this.methods, 0, this.numberMethods);
        }
        this.methods[this.numberMethods++] = methodBinding;
    }

    public void addSubscope(Scope childScope) {
        if (this.subscopeCount == this.subscopes.length) {
            this.subscopes = new Scope[this.subscopeCount * 2];
            System.arraycopy(this.subscopes, 0, this.subscopes, 0, this.subscopeCount);
        }
        this.subscopes[this.subscopeCount++] = childScope;
    }

    public final boolean allowBlankFinalFieldAssignment(FieldBinding binding) {
        if (this.enclosingReceiverType() != binding.declaringClass) {
            return false;
        }
        MethodScope methodScope = this.methodScope();
        if (methodScope.isStatic != binding.isStatic()) {
            return false;
        }
        return methodScope.isInsideInitializer() || ((AbstractMethodDeclaration)methodScope.referenceContext).isInitializationMethod();
    }

    String basicToString(int tab) {
        String newLine = "\n";
        int i = tab;
        while (--i >= 0) {
            newLine = String.valueOf(newLine) + "\t";
        }
        String s = String.valueOf(newLine) + "--- Block Scope ---";
        newLine = String.valueOf(newLine) + "\t";
        s = String.valueOf(s) + newLine + "locals:";
        int i2 = 0;
        while (i2 < this.localIndex) {
            s = String.valueOf(s) + newLine + "\t" + this.locals[i2].toString();
            ++i2;
        }
        s = String.valueOf(s) + newLine + "startIndex = " + this.startIndex;
        return s;
    }

    private void checkAndSetModifiersForVariable(LocalVariableBinding varBinding) {
        int modifiers;
        varBinding.modifiers = modifiers = varBinding.modifiers;
    }

    public void reportUnusedDeclarations() {
        if (this.locals != null) {
            int i = 0;
            while (i < this.localIndex) {
                LocalVariableBinding local = this.locals[i];
                if (local.useFlag == 0 && local.declaration != null && (local.declaration.bits & 0x40000000) != 0 && !(local.declaration instanceof Argument)) {
                    this.problemReporter().unusedLocalVariable(local.declaration);
                }
                ++i;
            }
        }
    }

    public void emulateOuterAccess(LocalVariableBinding outerLocalVariable) {
        NestedTypeBinding currentType;
        BlockScope outerVariableScope = outerLocalVariable.declaringScope;
        if (outerVariableScope == null) {
            return;
        }
        MethodScope currentMethodScope = this.methodScope();
        if (outerVariableScope.methodScope() != currentMethodScope && this.enclosingSourceType() instanceof NestedTypeBinding && !(currentType = (NestedTypeBinding)this.enclosingSourceType()).isLocalType()) {
            return;
        }
    }

    public final ReferenceBinding findLocalType(char[] name) {
        long compliance = this.compilerOptions().complianceLevel;
        int i = this.subscopeCount - 1;
        while (i >= 0) {
            if (this.subscopes[i] instanceof ClassScope) {
                LocalTypeBinding sourceType = (LocalTypeBinding)((ClassScope)this.subscopes[i]).getReferenceBinding();
                if ((compliance < 0x300000L || sourceType.enclosingCase == null || this.isInsideCase(sourceType.enclosingCase)) && CharOperation.equals(sourceType.sourceName(), name)) {
                    return sourceType;
                }
            }
            --i;
        }
        return null;
    }

    public MethodBinding findMethod(char[] methodName, TypeBinding[] argumentTypes, boolean checkVars) {
        LocalVariableBinding variable;
        int methodLength = methodName.length;
        int i = this.numberMethods - 1;
        while (i >= 0) {
            MethodBinding method = this.methods[i];
            char[] name = method.selector;
            if (method.selector.length == methodLength && CharOperation.equals(name, methodName)) {
                return method;
            }
            --i;
        }
        if (checkVars && (variable = this.findVariable(methodName)) != null) {
            MethodBinding binding = !variable.type.isAnyType() && !variable.type.isFunctionType() ? new ProblemMethodBinding(methodName, null, 15) : new MethodBinding(1, methodName, TypeBinding.UNKNOWN, null, variable.declaringScope.enclosingTypeBinding());
            this.addLocalMethod(binding);
            return binding;
        }
        return null;
    }

    public LocalDeclaration[] findLocalVariableDeclarations(int position) {
        int ilocal = 0;
        int maxLocals = this.localIndex;
        boolean hasMoreVariables = maxLocals > 0;
        LocalDeclaration[] localDeclarations = null;
        int declPtr = 0;
        int iscope = 0;
        int maxScopes = this.subscopeCount;
        boolean hasMoreScopes = maxScopes > 0;
        while (hasMoreVariables || hasMoreScopes) {
            LocalDeclaration localDecl;
            if (hasMoreScopes && (!hasMoreVariables || this.subscopes[iscope].startIndex() <= ilocal)) {
                Scope subscope = this.subscopes[iscope];
                if (subscope.kind == 1 && (localDeclarations = ((BlockScope)subscope).findLocalVariableDeclarations(position)) != null) {
                    return localDeclarations;
                }
                hasMoreScopes = ++iscope < maxScopes;
                continue;
            }
            LocalVariableBinding local = this.locals[ilocal];
            if (local != null && (localDecl = local.declaration) != null) {
                if (localDecl.declarationSourceStart <= position) {
                    if (position <= localDecl.declarationSourceEnd) {
                        if (localDeclarations == null) {
                            localDeclarations = new LocalDeclaration[maxLocals];
                        }
                        localDeclarations[declPtr++] = localDecl;
                    }
                } else {
                    return localDeclarations;
                }
            }
            boolean bl = hasMoreVariables = ++ilocal < maxLocals;
            if (hasMoreVariables || localDeclarations == null) continue;
            return localDeclarations;
        }
        return null;
    }

    public LocalVariableBinding findVariable(char[] variableName) {
        int varLength = variableName.length;
        int i = this.localIndex - 1;
        while (i >= 0) {
            LocalVariableBinding local = this.locals[i];
            char[] localName = local.name;
            if (local.name.length == varLength && CharOperation.equals(localName, variableName)) {
                return local;
            }
            --i;
        }
        return null;
    }

    public Binding getBinding(char[][] compoundName, int mask, InvocationSite invocationSite, boolean needResolve) {
        ASTNode invocationNode;
        int currentIndex;
        int length;
        Binding binding;
        block18: {
            binding = this.getBinding(compoundName[0], mask | 4 | 0x4000, invocationSite, needResolve);
            invocationSite.setFieldIndex(1);
            if (binding instanceof VariableBinding) {
                return binding;
            }
            CompilationUnitScope unitScope = this.compilationUnitScope();
            unitScope.recordQualifiedReference(compoundName);
            if (!binding.isValidBinding()) {
                return binding;
            }
            length = compoundName.length;
            currentIndex = 1;
            if (binding instanceof PackageBinding) {
                PackageBinding packageBinding = (PackageBinding)binding;
                while (currentIndex < length) {
                    unitScope.recordReference(packageBinding.compoundName, compoundName[currentIndex]);
                    binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++], mask);
                    invocationSite.setFieldIndex(currentIndex);
                    if (binding == null) {
                        if (currentIndex == length) {
                            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                        }
                        return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                    }
                    if (binding instanceof ReferenceBinding) {
                        if (!binding.isValidBinding()) {
                            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), ((ReferenceBinding)binding).closestMatch(), binding.problemId());
                        }
                        if (!((ReferenceBinding)binding).canBeSeenBy(this)) {
                            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), (ReferenceBinding)binding, 2);
                        }
                        break block18;
                    }
                    packageBinding = (PackageBinding)binding;
                }
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)binding;
        binding = referenceBinding;
        if (invocationSite instanceof ASTNode && (invocationNode = (ASTNode)((Object)invocationSite)).isTypeUseDeprecated(referenceBinding, this)) {
            this.problemReporter().deprecatedType(referenceBinding, invocationNode);
        }
        while (currentIndex < length) {
            ASTNode invocationNode2;
            referenceBinding = (ReferenceBinding)binding;
            char[] nextName = compoundName[currentIndex++];
            invocationSite.setFieldIndex(currentIndex);
            invocationSite.setActualReceiverType(referenceBinding);
            if ((mask & 1) != 0 && (binding = this.findField(referenceBinding, nextName, invocationSite, true)) != null) {
                if (binding.isValidBinding()) break;
                return new ProblemFieldBinding(((ProblemFieldBinding)binding).closestMatch, ((ProblemFieldBinding)binding).declaringClass, CharOperation.concatWith(CharOperation.subarray(compoundName, 0, currentIndex), '.'), binding.problemId());
            }
            binding = this.findMemberType(nextName, referenceBinding);
            if (binding == null) {
                if ((mask & 1) != 0) {
                    return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), referenceBinding, 1);
                }
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), referenceBinding, 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), ((ReferenceBinding)binding).closestMatch(), binding.problemId());
            }
            if (!(invocationSite instanceof ASTNode) || !(invocationNode2 = (ASTNode)((Object)invocationSite)).isTypeUseDeprecated(referenceBinding = (ReferenceBinding)binding, this)) continue;
            this.problemReporter().deprecatedType(referenceBinding, invocationNode2);
        }
        if ((mask & 1) != 0 && binding instanceof FieldBinding) {
            FieldBinding field = (FieldBinding)binding;
            if (!field.isStatic()) {
                return new ProblemFieldBinding(field, field.declaringClass, CharOperation.concatWith(CharOperation.subarray(compoundName, 0, currentIndex), '.'), 7);
            }
            return binding;
        }
        if ((mask & 4) != 0 && binding instanceof ReferenceBinding) {
            return binding;
        }
        return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
    }

    public final Binding getBinding(char[][] compoundName, InvocationSite invocationSite) {
        Binding binding;
        int length;
        int currentIndex;
        block17: {
            block16: {
                currentIndex = 0;
                length = compoundName.length;
                if (!(binding = this.getBinding(compoundName[currentIndex++], 16391, invocationSite, true)).isValidBinding()) {
                    return binding;
                }
                if (binding instanceof PackageBinding) {
                    while (currentIndex < length) {
                        PackageBinding packageBinding = (PackageBinding)binding;
                        if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++], 16391)) == null) {
                            if (currentIndex == length) {
                                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                            }
                            return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), 1);
                        }
                        if (!(binding instanceof ReferenceBinding)) continue;
                        if (!binding.isValidBinding()) {
                            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), ((ReferenceBinding)binding).closestMatch(), binding.problemId());
                        }
                        if (!((ReferenceBinding)binding).canBeSeenBy(this)) {
                            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), (ReferenceBinding)binding, 2);
                        }
                        break block16;
                    }
                    return binding;
                }
            }
            if (binding instanceof ReferenceBinding) {
                while (currentIndex < length) {
                    char[] nextName;
                    ReferenceBinding typeBinding = (ReferenceBinding)binding;
                    if ((binding = this.findField(typeBinding, nextName = compoundName[currentIndex++], invocationSite, true)) != null) {
                        if (!binding.isValidBinding()) {
                            return new ProblemFieldBinding((FieldBinding)binding, ((FieldBinding)binding).declaringClass, CharOperation.concatWith(CharOperation.subarray(compoundName, 0, currentIndex), '.'), binding.problemId());
                        }
                        if (!((FieldBinding)binding).isStatic()) {
                            return new ProblemFieldBinding((FieldBinding)binding, ((FieldBinding)binding).declaringClass, CharOperation.concatWith(CharOperation.subarray(compoundName, 0, currentIndex), '.'), 7);
                        }
                        break block17;
                    }
                    binding = this.findMemberType(nextName, typeBinding);
                    if (binding == null) {
                        return new ProblemBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 1);
                    }
                    if (binding.isValidBinding()) continue;
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), ((ReferenceBinding)binding).closestMatch(), binding.problemId());
                }
                return binding;
            }
        }
        VariableBinding variableBinding = (VariableBinding)binding;
        while (currentIndex < length) {
            TypeBinding typeBinding = variableBinding.type;
            if (typeBinding == null) {
                return new ProblemFieldBinding(null, null, CharOperation.concatWith(CharOperation.subarray(compoundName, 0, currentIndex), '.'), 1);
            }
            if ((variableBinding = this.findField(typeBinding, compoundName[currentIndex++], invocationSite, true)) == null) {
                return new ProblemFieldBinding(null, null, CharOperation.concatWith(CharOperation.subarray(compoundName, 0, currentIndex), '.'), 1);
            }
            if (variableBinding.isValidBinding()) continue;
            return variableBinding;
        }
        return variableBinding;
    }

    public VariableBinding[] getEmulationPath(LocalVariableBinding outerLocalVariable) {
        MethodScope currentMethodScope = this.methodScope();
        currentMethodScope.enclosingSourceType();
        BlockScope variableScope = outerLocalVariable.declaringScope;
        if (variableScope == null || currentMethodScope == variableScope.methodScope()) {
            return new VariableBinding[]{outerLocalVariable};
        }
        return null;
    }

    public Object[] getEmulationPath(ReferenceBinding targetEnclosingType, boolean onlyExactMatch, boolean denyEnclosingArgInConstructorCall) {
        ReferenceBinding enclosingType;
        MethodScope currentMethodScope = this.methodScope();
        SourceTypeBinding sourceType = currentMethodScope.enclosingSourceType();
        if (!(currentMethodScope.isStatic || currentMethodScope.isConstructorCall || sourceType != targetEnclosingType && (onlyExactMatch || sourceType.findSuperTypeWithSameErasure(targetEnclosingType) == null))) {
            return EmulationPathToImplicitThis;
        }
        if (!sourceType.isNestedType() || sourceType.isStatic()) {
            if (currentMethodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            if (currentMethodScope.isStatic) {
                return NoEnclosingInstanceInStaticContext;
            }
            return null;
        }
        boolean insideConstructor = currentMethodScope.isInsideInitializerOrConstructor();
        if (currentMethodScope.isStatic) {
            return NoEnclosingInstanceInStaticContext;
        }
        if (sourceType.isAnonymousType() && (enclosingType = sourceType.enclosingType()).isNestedType()) {
            NestedTypeBinding cfr_ignored_0 = (NestedTypeBinding)enclosingType;
        }
        Object[] path = new Object[2];
        ReferenceBinding currentType = sourceType.enclosingType();
        if (!insideConstructor && currentMethodScope.isConstructorCall) {
            return NoEnclosingInstanceInConstructorCall;
        }
        if (path[0] != null) {
            if (currentType.enclosingType() != null && currentType != targetEnclosingType && (onlyExactMatch || currentType.findSuperTypeWithSameErasure(targetEnclosingType) == null) && currentMethodScope != null) {
                if ((currentMethodScope = currentMethodScope.enclosingMethodScope()) != null && currentMethodScope.isConstructorCall) {
                    return NoEnclosingInstanceInConstructorCall;
                }
                if (currentMethodScope != null && currentMethodScope.isStatic) {
                    return NoEnclosingInstanceInStaticContext;
                }
            }
            if (currentType == targetEnclosingType || !onlyExactMatch && currentType.findSuperTypeWithSameErasure(targetEnclosingType) != null) {
                return path;
            }
        }
        return null;
    }

    public final boolean isDuplicateLocalVariable(char[] name) {
        BlockScope current = this;
        while (true) {
            int i = 0;
            while (i < this.localIndex) {
                if (CharOperation.equals(name, current.locals[i].name)) {
                    return true;
                }
                ++i;
            }
            if (current.kind != 1) {
                return false;
            }
            current = (BlockScope)current.parent;
        }
    }

    public int maxShiftedOffset() {
        int max = -1;
        if (this.shiftScopes != null) {
            int i = 0;
            int length = this.shiftScopes.length;
            while (i < length) {
                int subMaxOffset = this.shiftScopes[i].maxOffset;
                if (subMaxOffset > max) {
                    max = subMaxOffset;
                }
                ++i;
            }
        }
        return max;
    }

    public ProblemReporter problemReporter() {
        BlockScope scope = this.outerMostMethodScope();
        if (scope == null) {
            scope = this.compilationUnitScope();
        }
        return ((Scope)scope).problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.methodScope().referenceType();
    }

    public int scopeIndex() {
        if (this instanceof MethodScope || this instanceof CompilationUnitScope) {
            return -1;
        }
        BlockScope parentScope = (BlockScope)this.parent;
        Scope[] parentSubscopes = parentScope.subscopes;
        int i = 0;
        int max = parentScope.subscopeCount;
        while (i < max) {
            if (parentSubscopes[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setMethods(MethodBinding[] methods) {
        this.methods = methods;
    }

    int startIndex() {
        return this.startIndex;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        String s = this.basicToString(tab);
        int i = 0;
        while (i < this.subscopeCount) {
            if (this.subscopes[i] instanceof BlockScope) {
                s = String.valueOf(s) + ((BlockScope)this.subscopes[i]).toString(tab + 1) + "\n";
            }
            ++i;
        }
        return s;
    }
}

