/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.internal.validation.JSPBatchValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.text.IRegionComparible;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPDirectiveValidator
extends JSPValidator {
    private static final String PREFERENCE_NODE_QUALIFIER = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
    private static Collator collator = Collator.getInstance((Locale)Locale.US);
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator"));
    private IValidator fMessageOriginator;
    private IEclipsePreferences fPreferences = null;
    private IPreferencesService fPreferencesService = null;
    private HashMap fPrefixValueRegionToDocumentRegionMap = new HashMap();
    private IJavaProject fProject = null;
    private HashMap fReservedPrefixes = new HashMap();
    private IScopeContext[] fScopes = null;
    private int fSeverityIncludeFileMissing = -1;
    private int fSeverityIncludeFileNotSpecified = -1;
    private int fSeveritySuperClassNotFound = -1;
    private int fSeverityTagdirUnresolvableURI = -1;
    private int fSeverityTaglibDuplicatePrefixWithDifferentURIs = -1;
    private int fSeverityTaglibDuplicatePrefixWithSameURIs = -1;
    private int fSeverityTaglibMissingPrefix = -1;
    private int fSeverityTaglibMissingURI = -1;
    private int fSeverityTaglibUnresolvableURI = -1;
    private HashMap fTaglibPrefixesInUse = new HashMap();

    public JSPDirectiveValidator() {
        this.initReservedPrefixes();
        this.fMessageOriginator = this;
    }

    public JSPDirectiveValidator(IValidator validator) {
        this.initReservedPrefixes();
        this.fMessageOriginator = validator;
    }

    void addDependsOn(IResource file) {
        if (this.fMessageOriginator instanceof JSPBatchValidator) {
            ((JSPBatchValidator)this.fMessageOriginator).addDependsOn(file);
        }
    }

    public void cleanup(IReporter reporter) {
        super.cleanup(reporter);
        this.fTaglibPrefixesInUse.clear();
        this.fPrefixValueRegionToDocumentRegionMap.clear();
    }

    private void collectTaglibPrefix(IStructuredDocumentRegion documentRegion, ITextRegion valueRegion, String taglibPrefix) {
        this.fPrefixValueRegionToDocumentRegionMap.put(valueRegion, documentRegion);
        Object o = this.fTaglibPrefixesInUse.get(taglibPrefix);
        if (o == null) {
            this.fTaglibPrefixesInUse.put(taglibPrefix, valueRegion);
        } else {
            ArrayList<Object> regionList = null;
            if (o instanceof List) {
                regionList = (ArrayList<Object>)o;
            } else {
                regionList = new ArrayList<Object>();
                regionList.add(o);
                this.fTaglibPrefixesInUse.put(taglibPrefix, regionList);
            }
            regionList.add(valueRegion);
        }
    }

    int getMessageSeverity(String key) {
        int sev = this.fPreferencesService.getInt(PREFERENCE_NODE_QUALIFIER, key, 2, this.fScopes);
        switch (sev) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case -1: {
                return -1;
            }
        }
        return 2;
    }

    private void initReservedPrefixes() {
        this.fReservedPrefixes.put("jsp", "");
        this.fReservedPrefixes.put("jspx", "");
        this.fReservedPrefixes.put("java", "");
        this.fReservedPrefixes.put("javax", "");
        this.fReservedPrefixes.put("servlet", "");
        this.fReservedPrefixes.put("sun", "");
        this.fReservedPrefixes.put("sunw", "");
    }

    private boolean isReservedTaglibPrefix(String name) {
        return this.fReservedPrefixes.get(name) != null;
    }

    private void loadPreferences(IFile file) {
        ProjectScope projectScope;
        this.fScopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        this.fPreferencesService = Platform.getPreferencesService();
        if (file != null && file.isAccessible() && (projectScope = new ProjectScope(file.getProject())).getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("validation.use-project-settings", false)) {
            this.fScopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        this.fSeverityIncludeFileMissing = this.getMessageSeverity("validation.directive-include-fragment-file-not-found");
        this.fSeverityIncludeFileNotSpecified = this.getMessageSeverity("validation.directive-include-fragment-file-not-specified");
        this.fSeverityTaglibDuplicatePrefixWithDifferentURIs = this.getMessageSeverity("validation.directive-taglib-duplicate-prefixes-different-uris");
        this.fSeverityTaglibDuplicatePrefixWithSameURIs = this.getMessageSeverity("validation.directive-taglib-duplicate-prefixes-same-uris");
        this.fSeverityTaglibMissingPrefix = this.getMessageSeverity("validation.directive-taglib-missing-prefix");
        this.fSeverityTaglibMissingURI = this.getMessageSeverity("validation.directive-taglib-missing-uri-or-tagdir");
        this.fSeverityTaglibUnresolvableURI = this.getMessageSeverity("validation.directive-taglib-unresolvable-uri-or-tagdir");
        this.fSeverityTagdirUnresolvableURI = this.getMessageSeverity("validation.directive-taglib-unresolvable-uri-or-tagdir");
        this.fSeveritySuperClassNotFound = this.getMessageSeverity("validation.directive-page-superclass-not-found");
    }

    protected void performValidation(IFile f, IReporter reporter, IStructuredDocument sDoc) {
        this.loadPreferences(f);
        this.setProject(f.getProject());
        this.fPrefixValueRegionToDocumentRegionMap.clear();
        this.fTaglibPrefixesInUse.clear();
        IRegionComparible comparer = null;
        if (sDoc instanceof IRegionComparible) {
            comparer = (IRegionComparible)sDoc;
        }
        IStructuredDocumentRegion region = sDoc.getFirstStructuredDocumentRegion();
        while (region != null && !reporter.isCancelled()) {
            if (region.getType() == "JSP_DIRECTIVE_NAME") {
                this.processDirective(reporter, f, sDoc, region);
            } else if (comparer != null && region.getNumberOfRegions() > 4) {
                ITextRegion nameRegion = region.getRegions().get(1);
                if (comparer.regionMatches(region.getStartOffset(nameRegion), nameRegion.getTextLength(), "jsp:include")) {
                    this.processInclude(reporter, f, sDoc, region, "page");
                } else if (comparer.regionMatches(region.getStartOffset(nameRegion), 14, "jsp:directive.")) {
                    this.processDirective(reporter, f, sDoc, region);
                }
            }
            region = region.getNext();
        }
        if (!reporter.isCancelled()) {
            this.reportTaglibDuplicatePrefixes(f, reporter, sDoc);
        }
        this.fPrefixValueRegionToDocumentRegionMap.clear();
        this.fTaglibPrefixesInUse.clear();
        this.setProject(null);
        this.unloadPreferences();
    }

    private void processDirective(IReporter reporter, IFile file, IStructuredDocument sDoc, IStructuredDocumentRegion documentRegion) {
        String directiveName = this.getDirectiveName((ITextRegionCollection)documentRegion);
        if (directiveName.endsWith("taglib")) {
            this.processTaglibDirective(reporter, file, sDoc, documentRegion);
        } else if (directiveName.equals("jsp:include")) {
            this.processInclude(reporter, file, sDoc, documentRegion, "page");
        } else if (directiveName.endsWith("include")) {
            this.processInclude(reporter, file, sDoc, documentRegion, "file");
        } else if (directiveName.endsWith("page")) {
            this.processPageDirective(reporter, file, sDoc, documentRegion);
        }
    }

    private void processInclude(IReporter reporter, IFile file, IStructuredDocument sDoc, IStructuredDocumentRegion documentRegion, String attrName) {
        ITextRegion fileValueRegion = this.getAttributeValueRegion((ITextRegionCollection)documentRegion, attrName);
        if (fileValueRegion != null && !this.hasNestedRegion(fileValueRegion)) {
            IPath testPath;
            String fileValue = documentRegion.getText(fileValueRegion);
            if ((fileValue = StringUtils.stripQuotes((String)fileValue)).length() == 0 && this.fSeverityIncludeFileNotSpecified != -1) {
                String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)attrName);
                JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityIncludeFileNotSpecified, msgText, (IResource)file);
                int start = documentRegion.getStartOffset(fileValueRegion);
                int length = fileValueRegion.getTextLength();
                int lineNo = sDoc.getLineOfOffset(start);
                message.setLineNo(lineNo + 1);
                message.setOffset(start);
                message.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message);
            } else if (DeploymentDescriptorPropertyCache.getInstance().getURLMapping(file.getFullPath(), fileValue) == null && (testPath = FacetModuleCoreSupport.resolve(file.getFullPath(), fileValue)).segmentCount() > 1) {
                IFile testFile = file.getWorkspace().getRoot().getFile(testPath);
                this.addDependsOn((IResource)testFile);
                if (!testFile.isAccessible() && this.fSeverityIncludeFileMissing != -1) {
                    String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_4, (Object[])new String[]{fileValue, testPath.toString()});
                    JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityIncludeFileMissing, msgText, (IResource)file);
                    int start = documentRegion.getStartOffset(fileValueRegion);
                    int length = fileValueRegion.getTextLength();
                    int lineNo = sDoc.getLineOfOffset(start);
                    message.setLineNo(lineNo + 1);
                    message.setOffset(start);
                    message.setLength(length);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message);
                }
            }
        } else if (fileValueRegion == null && this.fSeverityIncludeFileNotSpecified != -1) {
            String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)attrName);
            JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityIncludeFileNotSpecified, msgText, (IResource)file);
            int start = documentRegion.getStartOffset();
            int length = documentRegion.getTextLength();
            int lineNo = sDoc.getLineOfOffset(start);
            message.setLineNo(lineNo + 1);
            message.setOffset(start);
            message.setLength(length);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
    }

    private void processPageDirective(IReporter reporter, IFile file, IStructuredDocument doc, IStructuredDocumentRegion documentRegion) {
        ITextRegion superclassValueRegion = this.getAttributeValueRegion((ITextRegionCollection)documentRegion, "extends");
        if (superclassValueRegion != null) {
            String superclassName = documentRegion.getText(superclassValueRegion);
            superclassName = StringUtils.stripQuotes((String)superclassName);
            IType superClass = null;
            if (superclassName != null && superclassName.length() > 0 && this.fProject != null && this.fProject.exists()) {
                try {
                    superClass = this.fProject.findType(superclassName.trim(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (JavaModelException e) {
                    Logger.logException(e);
                }
            }
            if (superClass == null && this.fSeveritySuperClassNotFound != -1) {
                String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_8, (Object)superclassName);
                JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeveritySuperClassNotFound, msgText, (IResource)file);
                int start = documentRegion.getStartOffset(superclassValueRegion);
                int length = superclassValueRegion.getTextLength();
                int lineNo = doc.getLineOfOffset(start);
                message.setLineNo(lineNo + 1);
                message.setOffset(start);
                message.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message);
            }
        }
    }

    private void processTaglibDirective(IReporter reporter, IFile file, IStructuredDocument sDoc, IStructuredDocumentRegion documentRegion) {
        JSPValidator.LocalizedMessage message;
        String msgText;
        String msgText2;
        int lineNo;
        ITextRegion prefixValueRegion = null;
        ITextRegion uriValueRegion = this.getAttributeValueRegion((ITextRegionCollection)documentRegion, "uri");
        ITextRegion tagdirValueRegion = this.getAttributeValueRegion((ITextRegionCollection)documentRegion, "tagdir");
        if (uriValueRegion != null) {
            String uri = documentRegion.getText(uriValueRegion);
            if (file != null) {
                if ((uri = StringUtils.stripQuotes((String)uri)).length() > 0) {
                    ITaglibRecord reference = TaglibIndex.resolve(file.getFullPath().toString(), uri, false);
                    if (reference != null) {
                        switch (reference.getRecordType()) {
                            case 1: {
                                ITaglibRecord record = (ITLDRecord)reference;
                                IFile tldfile = ResourcesPlugin.getWorkspace().getRoot().getFile(record.getPath());
                                this.addDependsOn((IResource)tldfile);
                                break;
                            }
                            case 2: {
                                ITaglibRecord record = (IJarRecord)reference;
                                IFile[] foundFilesForLocation = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(record.getLocation());
                                int i = 0;
                                while (i < foundFilesForLocation.length) {
                                    this.addDependsOn((IResource)foundFilesForLocation[i]);
                                    ++i;
                                }
                                break;
                            }
                            case 8: {
                                ITaglibRecord record = (ITagDirRecord)reference;
                                IPath path = record.getPath();
                                IResource found = ResourcesPlugin.getWorkspace().getRoot().findMember(path, false);
                                try {
                                    found.accept(new IResourceVisitor(){

                                        public boolean visit(IResource resource) throws CoreException {
                                            if (resource.getType() == 1) {
                                                JSPDirectiveValidator.this.addDependsOn(resource);
                                            }
                                            return true;
                                        }
                                    });
                                }
                                catch (CoreException e) {
                                    Logger.logException(e);
                                }
                                break;
                            }
                            case 4: {
                                ITaglibRecord record = (IURLRecord)reference;
                                String baseLocation = record.getBaseLocation();
                                if (baseLocation == null || baseLocation.indexOf("://") >= 0) break;
                                IResource found = ResourcesPlugin.getWorkspace().getRoot().findMember(baseLocation, false);
                                if (found != null) {
                                    try {
                                        found.accept(new IResourceVisitor(){

                                            public boolean visit(IResource resource) throws CoreException {
                                                if (resource.getType() == 1) {
                                                    JSPDirectiveValidator.this.addDependsOn(resource);
                                                }
                                                return true;
                                            }
                                        });
                                    }
                                    catch (CoreException e) {
                                        Logger.logException(e);
                                    }
                                    break;
                                }
                                IFile externalJar = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(baseLocation));
                                if (externalJar == null) break;
                                this.addDependsOn((IResource)externalJar);
                            }
                        }
                    }
                    if (reference == null && this.fSeverityTaglibUnresolvableURI != -1) {
                        String msgText3 = null;
                        msgText3 = uri.startsWith("http:") && (double)DeploymentDescriptorPropertyCache.getInstance().getJSPVersion(file.getFullPath()) < 1.2 ? (FacetModuleCoreSupport.isDynamicWebProject(file.getProject()) ? NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_9, (Object)uri) : NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_10, (Object)uri)) : NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_1, (Object)uri);
                        JSPValidator.LocalizedMessage message2 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibUnresolvableURI, msgText3, (IResource)file);
                        int start = documentRegion.getStartOffset(uriValueRegion);
                        int length = uriValueRegion.getTextLength();
                        lineNo = sDoc.getLineOfOffset(start);
                        message2.setLineNo(lineNo + 1);
                        message2.setOffset(start);
                        message2.setLength(length);
                        message2.setAttribute("PROBLEM_ID", new Integer(611));
                        reporter.addMessage(this.fMessageOriginator, (IMessage)message2);
                    }
                } else if (this.fSeverityTaglibMissingURI != -1) {
                    msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"uri");
                    JSPValidator.LocalizedMessage message3 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingURI, msgText2, (IResource)file);
                    int start = documentRegion.getStartOffset(uriValueRegion);
                    int length = uriValueRegion.getTextLength();
                    int lineNo2 = sDoc.getLineOfOffset(start);
                    message3.setLineNo(lineNo2 + 1);
                    message3.setOffset(start);
                    message3.setLength(length);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message3);
                }
            }
        } else if (tagdirValueRegion != null) {
            String tagdir = documentRegion.getText(tagdirValueRegion);
            if (file != null) {
                if ((tagdir = StringUtils.stripQuotes((String)tagdir)).length() <= 0 && this.fSeverityTaglibMissingURI != -1) {
                    msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"tagdir");
                    JSPValidator.LocalizedMessage message4 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingURI, msgText2, (IResource)file);
                    int start = documentRegion.getStartOffset(tagdirValueRegion);
                    int length = tagdirValueRegion.getTextLength();
                    int lineNo3 = sDoc.getLineOfOffset(start);
                    message4.setLineNo(lineNo3 + 1);
                    message4.setOffset(start);
                    message4.setLength(length);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message4);
                } else if (TaglibIndex.resolve(file.getFullPath().toString(), tagdir, false) == null && this.fSeverityTagdirUnresolvableURI != -1) {
                    msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_11, (Object)tagdir);
                    JSPValidator.LocalizedMessage message5 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibUnresolvableURI, msgText2, (IResource)file);
                    int start = documentRegion.getStartOffset(tagdirValueRegion);
                    int length = tagdirValueRegion.getTextLength();
                    int lineNo4 = sDoc.getLineOfOffset(start);
                    message5.setLineNo(lineNo4 + 1);
                    message5.setOffset(start);
                    message5.setLength(length);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message5);
                }
            }
        } else if (this.fSeverityTaglibMissingURI != -1) {
            msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_7, (Object[])new String[]{"tagdir", "uri"});
            message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingURI, msgText, (IResource)file);
            int start = documentRegion.getStartOffset();
            int length = documentRegion.getTextLength();
            int lineNo5 = sDoc.getLineOfOffset(start);
            message.setLineNo(lineNo5 + 1);
            message.setOffset(start);
            message.setLength(length);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
        if ((prefixValueRegion = this.getAttributeValueRegion((ITextRegionCollection)documentRegion, "prefix")) != null) {
            String taglibPrefix = documentRegion.getText(prefixValueRegion);
            taglibPrefix = StringUtils.stripQuotes((String)taglibPrefix);
            this.collectTaglibPrefix(documentRegion, prefixValueRegion, taglibPrefix);
            if (this.isReservedTaglibPrefix(taglibPrefix)) {
                msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_0, (Object)taglibPrefix);
                int sev = 1;
                JSPValidator.LocalizedMessage message6 = file == null ? new JSPValidator.LocalizedMessage(this, sev, msgText2) : new JSPValidator.LocalizedMessage((JSPValidator)this, sev, msgText2, (IResource)file);
                int start = documentRegion.getStartOffset(prefixValueRegion);
                int length = prefixValueRegion.getTextLength();
                lineNo = sDoc.getLineOfOffset(start);
                message6.setLineNo(lineNo + 1);
                message6.setOffset(start);
                message6.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message6);
            }
            if (taglibPrefix.length() == 0 && this.fSeverityTaglibMissingPrefix != -1) {
                msgText2 = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"prefix");
                JSPValidator.LocalizedMessage message7 = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingPrefix, msgText2, (IResource)file);
                int start = documentRegion.getStartOffset(prefixValueRegion);
                int length = prefixValueRegion.getTextLength();
                int lineNo6 = sDoc.getLineOfOffset(start);
                message7.setLineNo(lineNo6 + 1);
                message7.setOffset(start);
                message7.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message7);
            }
        } else if (this.fSeverityTaglibMissingPrefix != -1) {
            msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_3, (Object)"prefix");
            message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityTaglibMissingPrefix, msgText, (IResource)file);
            int start = documentRegion.getStartOffset();
            int length = documentRegion.getTextLength();
            int lineNo7 = sDoc.getLineOfOffset(start);
            message.setLineNo(lineNo7 + 1);
            message.setOffset(start);
            message.setLength(length);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
    }

    private void reportTaglibDuplicatePrefixes(IFile file, IReporter reporter, IStructuredDocument document) {
        if (this.fSeverityTaglibDuplicatePrefixWithDifferentURIs == -1 && this.fSeverityTaglibDuplicatePrefixWithSameURIs == -1) {
            return;
        }
        String[] prefixes = this.fTaglibPrefixesInUse.keySet().toArray(new String[0]);
        int prefixNumber = 0;
        while (prefixNumber < prefixes.length) {
            int severity = this.fSeverityTaglibDuplicatePrefixWithSameURIs;
            Object o = this.fTaglibPrefixesInUse.get(prefixes[prefixNumber]);
            if (o instanceof List) {
                List valueRegions = (List)o;
                String uri = null;
                int regionNumber = 0;
                while (regionNumber < valueRegions.size()) {
                    IStructuredDocumentRegion documentRegion = (IStructuredDocumentRegion)this.fPrefixValueRegionToDocumentRegionMap.get(valueRegions.get(regionNumber));
                    ITextRegion uriValueRegion = this.getAttributeValueRegion((ITextRegionCollection)documentRegion, "uri");
                    if (uriValueRegion == null) {
                        uriValueRegion = this.getAttributeValueRegion((ITextRegionCollection)documentRegion, "tagdir");
                    }
                    if (uriValueRegion != null) {
                        String uri2 = StringUtils.stripQuotes((String)documentRegion.getText(uriValueRegion));
                        if (uri == null) {
                            uri = uri2;
                        } else if (collator.compare(uri, uri2) != 0) {
                            severity = this.fSeverityTaglibDuplicatePrefixWithDifferentURIs;
                        }
                    }
                    ++regionNumber;
                }
                if (severity != -1) {
                    String msgText = NLS.bind((String)JSPCoreMessages.JSPDirectiveValidator_2, (Object)prefixes[prefixNumber]);
                    int regionNumber2 = 0;
                    while (regionNumber2 < valueRegions.size()) {
                        ITextRegion valueRegion = (ITextRegion)valueRegions.get(regionNumber2);
                        IStructuredDocumentRegion documentRegion = (IStructuredDocumentRegion)this.fPrefixValueRegionToDocumentRegionMap.get(valueRegion);
                        JSPValidator.LocalizedMessage message = file == null ? new JSPValidator.LocalizedMessage(this, severity, msgText) : new JSPValidator.LocalizedMessage((JSPValidator)this, severity, msgText, (IResource)file);
                        int start = documentRegion.getStartOffset(valueRegion);
                        int length = valueRegion.getTextLength();
                        int lineNo = document.getLineOfOffset(start);
                        message.setLineNo(lineNo + 1);
                        message.setOffset(start);
                        message.setLength(length);
                        reporter.addMessage(this.fMessageOriginator, (IMessage)message);
                        ++regionNumber2;
                    }
                }
            }
            ++prefixNumber;
        }
    }

    private void setProject(IProject project) {
        boolean useProject = false;
        if (project != null) {
            this.fProject = JavaCore.create((IProject)project);
            this.fPreferences = new ProjectScope(this.fProject.getProject()).getNode(PREFERENCE_NODE_QUALIFIER);
            useProject = this.fPreferences.getBoolean("use-project-settings", false);
        } else {
            this.fProject = null;
        }
        if (!useProject) {
            this.fPreferences = new InstanceScope().getNode(PREFERENCE_NODE_QUALIFIER);
        }
    }

    private void unloadPreferences() {
        this.fPreferencesService = null;
        this.fScopes = null;
    }

    private boolean hasNestedRegion(ITextRegion container) {
        return container instanceof ITextRegionContainer && ((ITextRegionContainer)container).getRegions() != null;
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 112->116)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

