/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter.comment;

import org.eclipse.wst.jsdt.internal.formatter.comment.CommentLine;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentRange;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentRegion;

public class SingleCommentLine
extends CommentLine {
    public static final String SINGLE_COMMENT_PREFIX = "// ";
    private static final String NLS_TAG_PREFIX = "//$NON-NLS-";
    private boolean fLocaleSequence = false;

    protected SingleCommentLine(CommentRegion region) {
        super(region);
    }

    protected void adapt(CommentLine previous) {
    }

    protected void formatLowerBorder(CommentRange range, String indentation, int length) {
        int offset = range.getOffset() + range.getLength();
        CommentRegion parent = this.getParent();
        parent.logEdit(parent.getDelimiter(), offset, parent.getLength() - offset);
    }

    protected void formatUpperBorder(CommentRange range, String indentation, int length) {
        CommentRegion parent = this.getParent();
        parent.logEdit(this.getContentPrefix(), 0, range.getOffset());
    }

    protected String getContentPrefix() {
        return SINGLE_COMMENT_PREFIX;
    }

    protected String getEndingPrefix() {
        return SINGLE_COMMENT_PREFIX;
    }

    protected String getStartingPrefix() {
        return SINGLE_COMMENT_PREFIX;
    }

    protected void scanLine(int line) {
        String prefix;
        CommentRange range = this.getFirst();
        String content = this.getParent().getText(range.getOffset(), range.getLength());
        int offset = content.indexOf(prefix = this.getContentPrefix().trim());
        if (offset >= 0) {
            if (content.startsWith(NLS_TAG_PREFIX)) {
                this.fLocaleSequence = true;
            }
            range.trimBegin(offset + prefix.length());
        }
    }

    protected void tokenizeLine(int line) {
        if (!this.fLocaleSequence) {
            super.tokenizeLine(line);
        }
    }
}

