/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeTuple;

public abstract class HierarchyType
extends TType {
    private HierarchyType fSuperclass;
    private IType fJavaElementType;

    protected HierarchyType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, IType javaElementType) {
        super.initialize(binding);
        Assert.isNotNull((Object)javaElementType);
        this.fJavaElementType = javaElementType;
        TypeEnvironment environment = this.getEnvironment();
        ITypeBinding superclass = binding.getSuperclass();
        if (superclass != null) {
            this.fSuperclass = (HierarchyType)environment.create(superclass);
        }
    }

    public TType getSuperclass() {
        return this.fSuperclass;
    }

    public IType getJavaElementType() {
        return this.fJavaElementType;
    }

    public boolean isSubType(HierarchyType other) {
        if (this.getEnvironment() == other.getEnvironment()) {
            TypeTuple key;
            Map cache = this.getEnvironment().getSubTypeCache();
            Boolean value = (Boolean)cache.get(key = new TypeTuple(this, other));
            if (value != null) {
                return value;
            }
            boolean isSub = this.doIsSubType(other);
            value = isSub;
            cache.put(key, value);
            return isSub;
        }
        return this.doIsSubType(other);
    }

    private boolean doIsSubType(HierarchyType other) {
        return this.fSuperclass != null && (other.isTypeEquivalentTo(this.fSuperclass) || this.fSuperclass.doIsSubType(other));
    }

    protected boolean canAssignToStandardType(StandardType target) {
        if (target.isJavaLangObject()) {
            return true;
        }
        return this.isSubType(target);
    }
}

