/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalLabelProvider;

public final class ProposalContextInformation
implements IContextInformation,
IContextInformationExtension {
    private final String fContextDisplayString;
    private final String fInformationDisplayString;
    private final Image fImage;
    private int fPosition;

    public ProposalContextInformation(CompletionProposal proposal) {
        CompletionProposalLabelProvider labelProvider = new CompletionProposalLabelProvider();
        this.fInformationDisplayString = labelProvider.createParameterList(proposal);
        ImageDescriptor descriptor = labelProvider.createImageDescriptor(proposal);
        this.fImage = descriptor != null ? JavaScriptPlugin.getImageDescriptorRegistry().get(descriptor) : null;
        this.fPosition = proposal.getCompletion().length == 0 ? proposal.getCompletionLocation() + 1 : -1;
        this.fContextDisplayString = labelProvider.createLabel(proposal);
    }

    public boolean equals(Object object) {
        if (object instanceof IContextInformation) {
            IContextInformation contextInformation = (IContextInformation)object;
            boolean equals = this.getInformationDisplayString().equalsIgnoreCase(contextInformation.getInformationDisplayString());
            if (this.getContextDisplayString() != null) {
                equals = equals && this.getContextDisplayString().equalsIgnoreCase(contextInformation.getContextDisplayString());
            }
            return equals;
        }
        return false;
    }

    public String getInformationDisplayString() {
        return this.fInformationDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getContextDisplayString() {
        return this.fContextDisplayString;
    }

    public int getContextInformationPosition() {
        return this.fPosition;
    }

    public void setContextInformationPosition(int position) {
        this.fPosition = position;
    }
}

