/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.File;
import java.net.URI;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ClasspathLibrary
extends ClasspathLocation {
    String filename;
    IFile resource;
    long lastModified;
    boolean closeZipFileAtEnd;
    SimpleSet knownPackageNames;
    AccessRuleSet accessRuleSet;

    ClasspathLibrary(IFile resource, AccessRuleSet accessRuleSet) {
        this.resource = resource;
        try {
            URI location = resource.getLocationURI();
            if (location == null) {
                this.filename = "";
            } else {
                File localFile = Util.toLocalFile(location, null);
                this.filename = localFile.getPath();
            }
        }
        catch (CoreException coreException) {}
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    ClasspathLibrary(String filename, long lastModified, AccessRuleSet accessRuleSet) {
        this.filename = filename;
        this.lastModified = lastModified;
        this.knownPackageNames = null;
        this.accessRuleSet = accessRuleSet;
    }

    public void cleanup() {
        this.knownPackageNames = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathLibrary)) {
            return false;
        }
        ClasspathLibrary library = (ClasspathLibrary)o;
        if (!(this.accessRuleSet == library.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals(library.accessRuleSet))) {
            return false;
        }
        return this.filename.equals(library.filename) && this.lastModified() == library.lastModified();
    }

    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        throw new UnimplementedException();
    }

    public IPath getProjectRelativePath() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getProjectRelativePath();
    }

    public boolean isPackage(String qualifiedPackageName) {
        return this.filename.endsWith(qualifiedPackageName);
    }

    public long lastModified() {
        if (this.lastModified == 0L) {
            this.lastModified = new File(this.filename).lastModified();
        }
        return this.lastModified;
    }

    public String toString() {
        String start = "Classpath library file " + this.filename;
        if (this.accessRuleSet == null) {
            return start;
        }
        return String.valueOf(start) + " with " + this.accessRuleSet;
    }

    public String debugPathString() {
        if (this.lastModified == 0L) {
            return this.filename;
        }
        return String.valueOf(this.filename) + '(' + new Date(this.lastModified) + " : " + this.lastModified + ')';
    }
}

