/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.exportmodel;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.common.internal.modulecore.AddClasspathLibReferencesParticipant;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyProvider;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyReceiver;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathDependenciesCollector
extends FlatVirtualComponent {
    public ClasspathDependenciesCollector(IVirtualComponent component) {
        super(component);
    }

    protected boolean canOptimize() {
        return true;
    }

    protected void optimize(List<IFlatResource> resources, List<IChildModuleReference> children) {
        if (this.getComponent() != null) {
            Object classpathReferences = null;
            IProject project = this.getComponent().getProject();
            if (JavaEEProjectUtilities.isEARProject(project)) {
                classpathReferences = new AddClasspathLibReferencesParticipant();
            } else if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
                classpathReferences = new WebLibClasspathReferencesParticipant();
            }
            if (classpathReferences != null) {
                classpathReferences.finalize(this.getComponent(), null, resources);
            }
        }
    }

    public List<IFlatFile> fetchFlatFiles() throws CoreException {
        IFlatResource[] resources = this.fetchResources();
        ArrayList<IFlatFile> flatFiles = new ArrayList<IFlatFile>();
        return this.fetchFlatFiles(resources, flatFiles);
    }

    private List<IFlatFile> fetchFlatFiles(IFlatResource[] resources, List<IFlatFile> flatFiles) {
        int i = 0;
        while (i < resources.length) {
            IFlatResource resource = resources[i];
            if (resource instanceof IFlatFile) {
                if (((IFlatFile)resource).getAdapter(File.class) != null) {
                    flatFiles.add((IFlatFile)resource);
                }
            } else if (resource instanceof IFlatFolder) {
                this.fetchFlatFiles(((IFlatFolder)resource).members(), flatFiles);
            }
            ++i;
        }
        return flatFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebLibClasspathReferencesParticipant
    extends AbstractFlattenParticipant {
        private List<IFlatResource> list;

        private WebLibClasspathReferencesParticipant() {
        }

        public void finalize(IVirtualComponent webComponent, FlatVirtualComponent.FlatComponentTaskModel dataModel, List<IFlatResource> resources) {
            this.list = resources;
            this.addReferencedComponentClasspathDependencies((IClasspathDependencyReceiver)webComponent);
        }

        private void addReferencedComponentClasspathDependencies(IClasspathDependencyReceiver webComponent) {
            IVirtualReference[] refs = webComponent.getReferences();
            int i = 0;
            while (i < refs.length) {
                IVirtualReference reference = refs[i];
                IPath runtimePath = reference.getRuntimePath();
                IVirtualComponent referencedComponent = reference.getReferencedComponent();
                if (runtimePath.equals((Object)WebUtilities.WEBLIB) && referencedComponent instanceof IClasspathDependencyProvider && !referencedComponent.isBinary() && referencedComponent instanceof IClasspathDependencyProvider) {
                    IVirtualReference[] cpRefs = ((IClasspathDependencyProvider)referencedComponent).getJavaClasspathReferences();
                    int j = 0;
                    while (j < cpRefs.length) {
                        IClasspathDependencyComponent cpComp;
                        IVirtualReference cpRef = cpRefs[j];
                        IPath cpRefRuntimePath = cpRef.getRuntimePath();
                        if (cpRef.getReferencedComponent() instanceof IClasspathDependencyComponent && !(cpComp = (IClasspathDependencyComponent)cpRef.getReferencedComponent()).isClassFolder() && cpRefRuntimePath.toString().equals("../")) {
                            cpRefRuntimePath = runtimePath;
                            new VirtualComponentFlattenUtility(this.list, null).addFile((IVirtualComponent)cpComp, cpRefRuntimePath, (IAdaptable)cpComp);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }
}

