/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListImpl
implements NodeList {
    private Object fLockObject = new byte[0];
    private static final int growthConstant = 2;
    private Node[] fNodes = null;
    private int fNodeCount = 0;

    public NodeListImpl() {
    }

    protected NodeListImpl(NodeListImpl list) {
        this.fNodeCount = list.fNodeCount;
        this.fNodes = list.fNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node appendNode(Node node) {
        if (node == null) {
            return null;
        }
        Object object = this.fLockObject;
        synchronized (object) {
            this.ensureCapacity(this.fNodeCount + 1);
            this.fNodes[this.fNodeCount++] = node;
        }
        return node;
    }

    private void ensureCapacity(int needed) {
        if (this.fNodes == null) {
            this.fNodes = new Node[needed];
            return;
        }
        int oldLength = this.fNodes.length;
        if (oldLength < needed) {
            Node[] oldNodes = this.fNodes;
            Node[] newNodes = new Node[needed + 2];
            System.arraycopy(oldNodes, 0, newNodes, 0, this.fNodeCount);
            this.fNodes = newNodes;
        }
    }

    public int getLength() {
        return this.fNodeCount;
    }

    protected final Node[] getNodes() {
        return this.fNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node insertNode(Node node, int index) {
        if (node == null) {
            return null;
        }
        Object object = this.fLockObject;
        synchronized (object) {
            if (this.fNodes == null) {
                this.fNodes = new Node[1];
                this.fNodes[this.fNodeCount++] = node;
                return node;
            }
            if (index < 0 || index > this.fNodeCount + 1) {
                return this.appendNode(node);
            }
            Node[] newNodes = new Node[this.fNodeCount + 2];
            System.arraycopy(this.fNodes, 0, newNodes, 0, index);
            newNodes[index] = node;
            System.arraycopy(this.fNodes, index, newNodes, index + 1, this.fNodeCount - index);
            this.fNodes = newNodes;
            ++this.fNodeCount;
        }
        return node;
    }

    public Node item(int index) {
        if (index < 0 || index >= this.fNodeCount) {
            return null;
        }
        return this.fNodes[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node removeNode(int index) {
        if (this.fNodes == null) {
            return null;
        }
        Object object = this.fLockObject;
        synchronized (object) {
            block5: {
                if (index >= 0 && index < this.fNodeCount) break block5;
                return null;
            }
            Node removed = this.fNodes[index];
            Node[] newNodes = new Node[this.fNodeCount - 1];
            System.arraycopy(this.fNodes, 0, newNodes, 0, index);
            System.arraycopy(this.fNodes, index + 1, newNodes, index, this.fNodeCount - index - 1);
            this.fNodes = newNodes;
            --this.fNodeCount;
            return removed;
        }
    }
}

