/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBaseEmbeddedMapping<T extends Annotation>
extends AbstractJavaAttributeMapping<T>
implements JavaBaseEmbeddedMapping {
    protected final JavaAttributeOverrideContainer attributeOverrideContainer = this.getJpaFactory().buildJavaAttributeOverrideContainer(this, this.buildAttributeOverrideContainerOwner());
    private Embeddable targetEmbeddable;

    protected AbstractJavaBaseEmbeddedMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected JavaAttributeOverrideContainer.Owner buildAttributeOverrideContainerOwner() {
        return new AttributeOverrideContainerOwner();
    }

    @Override
    public JavaAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    public TypeMapping getOverridableTypeMapping() {
        return this.targetEmbeddable;
    }

    @Override
    protected void addSupportingAnnotationNamesTo(Vector<String> names) {
        super.addSupportingAnnotationNamesTo(names);
        names.add("javax.persistence.AttributeOverride");
        names.add("javax.persistence.AttributeOverrides");
    }

    @Override
    public Embeddable getTargetEmbeddable() {
        return this.targetEmbeddable;
    }

    protected void setTargetEmbeddable_(Embeddable newTargetEmbeddable) {
        Embeddable oldTargetEmbeddable = this.targetEmbeddable;
        this.targetEmbeddable = newTargetEmbeddable;
        this.firePropertyChanged("targetEmbeddable", oldTargetEmbeddable, newTargetEmbeddable);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.attributeOverrideContainer.initialize(this.getResourcePersistentAttribute());
        this.targetEmbeddable = this.getPersistentAttribute().getEmbeddable();
    }

    @Override
    protected void update() {
        super.update();
        this.setTargetEmbeddable_(this.getPersistentAttribute().getEmbeddable());
        this.attributeOverrideContainer.update(this.getResourcePersistentAttribute());
    }

    protected Iterator<AttributeMapping> embeddableAttributeMappings() {
        Embeddable targetEmbeddable = this.getTargetEmbeddable();
        if (targetEmbeddable != null && targetEmbeddable != this.getPersistentAttribute().getOwningTypeMapping()) {
            return targetEmbeddable.attributeMappings();
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverrideableAttributeMappingNames() {
        return this.isJpa2_0Compatible() ? this.embeddableOverrideableAttributeMappingNames() : super.allOverrideableAttributeMappingNames();
    }

    protected Iterator<String> embeddableOverrideableAttributeMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAttributeMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverrideableAssociationMappingNames() {
        return this.isJpa2_0Compatible() ? this.embeddableOverrideableAssociationMappingNames() : super.allOverrideableAssociationMappingNames();
    }

    protected Iterator<String> embeddableOverrideableAssociationMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAssociationMappingNames();
            }
        });
    }

    protected Iterator<String> embeddableOverrideableMappingNames(Transformer<AttributeMapping, Iterator<String>> transformer) {
        return new TransformationIterator<String, String>((Iterator)new CompositeIterator((Iterator)new TransformationIterator(this.embeddableAttributeMappings(), transformer))){

            protected String transform(String next) {
                return String.valueOf(AbstractJavaBaseEmbeddedMapping.this.getName()) + '.' + next;
            }
        };
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        int dotIndex;
        if (this.isJpa2_0Compatible() && (dotIndex = attributeName.indexOf(46)) != -1 && this.getName().equals(attributeName.substring(0, dotIndex))) {
            attributeName = attributeName.substring(dotIndex + 1);
            JavaAttributeOverride override = this.getAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
            if (override != null && !override.isVirtual()) {
                return override.getColumn();
            }
            if (this.getTargetEmbeddable() == null) {
                return null;
            }
            return this.getTargetEmbeddable().resolveOverriddenColumn(attributeName);
        }
        return null;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getAttributeOverrideContainer().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.validateTargetEmbeddable(messages, reporter, astRoot)) {
            this.validateOverrides(messages, reporter, astRoot);
        }
    }

    protected boolean validateTargetEmbeddable(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.getTargetEmbeddable() == null) {
            String targetEmbeddableTypeName = this.getPersistentAttribute().getTypeName();
            if (targetEmbeddableTypeName != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_NOT_AN_EMBEDDABLE", new String[]{targetEmbeddableTypeName}, this, this.getValidationTextRange(astRoot)));
            }
            return false;
        }
        return true;
    }

    protected void validateOverrides(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.getAttributeOverrideContainer().validate(messages, reporter, astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideContainerOwner
    implements JavaAttributeOverrideContainer.Owner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return AbstractJavaBaseEmbeddedMapping.this.getTypeMapping();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaBaseEmbeddedMapping.this.getOverridableTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : this.allOverridableAttributeNames_(typeMapping);
        }

        protected Iterator<String> allOverridableAttributeNames_(TypeMapping typeMapping) {
            return typeMapping.allOverridableAttributeNames();
        }

        @Override
        public Column resolveOverriddenColumn(String attributeOverrideName) {
            return MappingTools.resolveOverridenColumn(this.getOverridableTypeMapping(), attributeOverrideName);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return this.getTypeMapping().associatedTableNamesIncludingInherited();
        }

        @Override
        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        @Override
        public String getDefaultTableName() {
            return this.getTypeMapping().getPrimaryTableName();
        }

        @Override
        public String getPossiblePrefix() {
            return null;
        }

        @Override
        public String getWritePrefix() {
            return null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            return true;
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaBaseEmbeddedMapping.this.getValidationTextRange(astRoot);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        protected IMessage buildVirtualColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }
    }
}

