/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JoinColumnsAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceJoinColumnsAnnotation
extends SourceAnnotation<Member>
implements JoinColumnsAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumns");
    private final Vector<NestableJoinColumnAnnotation> joinColumns = new Vector();

    public SourceJoinColumnsAnnotation(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.JoinColumns";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        AnnotationContainerTools.initialize(this, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        AnnotationContainerTools.synchronize(this, astRoot);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.joinColumns);
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public String getNestedAnnotationName() {
        return "javax.persistence.JoinColumn";
    }

    @Override
    public Iterable<NestableJoinColumnAnnotation> getNestedAnnotations() {
        return new LiveCloneIterable(this.joinColumns);
    }

    @Override
    public int getNestedAnnotationsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation addNestedAnnotation() {
        return this.addNestedAnnotation(this.joinColumns.size());
    }

    private NestableJoinColumnAnnotation addNestedAnnotation(int index) {
        NestableJoinColumnAnnotation joinColumn = this.buildJoinColumn(index);
        this.joinColumns.add(joinColumn);
        return joinColumn;
    }

    @Override
    public void syncAddNestedAnnotation(Annotation astAnnotation) {
        int index = this.joinColumns.size();
        NestableJoinColumnAnnotation joinColumn = this.addNestedAnnotation(index);
        joinColumn.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    private NestableJoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.createNestedJoinColumn(this, this.member, index, this.daa);
    }

    @Override
    public NestableJoinColumnAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public NestableJoinColumnAnnotation removeNestedAnnotation(int index) {
        return this.joinColumns.remove(index);
    }

    @Override
    public void syncRemoveNestedAnnotations(int index) {
        this.removeItemsFromList(index, this.joinColumns, "joinColumns");
    }
}

