/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaRelationshipReference;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.jpa1.context.java.GenericJavaCascade;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.java.JavaCascade2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaRelationshipMapping2_0;
import org.eclipse.jpt.core.jpa2.resource.java.RelationshipMapping2_0Annotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaRelationshipMapping<T extends RelationshipMapping2_0Annotation>
extends AbstractJavaAttributeMapping<T>
implements JavaRelationshipMapping2_0 {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected String fullyQualifiedTargetEntity;
    protected PersistentType resolvedTargetType;
    protected Entity resolvedTargetEntity;
    protected final JavaRelationshipReference relationshipReference = this.buildRelationshipReference();
    protected final JavaCascade2_0 cascade = this.buildCascade();
    protected FetchType specifiedFetch;

    protected AbstractJavaRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.relationshipReference.initialize();
        this.specifiedFetch = this.getResourceFetch();
        this.cascade.initialize();
        this.defaultTargetEntity = this.buildDefaultTargetEntity();
        this.specifiedTargetEntity = this.getResourceTargetEntity();
        this.fullyQualifiedTargetEntity = this.buildFullyQualifiedTargetEntity();
        this.resolvedTargetType = this.resolveTargetType();
        this.resolvedTargetEntity = this.resolveTargetEntity();
    }

    @Override
    protected void update() {
        super.update();
        this.relationshipReference.update();
        this.setSpecifiedFetch_(this.getResourceFetch());
        this.cascade.update();
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.setSpecifiedTargetEntity_(this.getResourceTargetEntity());
        this.setFullyQualifiedTargetEntity(this.buildFullyQualifiedTargetEntity());
        this.resolvedTargetType = this.resolveTargetType();
        this.setResolvedTargetEntity(this.resolveTargetEntity());
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        ((RelationshipMapping2_0Annotation)this.mappingAnnotation).setTargetEntity(targetEntity);
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    protected void setSpecifiedTargetEntity_(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    protected String getResourceTargetEntity() {
        return ((RelationshipMapping2_0Annotation)this.mappingAnnotation).getTargetEntity();
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String targetEntity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = targetEntity;
        this.firePropertyChanged("defaultTargetEntity", old, targetEntity);
    }

    protected abstract String buildDefaultTargetEntity();

    @Override
    public String getFullyQualifiedTargetEntity() {
        return this.fullyQualifiedTargetEntity;
    }

    protected void setFullyQualifiedTargetEntity(String targetEntity) {
        String old = this.fullyQualifiedTargetEntity;
        this.fullyQualifiedTargetEntity = targetEntity;
        this.firePropertyChanged("fullyQualifiedTargetEntity", old, targetEntity);
    }

    protected String buildFullyQualifiedTargetEntity() {
        return this.specifiedTargetEntity == null ? this.defaultTargetEntity : ((RelationshipMapping2_0Annotation)this.mappingAnnotation).getFullyQualifiedTargetEntityClassName();
    }

    public PersistentType getResolvedTargetType() {
        return this.resolvedTargetType;
    }

    protected PersistentType resolveTargetType() {
        return this.fullyQualifiedTargetEntity == null ? null : this.getPersistenceUnit().getPersistentType(this.fullyQualifiedTargetEntity);
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    protected void setResolvedTargetEntity(Entity entity) {
        Entity old = this.resolvedTargetEntity;
        this.resolvedTargetEntity = entity;
        this.firePropertyChanged("resolvedTargetEntity", old, entity);
    }

    protected Entity resolveTargetEntity() {
        if (this.resolvedTargetType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedTargetType.getMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public Iterator<String> allTargetEntityAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.allTargetEntityAttributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allMappingNames();
            }
        });
    }

    protected Iterator<AttributeMapping> allTargetEntityAttributeMappings() {
        return this.resolvedTargetEntity != null ? this.resolvedTargetEntity.allAttributeMappings() : EmptyIterator.instance();
    }

    protected String getTargetEntityIdAttributeName() {
        PersistentAttribute attribute = this.getTargetEntityIdAttribute();
        return attribute == null ? null : attribute.getName();
    }

    protected PersistentAttribute getTargetEntityIdAttribute() {
        return this.resolvedTargetEntity == null ? null : this.resolvedTargetEntity.getIdAttribute();
    }

    @Override
    public char getTargetEntityEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public JavaRelationshipReference getRelationshipReference() {
        return this.relationshipReference;
    }

    protected abstract JavaRelationshipReference buildRelationshipReference();

    @Override
    public boolean isRelationshipOwner() {
        return this.relationshipReference.isRelationshipOwner();
    }

    @Override
    public RelationshipMapping getRelationshipOwner() {
        Entity targetEntity = this.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        for (PersistentAttribute each : CollectionTools.iterable(targetEntity.getPersistentType().allAttributes())) {
            if (!this.isOwnedBy(each.getMapping())) continue;
            return (RelationshipMapping)each.getMapping();
        }
        return null;
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        if (mapping.isRelationshipOwner()) {
            return this.relationshipReference.isOwnedBy((RelationshipMapping)mapping);
        }
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return this.relationshipReference.isOverridableAssociation();
    }

    protected JavaCascade2_0 buildCascade() {
        return new GenericJavaCascade(this);
    }

    @Override
    public JavaCascade2_0 getCascade() {
        return this.cascade;
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.getDefaultFetch();
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        ((RelationshipMapping2_0Annotation)this.mappingAnnotation).setFetch(FetchType.toJavaResourceModel(fetch));
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected FetchType getResourceFetch() {
        return FetchType.fromJavaResourceModel(((RelationshipMapping2_0Annotation)this.mappingAnnotation).getFetch());
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return this.relationshipReference.javaCompletionProposals(pos, filter, astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateTargetEntity(messages, astRoot);
        this.relationshipReference.validate(messages, reporter, astRoot);
    }

    protected void validateTargetEntity(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTargetEntity() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_NOT_DEFINED", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
        } else if (this.resolvedTargetEntity == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getTargetEntity(), this.getName()}, this, this.getTargetEntityTextRange(astRoot)));
        }
    }

    protected TextRange getTargetEntityTextRange(CompilationUnit astRoot) {
        return this.getTextRange(((RelationshipMapping2_0Annotation)this.mappingAnnotation).getTargetEntityTextRange(astRoot), astRoot);
    }

    protected TextRange getTextRange(TextRange textRange, CompilationUnit astRoot) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public String getMetamodelTypeName() {
        return this.fullyQualifiedTargetEntity != null ? this.fullyQualifiedTargetEntity : MetamodelField.DEFAULT_TYPE_NAME;
    }
}

