/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.jpa1.context.orm.GenericOrmCascade;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.core.resource.orm.AbstractXmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmRelationshipMapping<T extends AbstractXmlRelationshipMapping>
extends AbstractOrmAttributeMapping<T>
implements OrmRelationshipMapping {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected PersistentType resolvedTargetType;
    protected Entity resolvedTargetEntity;
    protected final OrmRelationshipReference relationshipReference = this.buildRelationshipReference();
    protected final OrmCascade2_0 cascade = this.buildCascade();
    protected FetchType specifiedFetch;

    protected AbstractOrmRelationshipMapping(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        this.specifiedTargetEntity = this.getResourceTargetEntity();
        this.defaultTargetEntity = this.buildDefaultTargetEntity();
        this.resolvedTargetType = this.resolveTargetType();
        this.resolvedTargetEntity = this.resolveTargetEntity();
        this.specifiedFetch = this.getResourceFetch();
    }

    @Override
    public void update() {
        super.update();
        this.relationshipReference.update();
        this.cascade.update();
        this.setSpecifiedTargetEntity_(this.getResourceTargetEntity());
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.resolvedTargetType = this.resolveTargetType();
        this.setResolvedTargetEntity(this.resolveTargetEntity());
        this.setSpecifiedFetch_(this.getResourceFetch());
    }

    protected abstract OrmRelationshipReference buildRelationshipReference();

    @Override
    public OrmPersistentAttribute getParent() {
        return (OrmPersistentAttribute)super.getParent();
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.relationshipReference.isRelationshipOwner();
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        if (mapping.isRelationshipOwner()) {
            return this.relationshipReference.isOwnedBy((RelationshipMapping)mapping);
        }
        return false;
    }

    @Override
    public RelationshipMapping getRelationshipOwner() {
        Entity targetEntity = this.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        for (PersistentAttribute each : CollectionTools.iterable(targetEntity.getPersistentType().allAttributes())) {
            if (!this.isOwnedBy(each.getMapping())) continue;
            return (RelationshipMapping)each.getMapping();
        }
        return null;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return this.relationshipReference.isOverridableAssociation();
    }

    @Override
    public char getTargetEntityEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        ((AbstractXmlRelationshipMapping)this.resourceAttributeMapping).setTargetEntity(targetEntity);
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    protected void setSpecifiedTargetEntity_(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String targetEntity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = targetEntity;
        this.firePropertyChanged("defaultTargetEntity", old, targetEntity);
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    protected void setResolvedTargetEntity(Entity targetEntity) {
        Entity old = this.resolvedTargetEntity;
        this.resolvedTargetEntity = targetEntity;
        this.firePropertyChanged("resolvedTargetEntity", old, targetEntity);
    }

    public PersistentType getResolvedTargetType() {
        return this.resolvedTargetType;
    }

    protected PersistentType resolveTargetType() {
        return this.resolvePersistentType(this.getTargetEntity());
    }

    protected String getResourceTargetEntity() {
        return ((AbstractXmlRelationshipMapping)this.resourceAttributeMapping).getTargetEntity();
    }

    protected String buildDefaultTargetEntity() {
        if (this.getJavaPersistentAttribute() != null) {
            return this.getResourceDefaultTargetEntity();
        }
        return null;
    }

    protected abstract String getResourceDefaultTargetEntity();

    protected Entity resolveTargetEntity() {
        if (this.resolvedTargetType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedTargetType.getMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public OrmRelationshipReference getRelationshipReference() {
        return this.relationshipReference;
    }

    protected OrmCascade2_0 buildCascade() {
        return new GenericOrmCascade(this, (AbstractXmlRelationshipMapping)this.resourceAttributeMapping);
    }

    @Override
    public OrmCascade2_0 getCascade() {
        return this.cascade;
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.getDefaultFetch();
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        ((AbstractXmlRelationshipMapping)this.resourceAttributeMapping).setFetch(FetchType.toOrmResourceModel(fetch));
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected FetchType getResourceFetch() {
        return FetchType.fromOrmResourceModel(((AbstractXmlRelationshipMapping)this.resourceAttributeMapping).getFetch());
    }

    @Override
    public void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        super.initializeFromOrmRelationshipMapping(oldMapping);
        this.setSpecifiedTargetEntity(oldMapping.getSpecifiedTargetEntity());
        this.setSpecifiedFetch(oldMapping.getSpecifiedFetch());
        oldMapping.getRelationshipReference().initializeOn(this.relationshipReference);
        this.cascade.initializeFrom(oldMapping.getCascade());
    }

    @Override
    public Iterator<String> allTargetEntityAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.allTargetEntityAttributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allMappingNames();
            }
        });
    }

    public Iterator<AttributeMapping> allTargetEntityAttributeMappings() {
        return this.resolvedTargetEntity != null ? this.resolvedTargetEntity.allAttributeMappings() : EmptyIterator.instance();
    }

    protected String getTargetEntityIdAttributeName() {
        PersistentAttribute attribute = this.getTargetEntityIdAttribute();
        return attribute == null ? null : attribute.getName();
    }

    protected PersistentAttribute getTargetEntityIdAttribute() {
        return this.resolvedTargetEntity == null ? null : this.resolvedTargetEntity.getIdAttribute();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateTargetEntity(messages);
        this.relationshipReference.validate(messages, reporter);
    }

    protected void validateTargetEntity(List<IMessage> messages) {
        if (this.getTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_NOT_DEFINED", new String[]{this.getName()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_NOT_DEFINED", new String[]{this.getName()}, this, this.getValidationTextRange()));
            }
        } else if (this.getResolvedTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getName(), this.getTargetEntity()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getTargetEntity(), this.getName()}, this, this.getTargetEntityTextRange()));
            }
        }
    }

    protected TextRange getTextRange(TextRange textRange) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    protected TextRange getTargetEntityTextRange() {
        return this.getTextRange(((AbstractXmlRelationshipMapping)this.getResourceAttributeMapping()).getTargetEntityTextRange());
    }

    @Override
    public String getMetamodelTypeName() {
        if (this.resolvedTargetType == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        String targetTypeName = this.resolvedTargetType.getName();
        return targetTypeName != null ? targetTypeName : MetamodelField.DEFAULT_TYPE_NAME;
    }
}

