/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.BaseNamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableQueryHintAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceBaseNamedQueryAnnotation
extends SourceAnnotation<Type>
implements BaseNamedQueryAnnotation {
    final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    final AnnotationElementAdapter<String> nameAdapter;
    String name;
    final DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter;
    final AnnotationElementAdapter<String> queryAdapter;
    String query;
    final Vector<NestableQueryHintAnnotation> hints = new Vector();
    final HintsAnnotationContainer hintsContainer = new HintsAnnotationContainer();

    SourceBaseNamedQueryAnnotation(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, type, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter(daa);
        this.queryDeclarationAdapter = this.buildQueryAdapter(daa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.queryAdapter = this.buildAdapter(this.queryDeclarationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.query = this.buildQuery(astRoot);
        AnnotationContainerTools.initialize(this.hintsContainer, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncQuery(this.buildQuery(astRoot));
        AnnotationContainerTools.synchronize(this.hintsContainer, astRoot);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new MemberAnnotationElementAdapter<String>(this.member, daea);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue(name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daAdapter, this.getNameElementName());
    }

    abstract String getNameElementName();

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        if (this.attributeValueHasChanged(this.query, query)) {
            this.query = query;
            this.queryAdapter.setValue(query);
        }
    }

    private void syncQuery(String annotationQuery) {
        String old = this.query;
        this.query = annotationQuery;
        this.firePropertyChanged("query", old, annotationQuery);
    }

    private String buildQuery(CompilationUnit astRoot) {
        return this.queryAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getQueryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.queryDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildQueryAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daAdapter, this.getQueryElementName());
    }

    abstract String getQueryElementName();

    @Override
    public ListIterator<QueryHintAnnotation> hints() {
        return new CloneListIterator(this.hints);
    }

    Iterable<NestableQueryHintAnnotation> getNestableHints() {
        return new LiveCloneIterable(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public NestableQueryHintAnnotation hintAt(int index) {
        return this.hints.get(index);
    }

    @Override
    public int indexOfHint(QueryHintAnnotation hint) {
        return this.hints.indexOf(hint);
    }

    @Override
    public NestableQueryHintAnnotation addHint(int index) {
        return (NestableQueryHintAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.hintsContainer);
    }

    NestableQueryHintAnnotation addHint_() {
        return this.addHint_(this.hints.size());
    }

    private NestableQueryHintAnnotation addHint_(int index) {
        NestableQueryHintAnnotation hint = this.buildHint(index);
        this.hints.add(hint);
        return hint;
    }

    void syncAddHint(Annotation astAnnotation) {
        int index = this.hints.size();
        NestableQueryHintAnnotation hint = this.addHint_(index);
        hint.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("hints", index, hint);
    }

    abstract NestableQueryHintAnnotation buildHint(int var1);

    void hintAdded(int index, NestableQueryHintAnnotation hint) {
        this.fireItemAdded("hints", index, hint);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.hintsContainer);
    }

    NestableQueryHintAnnotation moveHint_(int targetIndex, int sourceIndex) {
        return (NestableQueryHintAnnotation)CollectionTools.move(this.hints, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void removeHint(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.hintsContainer);
    }

    NestableQueryHintAnnotation removeHint_(int index) {
        return this.hints.remove(index);
    }

    void syncRemoveHints(int index) {
        this.removeItemsFromList(index, this.hints, "hints");
    }

    abstract String getHintsElementName();

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        BaseNamedQueryAnnotation oldQuery = (BaseNamedQueryAnnotation)((Object)oldAnnotation);
        this.setName(oldQuery.getName());
        this.setQuery(oldQuery.getQuery());
        for (QueryHintAnnotation oldHint : CollectionTools.iterable(oldQuery.hints())) {
            NestableQueryHintAnnotation newHint = this.addHint(oldQuery.indexOfHint(oldHint));
            newHint.initializeFrom((NestableQueryHintAnnotation)oldHint);
        }
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HintsAnnotationContainer
    implements AnnotationContainer<NestableQueryHintAnnotation> {
        HintsAnnotationContainer() {
        }

        @Override
        public Annotation getAstAnnotation(CompilationUnit astRoot) {
            return SourceBaseNamedQueryAnnotation.this.getAstAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return SourceBaseNamedQueryAnnotation.this.getHintsElementName();
        }

        @Override
        public String getNestedAnnotationName() {
            return "javax.persistence.QueryHint";
        }

        @Override
        public Iterable<NestableQueryHintAnnotation> getNestedAnnotations() {
            return SourceBaseNamedQueryAnnotation.this.getNestableHints();
        }

        @Override
        public int getNestedAnnotationsSize() {
            return SourceBaseNamedQueryAnnotation.this.hintsSize();
        }

        @Override
        public NestableQueryHintAnnotation addNestedAnnotation() {
            return SourceBaseNamedQueryAnnotation.this.addHint_();
        }

        @Override
        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceBaseNamedQueryAnnotation.this.syncAddHint(astAnnotation);
        }

        @Override
        public NestableQueryHintAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceBaseNamedQueryAnnotation.this.moveHint_(targetIndex, sourceIndex);
        }

        @Override
        public NestableQueryHintAnnotation removeNestedAnnotation(int index) {
            return SourceBaseNamedQueryAnnotation.this.removeHint_(index);
        }

        @Override
        public void syncRemoveNestedAnnotations(int index) {
            SourceBaseNamedQueryAnnotation.this.syncRemoveHints(index);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

