/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.GlobalCommandManager;
import org.eclipse.wst.server.ui.internal.editor.IServerEditorInput;
import org.eclipse.wst.server.ui.internal.editor.IServerEditorPartFactory;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorActionFactory;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorCore;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;
import org.eclipse.wst.server.ui.internal.editor.StatusLineContributionItem;
import org.eclipse.wst.server.ui.internal.editor.TextAction;

public class ServerEditor
extends MultiPageEditorPart {
    protected IServerWorkingCopy server;
    protected String serverId;
    protected String serverName;
    protected GlobalCommandManager commandManager;
    protected PropertyChangeListener listener;
    protected IAction undoAction;
    protected IAction redoAction;
    protected TextAction cutAction;
    protected TextAction copyAction;
    protected TextAction pasteAction;
    protected boolean updatingActions;
    protected IAction[] editorActions;
    protected List<IEditorPart> serverPages;
    protected boolean resourceDeleted;
    protected IServerEditorPartInput editorPartInput;
    protected IStatusLineManager status;
    protected StatusLineContributionItem statusItem;
    private ActivationListener activationListener = new ActivationListener();
    protected LifecycleListener resourceListener;
    protected boolean isSaving = false;
    protected Map<IEditorPart, IServerEditorPartFactory> pageToFactory = new HashMap<IEditorPart, IServerEditorPartFactory>();

    public ServerEditor() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = new Action(){

            public void run() {
                ServerEditor.this.getCommandManager().undo(ServerEditor.this.serverId);
            }
        };
        this.undoAction.setEnabled(false);
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.redoAction = new Action(){

            public void run() {
                ServerEditor.this.getCommandManager().redo(ServerEditor.this.serverId);
            }
        };
        this.redoAction.setEnabled(false);
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
    }

    protected void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServerEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)ServerEditor.this, false);
            }
        });
    }

    protected void createActions() {
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        if (this.server != null && this.server.getServerType() != null) {
            Iterator iterator = ServerEditorCore.getServerEditorActionFactories().iterator();
            String id = this.server.getServerType().getId();
            while (iterator.hasNext()) {
                ServerEditorActionFactory factory = (ServerEditorActionFactory)iterator.next();
                if (!factory.supportsServerElementType(id) || !factory.shouldDisplay(this.server)) continue;
                actionList.add(factory.createAction(this.getEditorSite(), this.editorPartInput));
            }
        }
        this.editorActions = new IAction[actionList.size()];
        actionList.toArray(this.editorActions);
    }

    public IServerEditorPartFactory getPageFactory(ServerEditorPart part) {
        try {
            return this.pageToFactory.get((Object)part);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void createPages() {
        block9: {
            try {
                int index = 0;
                this.serverPages = new ArrayList<IEditorPart>();
                int pageCount = 0;
                String serverTypeId = null;
                if (this.server != null && this.server.getServerType() != null) {
                    serverTypeId = this.server.getServerType().getId();
                }
                for (IServerEditorPartFactory iServerEditorPartFactory : ServerEditorCore.getServerEditorPageFactories()) {
                    if (!iServerEditorPartFactory.supportsType(serverTypeId) || !iServerEditorPartFactory.shouldCreatePage(this.server)) continue;
                    if (Trace.FINEST) {
                        Trace.trace("/finest", "Adding page: " + iServerEditorPartFactory.getId() + " " + this.editorPartInput);
                    }
                    try {
                        IEditorPart page = iServerEditorPartFactory.createPage();
                        if (page == null) continue;
                        this.pageToFactory.put(page, iServerEditorPartFactory);
                        index = this.addPage(page, this.editorPartInput);
                        this.setPageText(index, iServerEditorPartFactory.getName());
                        this.serverPages.add(page);
                        ++pageCount;
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) continue;
                        Trace.trace("/severe", "Could not display editor page " + iServerEditorPartFactory.getId(), e);
                    }
                }
                if (pageCount > 0) {
                    this.setActivePage(0);
                }
                int n = this.getPageCount();
                int i = 0;
                while (i < n) {
                    Control control = this.getControl(i);
                    this.registerEvents(control);
                    ++i;
                }
                this.updateActions();
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block9;
                Trace.trace("/severe", "Error creating server editor pages", e);
            }
        }
    }

    public void dispose() {
        block9: {
            if (this.activationListener != null) {
                IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
                window.getPartService().removePartListener((IPartListener)this.activationListener);
                Shell shell = window.getShell();
                if (shell != null && !shell.isDisposed()) {
                    shell.removeShellListener((ShellListener)this.activationListener);
                }
                this.activationListener = null;
            }
            if (this.resourceListener != null) {
                ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.resourceListener);
            }
            if (!(this.serverName == null || this.server.getName().equals(this.serverName) || this.server.getServerConfiguration() == null && ((Server)this.server).getFile() == null)) {
                String title = Messages.editorServerEditor;
                String message = Messages.editorRenameFiles;
                if (MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)title, (String)message)) {
                    try {
                        ((ServerWorkingCopy)this.server).renameFiles(null);
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) break block9;
                        Trace.trace("/severe", "Error renaming server", e);
                    }
                }
            }
        }
        super.dispose();
        if (this.commandManager != null) {
            this.commandManager.removePropertyChangeListener(this.listener);
            if (this.serverId != null) {
                this.commandManager.releaseCommandManager(this.serverId);
            }
            this.commandManager = null;
        }
    }

    public void doSave(IProgressMonitor monitor) {
        block19: {
            this.isSaving = true;
            ArrayList<String> errors = new ArrayList<String>();
            Iterator<Object> iterator = this.serverPages.iterator();
            int count = 0;
            int maxSeverity = -1;
            while (iterator.hasNext()) {
                IStatus[] status2;
                IEditorPart part = iterator.next();
                if (part instanceof ServerEditorPart && (status2 = ((ServerEditorPart)part).getSaveStatus()) != null) {
                    int size = status2.length;
                    int i = 0;
                    while (i < size) {
                        errors.add("[" + this.getPageText(count) + "] " + status2[i].getMessage());
                        maxSeverity = Math.max(maxSeverity, status2[i].getSeverity());
                        ++i;
                    }
                }
                ++count;
            }
            if (!errors.isEmpty() && maxSeverity > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(String.valueOf(Messages.errorEditorCantSave) + "\n");
                iterator = errors.iterator();
                while (iterator.hasNext()) {
                    sb.append("\t" + (String)iterator.next() + "\n");
                }
                if (maxSeverity == 4) {
                    MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)this.getPartName(), (String)sb.toString());
                    monitor.setCanceled(true);
                    this.isSaving = false;
                    return;
                }
                if (maxSeverity == 2) {
                    MessageDialog.openWarning((Shell)this.getEditorSite().getShell(), (String)this.getPartName(), (String)sb.toString());
                } else {
                    MessageDialog.openInformation((Shell)this.getEditorSite().getShell(), (String)this.getPartName(), (String)sb.toString());
                }
            }
            try {
                try {
                    monitor = ProgressUtil.getMonitorFor(monitor);
                    int ticks = 2000;
                    int pages = this.serverPages == null ? 0 : this.serverPages.size();
                    int pagesTicks = pages * 100;
                    String name = "";
                    if (this.server != null) {
                        name = this.server.getName();
                    }
                    monitor.beginTask(NLS.bind((String)Messages.savingTask, (Object)name), ticks + pagesTicks);
                    if (this.server != null) {
                        ticks /= 2;
                    }
                    if (this.server != null) {
                        for (IEditorPart part : this.serverPages) {
                            part.doSave(ProgressUtil.getSubMonitorFor(monitor, 100));
                        }
                        this.server.save(false, ProgressUtil.getSubMonitorFor(monitor, ticks));
                        this.getCommandManager().resourceSaved(this.serverId);
                        this.commandManager.updateTimestamps(this.serverId);
                    }
                    ILabelProvider labelProvider = ServerUICore.getLabelProvider();
                    if (this.server != null) {
                        this.setPartName(labelProvider.getText((Object)this.server));
                    }
                    labelProvider.dispose();
                }
                catch (Exception e) {
                    if (Trace.SEVERE) {
                        Trace.trace("/severe", "Error saving server editor", e);
                    }
                    monitor.setCanceled(true);
                    String title = Messages.editorSaveErrorDialog;
                    String message = NLS.bind((String)Messages.editorSaveErrorMessage, (Object)e.getLocalizedMessage());
                    MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
                    monitor.done();
                    break block19;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        this.isSaving = false;
    }

    public void doSaveAs() {
    }

    protected void firePropertyChange(int i) {
        if (i == 5) {
            this.updateStatusError();
        }
        super.firePropertyChange(i);
    }

    public GlobalCommandManager getCommandManager() {
        return this.commandManager;
    }

    public IAction getRedoAction() {
        return this.redoAction;
    }

    public IAction getUndoAction() {
        return this.undoAction;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void updateActionsImpl() {
        if (this.updatingActions) {
            return;
        }
        this.updatingActions = true;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ServerEditor.this.updatingActions = false;
                ServerEditor.this.updateActions();
            }
        });
    }

    public void updateActions() {
        this.cutAction.update();
        this.copyAction.update();
        this.pasteAction.update();
    }

    protected void updateStatusLine() {
        if (this.statusItem != null) {
            boolean readOnly = false;
            if (this.server != null && this.commandManager.isReadOnly(this.serverId)) {
                readOnly = true;
            }
            if (readOnly) {
                this.statusItem.setText(Messages.editorReadOnly);
            } else {
                this.statusItem.setText(Messages.editorWritable);
            }
        }
        if (this.status != null) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            if (this.server != null) {
                IFile[] files = this.commandManager.getReadOnlyFiles(this.serverId);
                int i = 0;
                while (i < files.length) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(files[i].getName());
                    first = false;
                    ++i;
                }
            }
            if (sb.length() > 1) {
                this.status.setMessage(NLS.bind((String)Messages.editorReadOnlyFiles, (Object)sb.toString()));
            } else {
                this.status.setMessage("");
            }
        }
    }

    public void updateStatusError() {
        if (this.status == null) {
            return;
        }
        String error = null;
        IEditorPart part = this.getActiveEditor();
        if (part instanceof ServerEditorPart) {
            error = ((ServerEditorPart)part).getErrorMessage();
        }
        Iterator<IEditorPart> iterator = this.serverPages.iterator();
        int count = 0;
        while (error == null && iterator.hasNext()) {
            part = iterator.next();
            if (part instanceof ServerEditorPart && (error = ((ServerEditorPart)part).getErrorMessage()) != null) {
                error = "[" + this.getPageText(count) + "] " + error;
            }
            ++count;
        }
        this.status.setErrorMessage(error);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.updateStatusError();
    }

    public void setStatus(IStatusLineManager status, StatusLineContributionItem item) {
        this.status = status;
        this.statusItem = item;
        this.updateStatusError();
    }

    protected void registerEvents(Control control) {
        Control[] children;
        if (control == null) {
            return;
        }
        if (control instanceof Text || control instanceof Combo) {
            control.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent event) {
                    ServerEditor.this.updateActionsImpl();
                }
            });
            control.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    ServerEditor.this.updateActionsImpl();
                }

                public void keyReleased(KeyEvent event) {
                    ServerEditor.this.updateActionsImpl();
                }
            });
            control.addMouseListener(new MouseListener(){

                public void mouseDown(MouseEvent event) {
                }

                public void mouseUp(MouseEvent event) {
                    ServerEditor.this.updateActionsImpl();
                }

                public void mouseDoubleClick(MouseEvent event) {
                    ServerEditor.this.updateActionsImpl();
                }
            });
            control.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent event) {
                    ServerEditor.this.updateActionsImpl();
                }

                public void focusLost(FocusEvent event) {
                    ServerEditor.this.updateActionsImpl();
                }
            });
            if (control instanceof Text) {
                Text text = (Text)control;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        ServerEditor.this.updateActionsImpl();
                    }
                });
                text.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        ServerEditor.this.updateActionsImpl();
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                        ServerEditor.this.updateActionsImpl();
                    }
                });
            } else {
                Combo combo = (Combo)control;
                combo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        ServerEditor.this.updateActionsImpl();
                    }
                });
                combo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        ServerEditor.this.updateActionsImpl();
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                        ServerEditor.this.updateActionsImpl();
                    }
                });
            }
        }
        if (control instanceof Composite && (children = ((Composite)control).getChildren()) != null) {
            int size = children.length;
            int i = 0;
            while (i < size) {
                this.registerEvents(children[i]);
                ++i;
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.commandManager = GlobalCommandManager.getInstance();
        super.init(site, input);
        if (input instanceof IFileEditorInput) {
            IServer server2;
            IFileEditorInput fei = (IFileEditorInput)input;
            IFile file = fei.getFile();
            if (file != null && file.exists() && (server2 = ServerUIPlugin.findServer(file)) != null) {
                this.serverId = server2.getId();
            }
            if (this.serverId == null) {
                if (file == null) {
                    throw new PartInitException(NLS.bind((String)Messages.errorEditor, (Object)Messages.elementUnknownName));
                }
                throw new PartInitException(NLS.bind((String)Messages.errorEditor, (Object)file.getName()));
            }
        } else if (input instanceof IServerEditorInput) {
            IServerEditorInput sei = (IServerEditorInput)input;
            this.serverId = sei.getServerId();
        }
        if (this.serverId != null) {
            this.commandManager.getCommandManager(this.serverId);
            this.server = this.commandManager.getServerResource(this.serverId);
        }
        ILabelProvider labelProvider = ServerUICore.getLabelProvider();
        if (this.server != null) {
            this.setPartName(labelProvider.getText((Object)this.server));
            this.setTitleImage(labelProvider.getImage((Object)this.server));
            this.setTitleToolTip(this.serverId);
            this.serverName = this.server.getName();
        } else {
            this.setPartName("-");
        }
        labelProvider.dispose();
        labelProvider = null;
        this.cutAction = new TextAction(site.getShell().getDisplay(), 0);
        this.copyAction = new TextAction(site.getShell().getDisplay(), 1);
        this.pasteAction = new TextAction(site.getShell().getDisplay(), 2);
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object obj;
                if ("dirtyState".equals(event.getPropertyName())) {
                    Object obj2 = event.getOldValue();
                    if (obj2 == ServerEditor.this.serverId) {
                        ServerEditor.this.firePropertyChange(257);
                    }
                } else if ("undoAction".equals(event.getPropertyName())) {
                    Object obj3 = event.getOldValue();
                    if (obj3 == ServerEditor.this.serverId) {
                        ServerEditor.this.updateUndoAction();
                    }
                } else if ("redoAction".equals(event.getPropertyName())) {
                    Object obj4 = event.getOldValue();
                    if (obj4 == ServerEditor.this.serverId) {
                        ServerEditor.this.updateRedoAction();
                    }
                } else if ("reload".equals(event.getPropertyName()) && (obj = event.getOldValue()) == ServerEditor.this.serverId) {
                    ServerEditor.this.server = ServerEditor.this.commandManager.getServerResource(ServerEditor.this.serverId);
                    ServerEditor.this.refresh();
                }
            }
        };
        if (this.server != null && this.commandManager.isDirty(this.serverId)) {
            this.firePropertyChange(257);
        }
        this.commandManager.addPropertyChangeListener(this.listener);
        ServerResourceCommandManager serverCommandManager = null;
        if (this.server != null) {
            serverCommandManager = new ServerResourceCommandManager(this, this.serverId, this.commandManager);
        }
        this.editorPartInput = this.commandManager.getPartInput(this.serverId, serverCommandManager);
        this.createActions();
        this.resourceListener = new LifecycleListener();
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.resourceListener);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.getPartService().addPartListener((IPartListener)this.activationListener);
        window.getShell().addShellListener((ShellListener)this.activationListener);
    }

    public boolean isDirty() {
        return this.commandManager != null && this.server != null && this.commandManager.isDirty(this.serverId);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void updateUndoAction() {
        IUndoableOperation command = this.commandManager.getUndoCommand(this.serverId);
        if (command == null) {
            this.undoAction.setText(Messages.editorUndoDisabled);
            this.undoAction.setToolTipText("");
            this.undoAction.setDescription("");
            this.undoAction.setEnabled(false);
        } else {
            String text = NLS.bind((String)Messages.editorUndoEnabled, (Object[])new Object[]{command.getLabel()});
            this.undoAction.setText(text);
            this.undoAction.setToolTipText(command.getLabel());
            this.undoAction.setDescription(command.getLabel());
            this.undoAction.setEnabled(true);
        }
    }

    protected void updateRedoAction() {
        IUndoableOperation command = this.commandManager.getRedoCommand(this.serverId);
        if (command == null) {
            this.redoAction.setText(Messages.editorRedoDisabled);
            this.redoAction.setToolTipText("");
            this.redoAction.setDescription("");
            this.redoAction.setEnabled(false);
        } else {
            String text = NLS.bind((String)Messages.editorRedoEnabled, (Object[])new Object[]{command.getLabel()});
            this.redoAction.setText(text);
            this.redoAction.setToolTipText(command.getLabel());
            this.redoAction.setDescription(command.getLabel());
            this.redoAction.setEnabled(true);
        }
    }

    public IAction getCutAction() {
        return this.cutAction;
    }

    public IAction getCopyAction() {
        return this.copyAction;
    }

    public IAction getPasteAction() {
        return this.pasteAction;
    }

    public IAction[] getEditorActions() {
        return this.editorActions;
    }

    protected void refresh() {
        ServerResourceCommandManager serverCommandManager = null;
        if (this.server != null) {
            serverCommandManager = new ServerResourceCommandManager(this, this.serverId, this.commandManager);
        }
        this.editorPartInput = this.commandManager.getPartInput(this.serverId, serverCommandManager);
        for (IEditorPart part : this.serverPages) {
            try {
                part.init(part.getEditorSite(), (IEditorInput)this.editorPartInput);
            }
            catch (Exception e) {
                if (!Trace.SEVERE) continue;
                Trace.trace("/severe", "Error refresh()ing editor part", e);
            }
        }
    }

    protected void promptReadOnlyServerFile(String id) {
        this.commandManager.setReadOnly(id, true);
        String title = Messages.editorResourceModifiedTitle;
        String message = Messages.editorReadOnlyMessage;
        MessageDialog.openInformation((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
    }

    protected void promptReloadServerFile(String id) {
        String title = Messages.editorResourceModifiedTitle;
        String message = Messages.editorServerModifiedMessage;
        if (MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)title, (String)message)) {
            this.commandManager.reload(id);
        }
    }

    public void setFocus() {
        super.setFocus();
    }

    void checkAndCloseEditorOnDeletedServer() {
        if (this.resourceDeleted) {
            String title = Messages.editorResourceDeleteTitle;
            String message = null;
            if (this.server != null) {
                message = NLS.bind((String)Messages.editorResourceDeleteServerMessage, (Object)this.server.getName());
            }
            String[] labels = new String[]{Messages.editorResourceDeleteSave, IDialogConstants.CLOSE_LABEL};
            MessageDialog dialog = new MessageDialog(this.getEditorSite().getShell(), title, null, message, 2, labels, 0);
            if (dialog.open() == 0) {
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            } else {
                this.closeEditor();
            }
        }
        this.resourceDeleted = false;
    }

    protected void checkResourceState() {
        if (this.isSaving) {
            return;
        }
        this.checkAndCloseEditorOnDeletedServer();
        if (this.serverId != null) {
            if (!this.commandManager.isDirty(this.serverId)) {
                if (this.commandManager.hasChanged(this.serverId)) {
                    IServer newServer = ServerCore.findServer((String)this.serverId);
                    if (newServer != null && ((Server)newServer).getTimestamp() > ((Server)this.server).getTimestamp()) {
                        this.commandManager.reload(this.serverId);
                    } else {
                        this.promptReloadServerFile(this.serverId);
                    }
                }
            } else if (this.commandManager.hasChanged(this.serverId) && !this.commandManager.areFilesReadOnly(this.serverId)) {
                this.promptReloadServerFile(this.serverId);
            } else if (this.commandManager.areFilesReadOnly(this.serverId) && !this.commandManager.isReadOnly(this.serverId)) {
                this.promptReadOnlyServerFile(this.serverId);
            }
            if (this.commandManager.isReadOnly(this.serverId) && !this.commandManager.areFilesReadOnly(this.serverId)) {
                this.commandManager.setReadOnly(this.serverId, false);
            }
            this.commandManager.updateTimestamps(this.serverId);
        }
        this.updateStatusLine();
    }

    public String getTitleToolTip() {
        Server server2 = (Server)this.server;
        if (this.server != null && server2.getFile() != null) {
            return server2.getFile().getFullPath().toString();
        }
        if (this.server != null) {
            return this.server.getName();
        }
        return "error";
    }

    public int getOrientation() {
        return Window.getDefaultOrientation();
    }

    class ActivationListener
    extends ShellAdapter
    implements IPartListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;

        ActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void shellActivated(ShellEvent e) {
            this.handleActivation();
        }

        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart == ServerEditor.this) {
                this.fIsHandlingActivation = true;
                try {
                    ServerEditor.this.checkResourceState();
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }
    }

    class LifecycleListener
    implements IServerLifecycleListener {
        LifecycleListener() {
        }

        public void serverAdded(IServer oldServer) {
        }

        public void serverChanged(IServer oldServer) {
        }

        public void serverRemoved(IServer oldServer) {
            if (oldServer.equals(ServerEditor.this.server.getOriginal())) {
                ServerEditor.this.resourceDeleted = true;
                if (!ServerEditor.this.isDirty()) {
                    ServerEditor.this.closeEditor();
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ServerEditor.this.checkAndCloseEditorOnDeletedServer();
                        }
                    });
                }
            }
        }
    }
}

