/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.jpa2.resource.java.ElementCollection2_0Annotation;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.ExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceElementCollection2_0Annotation
extends SourceAnnotation<Attribute>
implements ElementCollection2_0Annotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.ElementCollection");
    private static final DeclarationAnnotationElementAdapter<String> TARGET_CLASS_ADAPTER = SourceElementCollection2_0Annotation.buildTargetClassAdapter();
    private final AnnotationElementAdapter<String> targetClassAdapter;
    private String targetClass;
    String fullyQualifiedTargetClassName;
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceElementCollection2_0Annotation.buildFetchAdapter();
    private final AnnotationElementAdapter<String> fetchAdapter;
    private FetchType fetch;

    public SourceElementCollection2_0Annotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.targetClassAdapter = new MemberAnnotationElementAdapter<String>(attribute, TARGET_CLASS_ADAPTER);
        this.fetchAdapter = new MemberAnnotationElementAdapter<String>(attribute, FETCH_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.ElementCollection";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.targetClass = this.buildTargetClass(astRoot);
        this.fullyQualifiedTargetClassName = this.buildFullyQualifiedTargetClassName(astRoot);
        this.fetch = this.buildFetch(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncTargetClass(this.buildTargetClass(astRoot));
        this.syncFullyQualifiedTargetClassName(this.buildFullyQualifiedTargetClassName(astRoot));
        this.syncFetch(this.buildFetch(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.targetClass);
    }

    @Override
    public String getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void setTargetClass(String targetClass) {
        if (this.attributeValueHasChanged(this.targetClass, targetClass)) {
            this.targetClass = targetClass;
            this.targetClassAdapter.setValue(targetClass);
        }
    }

    private void syncTargetClass(String astTargetClass) {
        String old = this.targetClass;
        this.targetClass = astTargetClass;
        this.firePropertyChanged("targetClass", old, astTargetClass);
    }

    private String buildTargetClass(CompilationUnit astRoot) {
        return this.targetClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTargetClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TARGET_CLASS_ADAPTER, astRoot);
    }

    @Override
    public String getFullyQualifiedTargetClassName() {
        return this.fullyQualifiedTargetClassName;
    }

    private void syncFullyQualifiedTargetClassName(String name) {
        String old = this.fullyQualifiedTargetClassName;
        this.fullyQualifiedTargetClassName = name;
        this.firePropertyChanged("fullyQualifiedTargetClassName", old, name);
    }

    private String buildFullyQualifiedTargetClassName(CompilationUnit astRoot) {
        return this.targetClass == null ? null : ASTTools.resolveFullyQualifiedName(this.targetClassAdapter.getExpression(astRoot));
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        if (this.attributeValueHasChanged((Object)this.fetch, (Object)fetch)) {
            this.fetch = fetch;
            this.fetchAdapter.setValue(FetchType.toJavaAnnotationValue(fetch));
        }
    }

    private void syncFetch(FetchType astFetch) {
        FetchType old = this.fetch;
        this.fetch = astFetch;
        this.firePropertyChanged("fetch", (Object)old, (Object)astFetch);
    }

    private FetchType buildFetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(FETCH_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch", false);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetClassAdapter() {
        return SourceElementCollection2_0Annotation.buildTargetClassAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetClass");
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetClassAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceElementCollection2_0Annotation.buildAnnotationElementAdapter(annotationAdapter, elementName, SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, false, converter);
    }
}

