/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.validation.internal.ValidatorMutable;
import org.eclipse.wst.validation.internal.model.FilterGroup;

public final class ValidatorHelper {
    public static boolean hasExcludeGroup(ValidatorMutable v) {
        FilterGroup[] filterGroupArray = v.getGroups();
        int n = filterGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilterGroup group = filterGroupArray[n2];
            if (group.isExclude()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Object[] getRuntimes() {
        Iterator runtimes = RuntimeManager.getRuntimes().iterator();
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        while (runtimes.hasNext()) {
            IRuntime runtime1 = (IRuntime)runtimes.next();
            String id = runtime1.getProperty("id");
            if (id == null) continue;
            list.add(runtime1);
        }
        return list.toArray();
    }

    public static String getRuntimeID(Object targetRuntime) {
        IRuntime runtime = (IRuntime)targetRuntime;
        return runtime.getProperty("id");
    }

    public static String getRuntimeName(String id) {
        try {
            IRuntime runtime = RuntimeManager.getRuntime((String)id);
            if (runtime != null) {
                return runtime.getLocalizedName();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    public static String getRuntimeName(Object targetRuntime) {
        IRuntime runtime = (IRuntime)targetRuntime;
        return runtime.getLocalizedName();
    }
}

